/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetKeyspaceResponse extends KeyspacesResponse implements
        ToCopyableBuilder<GetKeyspaceResponse.Builder, GetKeyspaceResponse> {
    private static final SdkField<String> KEYSPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyspaceName").getter(getter(GetKeyspaceResponse::keyspaceName)).setter(setter(Builder::keyspaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceName").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(GetKeyspaceResponse::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> REPLICATION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("replicationStrategy").getter(getter(GetKeyspaceResponse::replicationStrategyAsString))
            .setter(setter(Builder::replicationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationStrategy").build())
            .build();

    private static final SdkField<List<String>> REPLICATION_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("replicationRegions")
            .getter(getter(GetKeyspaceResponse::replicationRegions))
            .setter(setter(Builder::replicationRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ReplicationGroupStatus>> REPLICATION_GROUP_STATUSES_FIELD = SdkField
            .<List<ReplicationGroupStatus>> builder(MarshallingType.LIST)
            .memberName("replicationGroupStatuses")
            .getter(getter(GetKeyspaceResponse::replicationGroupStatuses))
            .setter(setter(Builder::replicationGroupStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationGroupStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationGroupStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationGroupStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYSPACE_NAME_FIELD,
            RESOURCE_ARN_FIELD, REPLICATION_STRATEGY_FIELD, REPLICATION_REGIONS_FIELD, REPLICATION_GROUP_STATUSES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String keyspaceName;

    private final String resourceArn;

    private final String replicationStrategy;

    private final List<String> replicationRegions;

    private final List<ReplicationGroupStatus> replicationGroupStatuses;

    private GetKeyspaceResponse(BuilderImpl builder) {
        super(builder);
        this.keyspaceName = builder.keyspaceName;
        this.resourceArn = builder.resourceArn;
        this.replicationStrategy = builder.replicationStrategy;
        this.replicationRegions = builder.replicationRegions;
        this.replicationGroupStatuses = builder.replicationGroupStatuses;
    }

    /**
     * <p>
     * The name of the keyspace.
     * </p>
     * 
     * @return The name of the keyspace.
     */
    public final String keyspaceName() {
        return keyspaceName;
    }

    /**
     * <p>
     * Returns the ARN of the keyspace.
     * </p>
     * 
     * @return Returns the ARN of the keyspace.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * Returns the replication strategy of the keyspace. The options are <code>SINGLE_REGION</code> or
     * <code>MULTI_REGION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #replicationStrategy} will return {@link Rs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #replicationStrategyAsString}.
     * </p>
     * 
     * @return Returns the replication strategy of the keyspace. The options are <code>SINGLE_REGION</code> or
     *         <code>MULTI_REGION</code>.
     * @see Rs
     */
    public final Rs replicationStrategy() {
        return Rs.fromValue(replicationStrategy);
    }

    /**
     * <p>
     * Returns the replication strategy of the keyspace. The options are <code>SINGLE_REGION</code> or
     * <code>MULTI_REGION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #replicationStrategy} will return {@link Rs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #replicationStrategyAsString}.
     * </p>
     * 
     * @return Returns the replication strategy of the keyspace. The options are <code>SINGLE_REGION</code> or
     *         <code>MULTI_REGION</code>.
     * @see Rs
     */
    public final String replicationStrategyAsString() {
        return replicationStrategy;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationRegions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicationRegions() {
        return replicationRegions != null && !(replicationRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the <code>replicationStrategy</code> of the keyspace is <code>MULTI_REGION</code>, a list of replication
     * Regions is returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationRegions} method.
     * </p>
     * 
     * @return If the <code>replicationStrategy</code> of the keyspace is <code>MULTI_REGION</code>, a list of
     *         replication Regions is returned.
     */
    public final List<String> replicationRegions() {
        return replicationRegions;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationGroupStatuses property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReplicationGroupStatuses() {
        return replicationGroupStatuses != null && !(replicationGroupStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all Regions the keyspace is replicated in after the update keyspace operation and their status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationGroupStatuses} method.
     * </p>
     * 
     * @return A list of all Regions the keyspace is replicated in after the update keyspace operation and their status.
     */
    public final List<ReplicationGroupStatus> replicationGroupStatuses() {
        return replicationGroupStatuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(replicationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationRegions() ? replicationRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationGroupStatuses() ? replicationGroupStatuses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKeyspaceResponse)) {
            return false;
        }
        GetKeyspaceResponse other = (GetKeyspaceResponse) obj;
        return Objects.equals(keyspaceName(), other.keyspaceName()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(replicationStrategyAsString(), other.replicationStrategyAsString())
                && hasReplicationRegions() == other.hasReplicationRegions()
                && Objects.equals(replicationRegions(), other.replicationRegions())
                && hasReplicationGroupStatuses() == other.hasReplicationGroupStatuses()
                && Objects.equals(replicationGroupStatuses(), other.replicationGroupStatuses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetKeyspaceResponse").add("KeyspaceName", keyspaceName()).add("ResourceArn", resourceArn())
                .add("ReplicationStrategy", replicationStrategyAsString())
                .add("ReplicationRegions", hasReplicationRegions() ? replicationRegions() : null)
                .add("ReplicationGroupStatuses", hasReplicationGroupStatuses() ? replicationGroupStatuses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "keyspaceName":
            return Optional.ofNullable(clazz.cast(keyspaceName()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "replicationStrategy":
            return Optional.ofNullable(clazz.cast(replicationStrategyAsString()));
        case "replicationRegions":
            return Optional.ofNullable(clazz.cast(replicationRegions()));
        case "replicationGroupStatuses":
            return Optional.ofNullable(clazz.cast(replicationGroupStatuses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("keyspaceName", KEYSPACE_NAME_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("replicationStrategy", REPLICATION_STRATEGY_FIELD);
        map.put("replicationRegions", REPLICATION_REGIONS_FIELD);
        map.put("replicationGroupStatuses", REPLICATION_GROUP_STATUSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetKeyspaceResponse, T> g) {
        return obj -> g.apply((GetKeyspaceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KeyspacesResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetKeyspaceResponse> {
        /**
         * <p>
         * The name of the keyspace.
         * </p>
         * 
         * @param keyspaceName
         *        The name of the keyspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyspaceName(String keyspaceName);

        /**
         * <p>
         * Returns the ARN of the keyspace.
         * </p>
         * 
         * @param resourceArn
         *        Returns the ARN of the keyspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * Returns the replication strategy of the keyspace. The options are <code>SINGLE_REGION</code> or
         * <code>MULTI_REGION</code>.
         * </p>
         * 
         * @param replicationStrategy
         *        Returns the replication strategy of the keyspace. The options are <code>SINGLE_REGION</code> or
         *        <code>MULTI_REGION</code>.
         * @see Rs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Rs
         */
        Builder replicationStrategy(String replicationStrategy);

        /**
         * <p>
         * Returns the replication strategy of the keyspace. The options are <code>SINGLE_REGION</code> or
         * <code>MULTI_REGION</code>.
         * </p>
         * 
         * @param replicationStrategy
         *        Returns the replication strategy of the keyspace. The options are <code>SINGLE_REGION</code> or
         *        <code>MULTI_REGION</code>.
         * @see Rs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Rs
         */
        Builder replicationStrategy(Rs replicationStrategy);

        /**
         * <p>
         * If the <code>replicationStrategy</code> of the keyspace is <code>MULTI_REGION</code>, a list of replication
         * Regions is returned.
         * </p>
         * 
         * @param replicationRegions
         *        If the <code>replicationStrategy</code> of the keyspace is <code>MULTI_REGION</code>, a list of
         *        replication Regions is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationRegions(Collection<String> replicationRegions);

        /**
         * <p>
         * If the <code>replicationStrategy</code> of the keyspace is <code>MULTI_REGION</code>, a list of replication
         * Regions is returned.
         * </p>
         * 
         * @param replicationRegions
         *        If the <code>replicationStrategy</code> of the keyspace is <code>MULTI_REGION</code>, a list of
         *        replication Regions is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationRegions(String... replicationRegions);

        /**
         * <p>
         * A list of all Regions the keyspace is replicated in after the update keyspace operation and their status.
         * </p>
         * 
         * @param replicationGroupStatuses
         *        A list of all Regions the keyspace is replicated in after the update keyspace operation and their
         *        status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupStatuses(Collection<ReplicationGroupStatus> replicationGroupStatuses);

        /**
         * <p>
         * A list of all Regions the keyspace is replicated in after the update keyspace operation and their status.
         * </p>
         * 
         * @param replicationGroupStatuses
         *        A list of all Regions the keyspace is replicated in after the update keyspace operation and their
         *        status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupStatuses(ReplicationGroupStatus... replicationGroupStatuses);

        /**
         * <p>
         * A list of all Regions the keyspace is replicated in after the update keyspace operation and their status.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.keyspaces.model.ReplicationGroupStatus.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.keyspaces.model.ReplicationGroupStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.keyspaces.model.ReplicationGroupStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #replicationGroupStatuses(List<ReplicationGroupStatus>)}.
         * 
         * @param replicationGroupStatuses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.keyspaces.model.ReplicationGroupStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationGroupStatuses(java.util.Collection<ReplicationGroupStatus>)
         */
        Builder replicationGroupStatuses(Consumer<ReplicationGroupStatus.Builder>... replicationGroupStatuses);
    }

    static final class BuilderImpl extends KeyspacesResponse.BuilderImpl implements Builder {
        private String keyspaceName;

        private String resourceArn;

        private String replicationStrategy;

        private List<String> replicationRegions = DefaultSdkAutoConstructList.getInstance();

        private List<ReplicationGroupStatus> replicationGroupStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetKeyspaceResponse model) {
            super(model);
            keyspaceName(model.keyspaceName);
            resourceArn(model.resourceArn);
            replicationStrategy(model.replicationStrategy);
            replicationRegions(model.replicationRegions);
            replicationGroupStatuses(model.replicationGroupStatuses);
        }

        public final String getKeyspaceName() {
            return keyspaceName;
        }

        public final void setKeyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        @Override
        public final Builder keyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getReplicationStrategy() {
            return replicationStrategy;
        }

        public final void setReplicationStrategy(String replicationStrategy) {
            this.replicationStrategy = replicationStrategy;
        }

        @Override
        public final Builder replicationStrategy(String replicationStrategy) {
            this.replicationStrategy = replicationStrategy;
            return this;
        }

        @Override
        public final Builder replicationStrategy(Rs replicationStrategy) {
            this.replicationStrategy(replicationStrategy == null ? null : replicationStrategy.toString());
            return this;
        }

        public final Collection<String> getReplicationRegions() {
            if (replicationRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return replicationRegions;
        }

        public final void setReplicationRegions(Collection<String> replicationRegions) {
            this.replicationRegions = RegionListCopier.copy(replicationRegions);
        }

        @Override
        public final Builder replicationRegions(Collection<String> replicationRegions) {
            this.replicationRegions = RegionListCopier.copy(replicationRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationRegions(String... replicationRegions) {
            replicationRegions(Arrays.asList(replicationRegions));
            return this;
        }

        public final List<ReplicationGroupStatus.Builder> getReplicationGroupStatuses() {
            List<ReplicationGroupStatus.Builder> result = ReplicationGroupStatusListCopier
                    .copyToBuilder(this.replicationGroupStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationGroupStatuses(Collection<ReplicationGroupStatus.BuilderImpl> replicationGroupStatuses) {
            this.replicationGroupStatuses = ReplicationGroupStatusListCopier.copyFromBuilder(replicationGroupStatuses);
        }

        @Override
        public final Builder replicationGroupStatuses(Collection<ReplicationGroupStatus> replicationGroupStatuses) {
            this.replicationGroupStatuses = ReplicationGroupStatusListCopier.copy(replicationGroupStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroupStatuses(ReplicationGroupStatus... replicationGroupStatuses) {
            replicationGroupStatuses(Arrays.asList(replicationGroupStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroupStatuses(Consumer<ReplicationGroupStatus.Builder>... replicationGroupStatuses) {
            replicationGroupStatuses(Stream.of(replicationGroupStatuses)
                    .map(c -> ReplicationGroupStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetKeyspaceResponse build() {
            return new GetKeyspaceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
