/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTypeRequest extends KeyspacesRequest implements ToCopyableBuilder<GetTypeRequest.Builder, GetTypeRequest> {
    private static final SdkField<String> KEYSPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyspaceName").getter(getter(GetTypeRequest::keyspaceName)).setter(setter(Builder::keyspaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceName").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("typeName").getter(getter(GetTypeRequest::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYSPACE_NAME_FIELD,
            TYPE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String keyspaceName;

    private final String typeName;

    private GetTypeRequest(BuilderImpl builder) {
        super(builder);
        this.keyspaceName = builder.keyspaceName;
        this.typeName = builder.typeName;
    }

    /**
     * <p>
     * The name of the keyspace that contains this type.
     * </p>
     * 
     * @return The name of the keyspace that contains this type.
     */
    public final String keyspaceName() {
        return keyspaceName;
    }

    /**
     * <p>
     * The formatted name of the type. For example, if the name of the type was created without double quotes, Amazon
     * Keyspaces saved the name in lower-case characters. If the name was created in double quotes, you must use double
     * quotes to specify the type name.
     * </p>
     * 
     * @return The formatted name of the type. For example, if the name of the type was created without double quotes,
     *         Amazon Keyspaces saved the name in lower-case characters. If the name was created in double quotes, you
     *         must use double quotes to specify the type name.
     */
    public final String typeName() {
        return typeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTypeRequest)) {
            return false;
        }
        GetTypeRequest other = (GetTypeRequest) obj;
        return Objects.equals(keyspaceName(), other.keyspaceName()) && Objects.equals(typeName(), other.typeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTypeRequest").add("KeyspaceName", keyspaceName()).add("TypeName", typeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "keyspaceName":
            return Optional.ofNullable(clazz.cast(keyspaceName()));
        case "typeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("keyspaceName", KEYSPACE_NAME_FIELD);
        map.put("typeName", TYPE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTypeRequest, T> g) {
        return obj -> g.apply((GetTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KeyspacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetTypeRequest> {
        /**
         * <p>
         * The name of the keyspace that contains this type.
         * </p>
         * 
         * @param keyspaceName
         *        The name of the keyspace that contains this type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyspaceName(String keyspaceName);

        /**
         * <p>
         * The formatted name of the type. For example, if the name of the type was created without double quotes,
         * Amazon Keyspaces saved the name in lower-case characters. If the name was created in double quotes, you must
         * use double quotes to specify the type name.
         * </p>
         * 
         * @param typeName
         *        The formatted name of the type. For example, if the name of the type was created without double
         *        quotes, Amazon Keyspaces saved the name in lower-case characters. If the name was created in double
         *        quotes, you must use double quotes to specify the type name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KeyspacesRequest.BuilderImpl implements Builder {
        private String keyspaceName;

        private String typeName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTypeRequest model) {
            super(model);
            keyspaceName(model.keyspaceName);
            typeName(model.typeName);
        }

        public final String getKeyspaceName() {
            return keyspaceName;
        }

        public final void setKeyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        @Override
        public final Builder keyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTypeRequest build() {
            return new GetTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
