/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The point-in-time recovery status of the specified table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PointInTimeRecoverySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<PointInTimeRecoverySummary.Builder, PointInTimeRecoverySummary> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(PointInTimeRecoverySummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> EARLIEST_RESTORABLE_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("earliestRestorableTimestamp")
            .getter(getter(PointInTimeRecoverySummary::earliestRestorableTimestamp))
            .setter(setter(Builder::earliestRestorableTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("earliestRestorableTimestamp")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            EARLIEST_RESTORABLE_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final Instant earliestRestorableTimestamp;

    private PointInTimeRecoverySummary(BuilderImpl builder) {
        this.status = builder.status;
        this.earliestRestorableTimestamp = builder.earliestRestorableTimestamp;
    }

    /**
     * <p>
     * Shows if point-in-time recovery is enabled or disabled for the specified table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PointInTimeRecoveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Shows if point-in-time recovery is enabled or disabled for the specified table.
     * @see PointInTimeRecoveryStatus
     */
    public final PointInTimeRecoveryStatus status() {
        return PointInTimeRecoveryStatus.fromValue(status);
    }

    /**
     * <p>
     * Shows if point-in-time recovery is enabled or disabled for the specified table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PointInTimeRecoveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Shows if point-in-time recovery is enabled or disabled for the specified table.
     * @see PointInTimeRecoveryStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Specifies the earliest possible restore point of the table in ISO 8601 format.
     * </p>
     * 
     * @return Specifies the earliest possible restore point of the table in ISO 8601 format.
     */
    public final Instant earliestRestorableTimestamp() {
        return earliestRestorableTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(earliestRestorableTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PointInTimeRecoverySummary)) {
            return false;
        }
        PointInTimeRecoverySummary other = (PointInTimeRecoverySummary) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(earliestRestorableTimestamp(), other.earliestRestorableTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PointInTimeRecoverySummary").add("Status", statusAsString())
                .add("EarliestRestorableTimestamp", earliestRestorableTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "earliestRestorableTimestamp":
            return Optional.ofNullable(clazz.cast(earliestRestorableTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("earliestRestorableTimestamp", EARLIEST_RESTORABLE_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PointInTimeRecoverySummary, T> g) {
        return obj -> g.apply((PointInTimeRecoverySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PointInTimeRecoverySummary> {
        /**
         * <p>
         * Shows if point-in-time recovery is enabled or disabled for the specified table.
         * </p>
         * 
         * @param status
         *        Shows if point-in-time recovery is enabled or disabled for the specified table.
         * @see PointInTimeRecoveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PointInTimeRecoveryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Shows if point-in-time recovery is enabled or disabled for the specified table.
         * </p>
         * 
         * @param status
         *        Shows if point-in-time recovery is enabled or disabled for the specified table.
         * @see PointInTimeRecoveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PointInTimeRecoveryStatus
         */
        Builder status(PointInTimeRecoveryStatus status);

        /**
         * <p>
         * Specifies the earliest possible restore point of the table in ISO 8601 format.
         * </p>
         * 
         * @param earliestRestorableTimestamp
         *        Specifies the earliest possible restore point of the table in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder earliestRestorableTimestamp(Instant earliestRestorableTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private Instant earliestRestorableTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(PointInTimeRecoverySummary model) {
            status(model.status);
            earliestRestorableTimestamp(model.earliestRestorableTimestamp);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PointInTimeRecoveryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getEarliestRestorableTimestamp() {
            return earliestRestorableTimestamp;
        }

        public final void setEarliestRestorableTimestamp(Instant earliestRestorableTimestamp) {
            this.earliestRestorableTimestamp = earliestRestorableTimestamp;
        }

        @Override
        public final Builder earliestRestorableTimestamp(Instant earliestRestorableTimestamp) {
            this.earliestRestorableTimestamp = earliestRestorableTimestamp;
            return this;
        }

        @Override
        public PointInTimeRecoverySummary build() {
            return new PointInTimeRecoverySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
