/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreTableRequest extends KeyspacesRequest implements
        ToCopyableBuilder<RestoreTableRequest.Builder, RestoreTableRequest> {
    private static final SdkField<String> SOURCE_KEYSPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceKeyspaceName").getter(getter(RestoreTableRequest::sourceKeyspaceName))
            .setter(setter(Builder::sourceKeyspaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceKeyspaceName").build())
            .build();

    private static final SdkField<String> SOURCE_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceTableName").getter(getter(RestoreTableRequest::sourceTableName))
            .setter(setter(Builder::sourceTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceTableName").build()).build();

    private static final SdkField<String> TARGET_KEYSPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetKeyspaceName").getter(getter(RestoreTableRequest::targetKeyspaceName))
            .setter(setter(Builder::targetKeyspaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetKeyspaceName").build())
            .build();

    private static final SdkField<String> TARGET_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetTableName").getter(getter(RestoreTableRequest::targetTableName))
            .setter(setter(Builder::targetTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetTableName").build()).build();

    private static final SdkField<Instant> RESTORE_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("restoreTimestamp").getter(getter(RestoreTableRequest::restoreTimestamp))
            .setter(setter(Builder::restoreTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restoreTimestamp").build()).build();

    private static final SdkField<CapacitySpecification> CAPACITY_SPECIFICATION_OVERRIDE_FIELD = SdkField
            .<CapacitySpecification> builder(MarshallingType.SDK_POJO)
            .memberName("capacitySpecificationOverride")
            .getter(getter(RestoreTableRequest::capacitySpecificationOverride))
            .setter(setter(Builder::capacitySpecificationOverride))
            .constructor(CapacitySpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacitySpecificationOverride")
                    .build()).build();

    private static final SdkField<EncryptionSpecification> ENCRYPTION_SPECIFICATION_OVERRIDE_FIELD = SdkField
            .<EncryptionSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("encryptionSpecificationOverride")
            .getter(getter(RestoreTableRequest::encryptionSpecificationOverride))
            .setter(setter(Builder::encryptionSpecificationOverride))
            .constructor(EncryptionSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionSpecificationOverride")
                    .build()).build();

    private static final SdkField<PointInTimeRecovery> POINT_IN_TIME_RECOVERY_OVERRIDE_FIELD = SdkField
            .<PointInTimeRecovery> builder(MarshallingType.SDK_POJO)
            .memberName("pointInTimeRecoveryOverride")
            .getter(getter(RestoreTableRequest::pointInTimeRecoveryOverride))
            .setter(setter(Builder::pointInTimeRecoveryOverride))
            .constructor(PointInTimeRecovery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pointInTimeRecoveryOverride")
                    .build()).build();

    private static final SdkField<List<Tag>> TAGS_OVERRIDE_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tagsOverride")
            .getter(getter(RestoreTableRequest::tagsOverride))
            .setter(setter(Builder::tagsOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagsOverride").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AutoScalingSpecification> AUTO_SCALING_SPECIFICATION_FIELD = SdkField
            .<AutoScalingSpecification> builder(MarshallingType.SDK_POJO).memberName("autoScalingSpecification")
            .getter(getter(RestoreTableRequest::autoScalingSpecification)).setter(setter(Builder::autoScalingSpecification))
            .constructor(AutoScalingSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingSpecification").build())
            .build();

    private static final SdkField<List<ReplicaSpecification>> REPLICA_SPECIFICATIONS_FIELD = SdkField
            .<List<ReplicaSpecification>> builder(MarshallingType.LIST)
            .memberName("replicaSpecifications")
            .getter(getter(RestoreTableRequest::replicaSpecifications))
            .setter(setter(Builder::replicaSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicaSpecifications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicaSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicaSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_KEYSPACE_NAME_FIELD,
            SOURCE_TABLE_NAME_FIELD, TARGET_KEYSPACE_NAME_FIELD, TARGET_TABLE_NAME_FIELD, RESTORE_TIMESTAMP_FIELD,
            CAPACITY_SPECIFICATION_OVERRIDE_FIELD, ENCRYPTION_SPECIFICATION_OVERRIDE_FIELD,
            POINT_IN_TIME_RECOVERY_OVERRIDE_FIELD, TAGS_OVERRIDE_FIELD, AUTO_SCALING_SPECIFICATION_FIELD,
            REPLICA_SPECIFICATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sourceKeyspaceName;

    private final String sourceTableName;

    private final String targetKeyspaceName;

    private final String targetTableName;

    private final Instant restoreTimestamp;

    private final CapacitySpecification capacitySpecificationOverride;

    private final EncryptionSpecification encryptionSpecificationOverride;

    private final PointInTimeRecovery pointInTimeRecoveryOverride;

    private final List<Tag> tagsOverride;

    private final AutoScalingSpecification autoScalingSpecification;

    private final List<ReplicaSpecification> replicaSpecifications;

    private RestoreTableRequest(BuilderImpl builder) {
        super(builder);
        this.sourceKeyspaceName = builder.sourceKeyspaceName;
        this.sourceTableName = builder.sourceTableName;
        this.targetKeyspaceName = builder.targetKeyspaceName;
        this.targetTableName = builder.targetTableName;
        this.restoreTimestamp = builder.restoreTimestamp;
        this.capacitySpecificationOverride = builder.capacitySpecificationOverride;
        this.encryptionSpecificationOverride = builder.encryptionSpecificationOverride;
        this.pointInTimeRecoveryOverride = builder.pointInTimeRecoveryOverride;
        this.tagsOverride = builder.tagsOverride;
        this.autoScalingSpecification = builder.autoScalingSpecification;
        this.replicaSpecifications = builder.replicaSpecifications;
    }

    /**
     * <p>
     * The keyspace name of the source table.
     * </p>
     * 
     * @return The keyspace name of the source table.
     */
    public final String sourceKeyspaceName() {
        return sourceKeyspaceName;
    }

    /**
     * <p>
     * The name of the source table.
     * </p>
     * 
     * @return The name of the source table.
     */
    public final String sourceTableName() {
        return sourceTableName;
    }

    /**
     * <p>
     * The name of the target keyspace.
     * </p>
     * 
     * @return The name of the target keyspace.
     */
    public final String targetKeyspaceName() {
        return targetKeyspaceName;
    }

    /**
     * <p>
     * The name of the target table.
     * </p>
     * 
     * @return The name of the target table.
     */
    public final String targetTableName() {
        return targetTableName;
    }

    /**
     * <p>
     * The restore timestamp in ISO 8601 format.
     * </p>
     * 
     * @return The restore timestamp in ISO 8601 format.
     */
    public final Instant restoreTimestamp() {
        return restoreTimestamp;
    }

    /**
     * <p>
     * Specifies the read/write throughput capacity mode for the target table. The options are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>throughputMode:PAY_PER_REQUEST</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and
     * <code>writeCapacityUnits</code> as input.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default is <code>throughput_mode:PAY_PER_REQUEST</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity
     * modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     * </p>
     * 
     * @return Specifies the read/write throughput capacity mode for the target table. The options are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>throughputMode:PAY_PER_REQUEST</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires
     *         <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default is <code>throughput_mode:PAY_PER_REQUEST</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write
     *         capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     */
    public final CapacitySpecification capacitySpecificationOverride() {
        return capacitySpecificationOverride;
    }

    /**
     * <p>
     * Specifies the encryption settings for the target table. You can choose one of the following KMS key (KMS key):
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and
     * managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name
     * (ARN) format as input.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default is <code>type:AWS_OWNED_KMS_KEY</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the
     * <i>Amazon Keyspaces Developer Guide</i>.
     * </p>
     * 
     * @return Specifies the encryption settings for the target table. You can choose one of the following KMS key (KMS
     *         key):</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned,
     *         and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon
     *         Resource Name (ARN) format as input.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default is <code>type:AWS_OWNED_KMS_KEY</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a>
     *         in the <i>Amazon Keyspaces Developer Guide</i>.
     */
    public final EncryptionSpecification encryptionSpecificationOverride() {
        return encryptionSpecificationOverride;
    }

    /**
     * <p>
     * Specifies the <code>pointInTimeRecovery</code> settings for the target table. The options are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>status=ENABLED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status=DISABLED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If it's not specified, the default is <code>status=DISABLED</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a>
     * in the <i>Amazon Keyspaces Developer Guide</i>.
     * </p>
     * 
     * @return Specifies the <code>pointInTimeRecovery</code> settings for the target table. The options are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>status=ENABLED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status=DISABLED</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If it's not specified, the default is <code>status=DISABLED</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time
     *         recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     */
    public final PointInTimeRecovery pointInTimeRecoveryOverride() {
        return pointInTimeRecoveryOverride;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagsOverride property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagsOverride() {
        return tagsOverride != null && !(tagsOverride instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pair tags to be attached to the restored table.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to
     * Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagsOverride} method.
     * </p>
     * 
     * @return A list of key-value pair tags to be attached to the restored table. </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and
     *         labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     */
    public final List<Tag> tagsOverride() {
        return tagsOverride;
    }

    /**
     * <p>
     * The optional auto scaling settings for the restored table in provisioned capacity mode. Specifies if the service
     * can manage throughput capacity of a provisioned table automatically on your behalf. Amazon Keyspaces auto scaling
     * helps you provision throughput capacity for variable workloads efficiently by increasing and decreasing your
     * table's read and write capacity automatically in response to application traffic.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/autoscaling.html">Managing throughput capacity
     * automatically with Amazon Keyspaces auto scaling</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     * </p>
     * 
     * @return The optional auto scaling settings for the restored table in provisioned capacity mode. Specifies if the
     *         service can manage throughput capacity of a provisioned table automatically on your behalf. Amazon
     *         Keyspaces auto scaling helps you provision throughput capacity for variable workloads efficiently by
     *         increasing and decreasing your table's read and write capacity automatically in response to application
     *         traffic.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/keyspaces/latest/devguide/autoscaling.html">Managing throughput
     *         capacity automatically with Amazon Keyspaces auto scaling</a> in the <i>Amazon Keyspaces Developer
     *         Guide</i>.
     */
    public final AutoScalingSpecification autoScalingSpecification() {
        return autoScalingSpecification;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicaSpecifications property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReplicaSpecifications() {
        return replicaSpecifications != null && !(replicaSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The optional Region specific settings of a multi-Regional table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicaSpecifications} method.
     * </p>
     * 
     * @return The optional Region specific settings of a multi-Regional table.
     */
    public final List<ReplicaSpecification> replicaSpecifications() {
        return replicaSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceKeyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTableName());
        hashCode = 31 * hashCode + Objects.hashCode(targetKeyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(targetTableName());
        hashCode = 31 * hashCode + Objects.hashCode(restoreTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(capacitySpecificationOverride());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionSpecificationOverride());
        hashCode = 31 * hashCode + Objects.hashCode(pointInTimeRecoveryOverride());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagsOverride() ? tagsOverride() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicaSpecifications() ? replicaSpecifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTableRequest)) {
            return false;
        }
        RestoreTableRequest other = (RestoreTableRequest) obj;
        return Objects.equals(sourceKeyspaceName(), other.sourceKeyspaceName())
                && Objects.equals(sourceTableName(), other.sourceTableName())
                && Objects.equals(targetKeyspaceName(), other.targetKeyspaceName())
                && Objects.equals(targetTableName(), other.targetTableName())
                && Objects.equals(restoreTimestamp(), other.restoreTimestamp())
                && Objects.equals(capacitySpecificationOverride(), other.capacitySpecificationOverride())
                && Objects.equals(encryptionSpecificationOverride(), other.encryptionSpecificationOverride())
                && Objects.equals(pointInTimeRecoveryOverride(), other.pointInTimeRecoveryOverride())
                && hasTagsOverride() == other.hasTagsOverride() && Objects.equals(tagsOverride(), other.tagsOverride())
                && Objects.equals(autoScalingSpecification(), other.autoScalingSpecification())
                && hasReplicaSpecifications() == other.hasReplicaSpecifications()
                && Objects.equals(replicaSpecifications(), other.replicaSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreTableRequest").add("SourceKeyspaceName", sourceKeyspaceName())
                .add("SourceTableName", sourceTableName()).add("TargetKeyspaceName", targetKeyspaceName())
                .add("TargetTableName", targetTableName()).add("RestoreTimestamp", restoreTimestamp())
                .add("CapacitySpecificationOverride", capacitySpecificationOverride())
                .add("EncryptionSpecificationOverride", encryptionSpecificationOverride())
                .add("PointInTimeRecoveryOverride", pointInTimeRecoveryOverride())
                .add("TagsOverride", hasTagsOverride() ? tagsOverride() : null)
                .add("AutoScalingSpecification", autoScalingSpecification())
                .add("ReplicaSpecifications", hasReplicaSpecifications() ? replicaSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceKeyspaceName":
            return Optional.ofNullable(clazz.cast(sourceKeyspaceName()));
        case "sourceTableName":
            return Optional.ofNullable(clazz.cast(sourceTableName()));
        case "targetKeyspaceName":
            return Optional.ofNullable(clazz.cast(targetKeyspaceName()));
        case "targetTableName":
            return Optional.ofNullable(clazz.cast(targetTableName()));
        case "restoreTimestamp":
            return Optional.ofNullable(clazz.cast(restoreTimestamp()));
        case "capacitySpecificationOverride":
            return Optional.ofNullable(clazz.cast(capacitySpecificationOverride()));
        case "encryptionSpecificationOverride":
            return Optional.ofNullable(clazz.cast(encryptionSpecificationOverride()));
        case "pointInTimeRecoveryOverride":
            return Optional.ofNullable(clazz.cast(pointInTimeRecoveryOverride()));
        case "tagsOverride":
            return Optional.ofNullable(clazz.cast(tagsOverride()));
        case "autoScalingSpecification":
            return Optional.ofNullable(clazz.cast(autoScalingSpecification()));
        case "replicaSpecifications":
            return Optional.ofNullable(clazz.cast(replicaSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceKeyspaceName", SOURCE_KEYSPACE_NAME_FIELD);
        map.put("sourceTableName", SOURCE_TABLE_NAME_FIELD);
        map.put("targetKeyspaceName", TARGET_KEYSPACE_NAME_FIELD);
        map.put("targetTableName", TARGET_TABLE_NAME_FIELD);
        map.put("restoreTimestamp", RESTORE_TIMESTAMP_FIELD);
        map.put("capacitySpecificationOverride", CAPACITY_SPECIFICATION_OVERRIDE_FIELD);
        map.put("encryptionSpecificationOverride", ENCRYPTION_SPECIFICATION_OVERRIDE_FIELD);
        map.put("pointInTimeRecoveryOverride", POINT_IN_TIME_RECOVERY_OVERRIDE_FIELD);
        map.put("tagsOverride", TAGS_OVERRIDE_FIELD);
        map.put("autoScalingSpecification", AUTO_SCALING_SPECIFICATION_FIELD);
        map.put("replicaSpecifications", REPLICA_SPECIFICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreTableRequest, T> g) {
        return obj -> g.apply((RestoreTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KeyspacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, RestoreTableRequest> {
        /**
         * <p>
         * The keyspace name of the source table.
         * </p>
         * 
         * @param sourceKeyspaceName
         *        The keyspace name of the source table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceKeyspaceName(String sourceKeyspaceName);

        /**
         * <p>
         * The name of the source table.
         * </p>
         * 
         * @param sourceTableName
         *        The name of the source table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTableName(String sourceTableName);

        /**
         * <p>
         * The name of the target keyspace.
         * </p>
         * 
         * @param targetKeyspaceName
         *        The name of the target keyspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetKeyspaceName(String targetKeyspaceName);

        /**
         * <p>
         * The name of the target table.
         * </p>
         * 
         * @param targetTableName
         *        The name of the target table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTableName(String targetTableName);

        /**
         * <p>
         * The restore timestamp in ISO 8601 format.
         * </p>
         * 
         * @param restoreTimestamp
         *        The restore timestamp in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTimestamp(Instant restoreTimestamp);

        /**
         * <p>
         * Specifies the read/write throughput capacity mode for the target table. The options are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>throughputMode:PAY_PER_REQUEST</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code>
         * and <code>writeCapacityUnits</code> as input.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default is <code>throughput_mode:PAY_PER_REQUEST</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity
         * modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * 
         * @param capacitySpecificationOverride
         *        Specifies the read/write throughput capacity mode for the target table. The options are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>throughputMode:PAY_PER_REQUEST</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires
         *        <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default is <code>throughput_mode:PAY_PER_REQUEST</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write
         *        capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacitySpecificationOverride(CapacitySpecification capacitySpecificationOverride);

        /**
         * <p>
         * Specifies the read/write throughput capacity mode for the target table. The options are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>throughputMode:PAY_PER_REQUEST</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code>
         * and <code>writeCapacityUnits</code> as input.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default is <code>throughput_mode:PAY_PER_REQUEST</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity
         * modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacitySpecification.Builder} avoiding
         * the need to create one manually via {@link CapacitySpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacitySpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #capacitySpecificationOverride(CapacitySpecification)}.
         * 
         * @param capacitySpecificationOverride
         *        a consumer that will call methods on {@link CapacitySpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacitySpecificationOverride(CapacitySpecification)
         */
        default Builder capacitySpecificationOverride(Consumer<CapacitySpecification.Builder> capacitySpecificationOverride) {
            return capacitySpecificationOverride(CapacitySpecification.builder().applyMutation(capacitySpecificationOverride)
                    .build());
        }

        /**
         * <p>
         * Specifies the encryption settings for the target table. You can choose one of the following KMS key (KMS
         * key):
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and
         * managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource
         * Name (ARN) format as input.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default is <code>type:AWS_OWNED_KMS_KEY</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in
         * the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * 
         * @param encryptionSpecificationOverride
         *        Specifies the encryption settings for the target table. You can choose one of the following KMS key
         *        (KMS key):</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned,
         *        and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon
         *        Resource Name (ARN) format as input.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default is <code>type:AWS_OWNED_KMS_KEY</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at
         *        rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionSpecificationOverride(EncryptionSpecification encryptionSpecificationOverride);

        /**
         * <p>
         * Specifies the encryption settings for the target table. You can choose one of the following KMS key (KMS
         * key):
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and
         * managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource
         * Name (ARN) format as input.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default is <code>type:AWS_OWNED_KMS_KEY</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in
         * the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionSpecification.Builder} avoiding
         * the need to create one manually via {@link EncryptionSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionSpecificationOverride(EncryptionSpecification)}.
         * 
         * @param encryptionSpecificationOverride
         *        a consumer that will call methods on {@link EncryptionSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionSpecificationOverride(EncryptionSpecification)
         */
        default Builder encryptionSpecificationOverride(Consumer<EncryptionSpecification.Builder> encryptionSpecificationOverride) {
            return encryptionSpecificationOverride(EncryptionSpecification.builder()
                    .applyMutation(encryptionSpecificationOverride).build());
        }

        /**
         * <p>
         * Specifies the <code>pointInTimeRecovery</code> settings for the target table. The options are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>status=ENABLED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status=DISABLED</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * If it's not specified, the default is <code>status=DISABLED</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time
         * recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * 
         * @param pointInTimeRecoveryOverride
         *        Specifies the <code>pointInTimeRecovery</code> settings for the target table. The options are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>status=ENABLED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status=DISABLED</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If it's not specified, the default is <code>status=DISABLED</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time
         *        recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pointInTimeRecoveryOverride(PointInTimeRecovery pointInTimeRecoveryOverride);

        /**
         * <p>
         * Specifies the <code>pointInTimeRecovery</code> settings for the target table. The options are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>status=ENABLED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status=DISABLED</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * If it's not specified, the default is <code>status=DISABLED</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time
         * recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link PointInTimeRecovery.Builder} avoiding the
         * need to create one manually via {@link PointInTimeRecovery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PointInTimeRecovery.Builder#build()} is called immediately and
         * its result is passed to {@link #pointInTimeRecoveryOverride(PointInTimeRecovery)}.
         * 
         * @param pointInTimeRecoveryOverride
         *        a consumer that will call methods on {@link PointInTimeRecovery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pointInTimeRecoveryOverride(PointInTimeRecovery)
         */
        default Builder pointInTimeRecoveryOverride(Consumer<PointInTimeRecovery.Builder> pointInTimeRecoveryOverride) {
            return pointInTimeRecoveryOverride(PointInTimeRecovery.builder().applyMutation(pointInTimeRecoveryOverride).build());
        }

        /**
         * <p>
         * A list of key-value pair tags to be attached to the restored table.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to
         * Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * 
         * @param tagsOverride
         *        A list of key-value pair tags to be attached to the restored table. </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and
         *        labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsOverride(Collection<Tag> tagsOverride);

        /**
         * <p>
         * A list of key-value pair tags to be attached to the restored table.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to
         * Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * 
         * @param tagsOverride
         *        A list of key-value pair tags to be attached to the restored table. </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and
         *        labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsOverride(Tag... tagsOverride);

        /**
         * <p>
         * A list of key-value pair tags to be attached to the restored table.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to
         * Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.keyspaces.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.keyspaces.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.keyspaces.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tagsOverride(List<Tag>)}.
         * 
         * @param tagsOverride
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.keyspaces.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagsOverride(java.util.Collection<Tag>)
         */
        Builder tagsOverride(Consumer<Tag.Builder>... tagsOverride);

        /**
         * <p>
         * The optional auto scaling settings for the restored table in provisioned capacity mode. Specifies if the
         * service can manage throughput capacity of a provisioned table automatically on your behalf. Amazon Keyspaces
         * auto scaling helps you provision throughput capacity for variable workloads efficiently by increasing and
         * decreasing your table's read and write capacity automatically in response to application traffic.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/autoscaling.html">Managing throughput capacity
         * automatically with Amazon Keyspaces auto scaling</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * 
         * @param autoScalingSpecification
         *        The optional auto scaling settings for the restored table in provisioned capacity mode. Specifies if
         *        the service can manage throughput capacity of a provisioned table automatically on your behalf. Amazon
         *        Keyspaces auto scaling helps you provision throughput capacity for variable workloads efficiently by
         *        increasing and decreasing your table's read and write capacity automatically in response to
         *        application traffic.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/keyspaces/latest/devguide/autoscaling.html">Managing throughput
         *        capacity automatically with Amazon Keyspaces auto scaling</a> in the <i>Amazon Keyspaces Developer
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingSpecification(AutoScalingSpecification autoScalingSpecification);

        /**
         * <p>
         * The optional auto scaling settings for the restored table in provisioned capacity mode. Specifies if the
         * service can manage throughput capacity of a provisioned table automatically on your behalf. Amazon Keyspaces
         * auto scaling helps you provision throughput capacity for variable workloads efficiently by increasing and
         * decreasing your table's read and write capacity automatically in response to application traffic.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/autoscaling.html">Managing throughput capacity
         * automatically with Amazon Keyspaces auto scaling</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoScalingSpecification.Builder}
         * avoiding the need to create one manually via {@link AutoScalingSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoScalingSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #autoScalingSpecification(AutoScalingSpecification)}.
         * 
         * @param autoScalingSpecification
         *        a consumer that will call methods on {@link AutoScalingSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScalingSpecification(AutoScalingSpecification)
         */
        default Builder autoScalingSpecification(Consumer<AutoScalingSpecification.Builder> autoScalingSpecification) {
            return autoScalingSpecification(AutoScalingSpecification.builder().applyMutation(autoScalingSpecification).build());
        }

        /**
         * <p>
         * The optional Region specific settings of a multi-Regional table.
         * </p>
         * 
         * @param replicaSpecifications
         *        The optional Region specific settings of a multi-Regional table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaSpecifications(Collection<ReplicaSpecification> replicaSpecifications);

        /**
         * <p>
         * The optional Region specific settings of a multi-Regional table.
         * </p>
         * 
         * @param replicaSpecifications
         *        The optional Region specific settings of a multi-Regional table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaSpecifications(ReplicaSpecification... replicaSpecifications);

        /**
         * <p>
         * The optional Region specific settings of a multi-Regional table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.keyspaces.model.ReplicaSpecification.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.keyspaces.model.ReplicaSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.keyspaces.model.ReplicaSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #replicaSpecifications(List<ReplicaSpecification>)}.
         * 
         * @param replicaSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.keyspaces.model.ReplicaSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaSpecifications(java.util.Collection<ReplicaSpecification>)
         */
        Builder replicaSpecifications(Consumer<ReplicaSpecification.Builder>... replicaSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KeyspacesRequest.BuilderImpl implements Builder {
        private String sourceKeyspaceName;

        private String sourceTableName;

        private String targetKeyspaceName;

        private String targetTableName;

        private Instant restoreTimestamp;

        private CapacitySpecification capacitySpecificationOverride;

        private EncryptionSpecification encryptionSpecificationOverride;

        private PointInTimeRecovery pointInTimeRecoveryOverride;

        private List<Tag> tagsOverride = DefaultSdkAutoConstructList.getInstance();

        private AutoScalingSpecification autoScalingSpecification;

        private List<ReplicaSpecification> replicaSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTableRequest model) {
            super(model);
            sourceKeyspaceName(model.sourceKeyspaceName);
            sourceTableName(model.sourceTableName);
            targetKeyspaceName(model.targetKeyspaceName);
            targetTableName(model.targetTableName);
            restoreTimestamp(model.restoreTimestamp);
            capacitySpecificationOverride(model.capacitySpecificationOverride);
            encryptionSpecificationOverride(model.encryptionSpecificationOverride);
            pointInTimeRecoveryOverride(model.pointInTimeRecoveryOverride);
            tagsOverride(model.tagsOverride);
            autoScalingSpecification(model.autoScalingSpecification);
            replicaSpecifications(model.replicaSpecifications);
        }

        public final String getSourceKeyspaceName() {
            return sourceKeyspaceName;
        }

        public final void setSourceKeyspaceName(String sourceKeyspaceName) {
            this.sourceKeyspaceName = sourceKeyspaceName;
        }

        @Override
        public final Builder sourceKeyspaceName(String sourceKeyspaceName) {
            this.sourceKeyspaceName = sourceKeyspaceName;
            return this;
        }

        public final String getSourceTableName() {
            return sourceTableName;
        }

        public final void setSourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
        }

        @Override
        public final Builder sourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
            return this;
        }

        public final String getTargetKeyspaceName() {
            return targetKeyspaceName;
        }

        public final void setTargetKeyspaceName(String targetKeyspaceName) {
            this.targetKeyspaceName = targetKeyspaceName;
        }

        @Override
        public final Builder targetKeyspaceName(String targetKeyspaceName) {
            this.targetKeyspaceName = targetKeyspaceName;
            return this;
        }

        public final String getTargetTableName() {
            return targetTableName;
        }

        public final void setTargetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
        }

        @Override
        public final Builder targetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
            return this;
        }

        public final Instant getRestoreTimestamp() {
            return restoreTimestamp;
        }

        public final void setRestoreTimestamp(Instant restoreTimestamp) {
            this.restoreTimestamp = restoreTimestamp;
        }

        @Override
        public final Builder restoreTimestamp(Instant restoreTimestamp) {
            this.restoreTimestamp = restoreTimestamp;
            return this;
        }

        public final CapacitySpecification.Builder getCapacitySpecificationOverride() {
            return capacitySpecificationOverride != null ? capacitySpecificationOverride.toBuilder() : null;
        }

        public final void setCapacitySpecificationOverride(CapacitySpecification.BuilderImpl capacitySpecificationOverride) {
            this.capacitySpecificationOverride = capacitySpecificationOverride != null ? capacitySpecificationOverride.build()
                    : null;
        }

        @Override
        public final Builder capacitySpecificationOverride(CapacitySpecification capacitySpecificationOverride) {
            this.capacitySpecificationOverride = capacitySpecificationOverride;
            return this;
        }

        public final EncryptionSpecification.Builder getEncryptionSpecificationOverride() {
            return encryptionSpecificationOverride != null ? encryptionSpecificationOverride.toBuilder() : null;
        }

        public final void setEncryptionSpecificationOverride(EncryptionSpecification.BuilderImpl encryptionSpecificationOverride) {
            this.encryptionSpecificationOverride = encryptionSpecificationOverride != null ? encryptionSpecificationOverride
                    .build() : null;
        }

        @Override
        public final Builder encryptionSpecificationOverride(EncryptionSpecification encryptionSpecificationOverride) {
            this.encryptionSpecificationOverride = encryptionSpecificationOverride;
            return this;
        }

        public final PointInTimeRecovery.Builder getPointInTimeRecoveryOverride() {
            return pointInTimeRecoveryOverride != null ? pointInTimeRecoveryOverride.toBuilder() : null;
        }

        public final void setPointInTimeRecoveryOverride(PointInTimeRecovery.BuilderImpl pointInTimeRecoveryOverride) {
            this.pointInTimeRecoveryOverride = pointInTimeRecoveryOverride != null ? pointInTimeRecoveryOverride.build() : null;
        }

        @Override
        public final Builder pointInTimeRecoveryOverride(PointInTimeRecovery pointInTimeRecoveryOverride) {
            this.pointInTimeRecoveryOverride = pointInTimeRecoveryOverride;
            return this;
        }

        public final List<Tag.Builder> getTagsOverride() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagsOverride);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagsOverride(Collection<Tag.BuilderImpl> tagsOverride) {
            this.tagsOverride = TagListCopier.copyFromBuilder(tagsOverride);
        }

        @Override
        public final Builder tagsOverride(Collection<Tag> tagsOverride) {
            this.tagsOverride = TagListCopier.copy(tagsOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsOverride(Tag... tagsOverride) {
            tagsOverride(Arrays.asList(tagsOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsOverride(Consumer<Tag.Builder>... tagsOverride) {
            tagsOverride(Stream.of(tagsOverride).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final AutoScalingSpecification.Builder getAutoScalingSpecification() {
            return autoScalingSpecification != null ? autoScalingSpecification.toBuilder() : null;
        }

        public final void setAutoScalingSpecification(AutoScalingSpecification.BuilderImpl autoScalingSpecification) {
            this.autoScalingSpecification = autoScalingSpecification != null ? autoScalingSpecification.build() : null;
        }

        @Override
        public final Builder autoScalingSpecification(AutoScalingSpecification autoScalingSpecification) {
            this.autoScalingSpecification = autoScalingSpecification;
            return this;
        }

        public final List<ReplicaSpecification.Builder> getReplicaSpecifications() {
            List<ReplicaSpecification.Builder> result = ReplicaSpecificationListCopier.copyToBuilder(this.replicaSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicaSpecifications(Collection<ReplicaSpecification.BuilderImpl> replicaSpecifications) {
            this.replicaSpecifications = ReplicaSpecificationListCopier.copyFromBuilder(replicaSpecifications);
        }

        @Override
        public final Builder replicaSpecifications(Collection<ReplicaSpecification> replicaSpecifications) {
            this.replicaSpecifications = ReplicaSpecificationListCopier.copy(replicaSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaSpecifications(ReplicaSpecification... replicaSpecifications) {
            replicaSpecifications(Arrays.asList(replicaSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaSpecifications(Consumer<ReplicaSpecification.Builder>... replicaSpecifications) {
            replicaSpecifications(Stream.of(replicaSpecifications)
                    .map(c -> ReplicaSpecification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreTableRequest build() {
            return new RestoreTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
