/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ViewType {
    NEW_IMAGE("NEW_IMAGE"),
    OLD_IMAGE("OLD_IMAGE"),
    KEYS_ONLY("KEYS_ONLY"),
    NEW_AND_OLD_IMAGES("NEW_AND_OLD_IMAGES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ViewType> VALUE_MAP;
    private final String value;

    private ViewType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ViewType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ViewType> knownValues() {
        EnumSet<ViewType> knownValues = EnumSet.allOf(ViewType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ViewType.class, ViewType::toString);
    }
}

