/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.keyspaces.KeyspacesClient;
import software.amazon.awssdk.services.keyspaces.KeyspacesServiceClientConfiguration;
import software.amazon.awssdk.services.keyspaces.internal.KeyspacesServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.keyspaces.model.AccessDeniedException;
import software.amazon.awssdk.services.keyspaces.model.ConflictException;
import software.amazon.awssdk.services.keyspaces.model.CreateKeyspaceRequest;
import software.amazon.awssdk.services.keyspaces.model.CreateKeyspaceResponse;
import software.amazon.awssdk.services.keyspaces.model.CreateTableRequest;
import software.amazon.awssdk.services.keyspaces.model.CreateTableResponse;
import software.amazon.awssdk.services.keyspaces.model.CreateTypeRequest;
import software.amazon.awssdk.services.keyspaces.model.CreateTypeResponse;
import software.amazon.awssdk.services.keyspaces.model.DeleteKeyspaceRequest;
import software.amazon.awssdk.services.keyspaces.model.DeleteKeyspaceResponse;
import software.amazon.awssdk.services.keyspaces.model.DeleteTableRequest;
import software.amazon.awssdk.services.keyspaces.model.DeleteTableResponse;
import software.amazon.awssdk.services.keyspaces.model.DeleteTypeRequest;
import software.amazon.awssdk.services.keyspaces.model.DeleteTypeResponse;
import software.amazon.awssdk.services.keyspaces.model.GetKeyspaceRequest;
import software.amazon.awssdk.services.keyspaces.model.GetKeyspaceResponse;
import software.amazon.awssdk.services.keyspaces.model.GetTableAutoScalingSettingsRequest;
import software.amazon.awssdk.services.keyspaces.model.GetTableAutoScalingSettingsResponse;
import software.amazon.awssdk.services.keyspaces.model.GetTableRequest;
import software.amazon.awssdk.services.keyspaces.model.GetTableResponse;
import software.amazon.awssdk.services.keyspaces.model.GetTypeRequest;
import software.amazon.awssdk.services.keyspaces.model.GetTypeResponse;
import software.amazon.awssdk.services.keyspaces.model.InternalServerException;
import software.amazon.awssdk.services.keyspaces.model.KeyspacesException;
import software.amazon.awssdk.services.keyspaces.model.ListKeyspacesRequest;
import software.amazon.awssdk.services.keyspaces.model.ListKeyspacesResponse;
import software.amazon.awssdk.services.keyspaces.model.ListTablesRequest;
import software.amazon.awssdk.services.keyspaces.model.ListTablesResponse;
import software.amazon.awssdk.services.keyspaces.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.keyspaces.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.keyspaces.model.ListTypesRequest;
import software.amazon.awssdk.services.keyspaces.model.ListTypesResponse;
import software.amazon.awssdk.services.keyspaces.model.ResourceNotFoundException;
import software.amazon.awssdk.services.keyspaces.model.RestoreTableRequest;
import software.amazon.awssdk.services.keyspaces.model.RestoreTableResponse;
import software.amazon.awssdk.services.keyspaces.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.keyspaces.model.TagResourceRequest;
import software.amazon.awssdk.services.keyspaces.model.TagResourceResponse;
import software.amazon.awssdk.services.keyspaces.model.UntagResourceRequest;
import software.amazon.awssdk.services.keyspaces.model.UntagResourceResponse;
import software.amazon.awssdk.services.keyspaces.model.UpdateKeyspaceRequest;
import software.amazon.awssdk.services.keyspaces.model.UpdateKeyspaceResponse;
import software.amazon.awssdk.services.keyspaces.model.UpdateTableRequest;
import software.amazon.awssdk.services.keyspaces.model.UpdateTableResponse;
import software.amazon.awssdk.services.keyspaces.model.ValidationException;
import software.amazon.awssdk.services.keyspaces.transform.CreateKeyspaceRequestMarshaller;
import software.amazon.awssdk.services.keyspaces.transform.CreateTableRequestMarshaller;
import software.amazon.awssdk.services.keyspaces.transform.CreateTypeRequestMarshaller;
import software.amazon.awssdk.services.keyspaces.transform.DeleteKeyspaceRequestMarshaller;
import software.amazon.awssdk.services.keyspaces.transform.DeleteTableRequestMarshaller;
import software.amazon.awssdk.services.keyspaces.transform.DeleteTypeRequestMarshaller;
import software.amazon.awssdk.services.keyspaces.transform.GetKeyspaceRequestMarshaller;
import software.amazon.awssdk.services.keyspaces.transform.GetTableAutoScalingSettingsRequestMarshaller;
import software.amazon.awssdk.services.keyspaces.transform.GetTableRequestMarshaller;
import software.amazon.awssdk.services.keyspaces.transform.GetTypeRequestMarshaller;
import software.amazon.awssdk.services.keyspaces.transform.ListKeyspacesRequestMarshaller;
import software.amazon.awssdk.services.keyspaces.transform.ListTablesRequestMarshaller;
import software.amazon.awssdk.services.keyspaces.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.keyspaces.transform.ListTypesRequestMarshaller;
import software.amazon.awssdk.services.keyspaces.transform.RestoreTableRequestMarshaller;
import software.amazon.awssdk.services.keyspaces.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.keyspaces.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.keyspaces.transform.UpdateKeyspaceRequestMarshaller;
import software.amazon.awssdk.services.keyspaces.transform.UpdateTableRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultKeyspacesClient
implements KeyspacesClient {
    private static final Logger log = Logger.loggerFor(DefaultKeyspacesClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultKeyspacesClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Keyspaces#2.33.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateKeyspaceResponse createKeyspace(CreateKeyspaceRequest createKeyspaceRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, AwsServiceException, SdkClientException, KeyspacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateKeyspaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createKeyspaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKeyspacesClient.resolveMetricPublishers(clientConfiguration, createKeyspaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Keyspaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateKeyspace");
            CreateKeyspaceResponse createKeyspaceResponse = (CreateKeyspaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateKeyspace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createKeyspaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateKeyspaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createKeyspaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKeyspacesClient.lambda$createKeyspace$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTableResponse createTable(CreateTableRequest createTableRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTableResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKeyspacesClient.resolveMetricPublishers(clientConfiguration, createTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Keyspaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTable");
            CreateTableResponse createTableResponse = (CreateTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKeyspacesClient.lambda$createTable$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTypeResponse createType(CreateTypeRequest createTypeRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTypeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKeyspacesClient.resolveMetricPublishers(clientConfiguration, createTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Keyspaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateType");
            CreateTypeResponse createTypeResponse = (CreateTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKeyspacesClient.lambda$createType$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteKeyspaceResponse deleteKeyspace(DeleteKeyspaceRequest deleteKeyspaceRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteKeyspaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteKeyspaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKeyspacesClient.resolveMetricPublishers(clientConfiguration, deleteKeyspaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Keyspaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteKeyspace");
            DeleteKeyspaceResponse deleteKeyspaceResponse = (DeleteKeyspaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteKeyspace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteKeyspaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteKeyspaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteKeyspaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKeyspacesClient.lambda$deleteKeyspace$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTableResponse deleteTable(DeleteTableRequest deleteTableRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTableResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKeyspacesClient.resolveMetricPublishers(clientConfiguration, deleteTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Keyspaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTable");
            DeleteTableResponse deleteTableResponse = (DeleteTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKeyspacesClient.lambda$deleteTable$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTypeResponse deleteType(DeleteTypeRequest deleteTypeRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTypeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKeyspacesClient.resolveMetricPublishers(clientConfiguration, deleteTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Keyspaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteType");
            DeleteTypeResponse deleteTypeResponse = (DeleteTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKeyspacesClient.lambda$deleteType$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetKeyspaceResponse getKeyspace(GetKeyspaceRequest getKeyspaceRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetKeyspaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getKeyspaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKeyspacesClient.resolveMetricPublishers(clientConfiguration, getKeyspaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Keyspaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetKeyspace");
            GetKeyspaceResponse getKeyspaceResponse = (GetKeyspaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetKeyspace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getKeyspaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetKeyspaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getKeyspaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKeyspacesClient.lambda$getKeyspace$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTableResponse getTable(GetTableRequest getTableRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTableResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKeyspacesClient.resolveMetricPublishers(clientConfiguration, getTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Keyspaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTable");
            GetTableResponse getTableResponse = (GetTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKeyspacesClient.lambda$getTable$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTableAutoScalingSettingsResponse getTableAutoScalingSettings(GetTableAutoScalingSettingsRequest getTableAutoScalingSettingsRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTableAutoScalingSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTableAutoScalingSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKeyspacesClient.resolveMetricPublishers(clientConfiguration, getTableAutoScalingSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Keyspaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTableAutoScalingSettings");
            GetTableAutoScalingSettingsResponse getTableAutoScalingSettingsResponse = (GetTableAutoScalingSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTableAutoScalingSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTableAutoScalingSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTableAutoScalingSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTableAutoScalingSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKeyspacesClient.lambda$getTableAutoScalingSettings$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTypeResponse getType(GetTypeRequest getTypeRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTypeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKeyspacesClient.resolveMetricPublishers(clientConfiguration, getTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Keyspaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetType");
            GetTypeResponse getTypeResponse = (GetTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKeyspacesClient.lambda$getType$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListKeyspacesResponse listKeyspaces(ListKeyspacesRequest listKeyspacesRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListKeyspacesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listKeyspacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKeyspacesClient.resolveMetricPublishers(clientConfiguration, listKeyspacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Keyspaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListKeyspaces");
            ListKeyspacesResponse listKeyspacesResponse = (ListKeyspacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListKeyspaces").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listKeyspacesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListKeyspacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listKeyspacesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKeyspacesClient.lambda$listKeyspaces$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTablesResponse listTables(ListTablesRequest listTablesRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTablesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTablesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKeyspacesClient.resolveMetricPublishers(clientConfiguration, listTablesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Keyspaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTables");
            ListTablesResponse listTablesResponse = (ListTablesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTables").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTablesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTablesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTablesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKeyspacesClient.lambda$listTables$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKeyspacesClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Keyspaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKeyspacesClient.lambda$listTagsForResource$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTypesResponse listTypes(ListTypesRequest listTypesRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTypesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKeyspacesClient.resolveMetricPublishers(clientConfiguration, listTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Keyspaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTypes");
            ListTypesResponse listTypesResponse = (ListTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKeyspacesClient.lambda$listTypes$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreTableResponse restoreTable(RestoreTableRequest restoreTableRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreTableResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)restoreTableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKeyspacesClient.resolveMetricPublishers(clientConfiguration, restoreTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Keyspaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreTable");
            RestoreTableResponse restoreTableResponse = (RestoreTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)restoreTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestoreTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return restoreTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKeyspacesClient.lambda$restoreTable$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKeyspacesClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Keyspaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKeyspacesClient.lambda$tagResource$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKeyspacesClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Keyspaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKeyspacesClient.lambda$untagResource$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateKeyspaceResponse updateKeyspace(UpdateKeyspaceRequest updateKeyspaceRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateKeyspaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateKeyspaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKeyspacesClient.resolveMetricPublishers(clientConfiguration, updateKeyspaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Keyspaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateKeyspace");
            UpdateKeyspaceResponse updateKeyspaceResponse = (UpdateKeyspaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateKeyspace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateKeyspaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateKeyspaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateKeyspaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKeyspacesClient.lambda$updateKeyspace$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTableResponse updateTable(UpdateTableRequest updateTableRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, ConflictException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KeyspacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTableResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKeyspacesClient.resolveMetricPublishers(clientConfiguration, updateTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Keyspaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTable");
            UpdateTableResponse updateTableResponse = (UpdateTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKeyspacesClient.lambda$updateTable$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "cassandra";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        KeyspacesServiceClientConfigurationBuilder serviceConfigBuilder = new KeyspacesServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(KeyspacesException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0");
    }

    @Override
    public final KeyspacesServiceClientConfiguration serviceClientConfiguration() {
        return new KeyspacesServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateTable$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateKeyspace$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreTable$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTypes$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTables$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listKeyspaces$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getType$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTableAutoScalingSettings$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTable$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getKeyspace$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteType$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTable$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteKeyspace$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createType$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTable$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createKeyspace$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

