/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Amazon Keyspaces supports the <code>target tracking</code> auto scaling policy. With this policy, Amazon Keyspaces
 * auto scaling ensures that the table's ratio of consumed to provisioned capacity stays at or near the target value
 * that you specify. You define the target value as a percentage between 20 and 90.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScalingPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoScalingPolicy.Builder, AutoScalingPolicy> {
    private static final SdkField<TargetTrackingScalingPolicyConfiguration> TARGET_TRACKING_SCALING_POLICY_CONFIGURATION_FIELD = SdkField
            .<TargetTrackingScalingPolicyConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("targetTrackingScalingPolicyConfiguration")
            .getter(getter(AutoScalingPolicy::targetTrackingScalingPolicyConfiguration))
            .setter(setter(Builder::targetTrackingScalingPolicyConfiguration))
            .constructor(TargetTrackingScalingPolicyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("targetTrackingScalingPolicyConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TARGET_TRACKING_SCALING_POLICY_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TargetTrackingScalingPolicyConfiguration targetTrackingScalingPolicyConfiguration;

    private AutoScalingPolicy(BuilderImpl builder) {
        this.targetTrackingScalingPolicyConfiguration = builder.targetTrackingScalingPolicyConfiguration;
    }

    /**
     * <p>
     * Auto scaling scales up capacity automatically when traffic exceeds this target utilization rate, and then back
     * down when it falls below the target. A <code>double</code> between 20 and 90.
     * </p>
     * 
     * @return Auto scaling scales up capacity automatically when traffic exceeds this target utilization rate, and then
     *         back down when it falls below the target. A <code>double</code> between 20 and 90.
     */
    public final TargetTrackingScalingPolicyConfiguration targetTrackingScalingPolicyConfiguration() {
        return targetTrackingScalingPolicyConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetTrackingScalingPolicyConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingPolicy)) {
            return false;
        }
        AutoScalingPolicy other = (AutoScalingPolicy) obj;
        return Objects.equals(targetTrackingScalingPolicyConfiguration(), other.targetTrackingScalingPolicyConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoScalingPolicy")
                .add("TargetTrackingScalingPolicyConfiguration", targetTrackingScalingPolicyConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetTrackingScalingPolicyConfiguration":
            return Optional.ofNullable(clazz.cast(targetTrackingScalingPolicyConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("targetTrackingScalingPolicyConfiguration", TARGET_TRACKING_SCALING_POLICY_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingPolicy, T> g) {
        return obj -> g.apply((AutoScalingPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoScalingPolicy> {
        /**
         * <p>
         * Auto scaling scales up capacity automatically when traffic exceeds this target utilization rate, and then
         * back down when it falls below the target. A <code>double</code> between 20 and 90.
         * </p>
         * 
         * @param targetTrackingScalingPolicyConfiguration
         *        Auto scaling scales up capacity automatically when traffic exceeds this target utilization rate, and
         *        then back down when it falls below the target. A <code>double</code> between 20 and 90.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTrackingScalingPolicyConfiguration(
                TargetTrackingScalingPolicyConfiguration targetTrackingScalingPolicyConfiguration);

        /**
         * <p>
         * Auto scaling scales up capacity automatically when traffic exceeds this target utilization rate, and then
         * back down when it falls below the target. A <code>double</code> between 20 and 90.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TargetTrackingScalingPolicyConfiguration.Builder} avoiding the need to create one manually via
         * {@link TargetTrackingScalingPolicyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetTrackingScalingPolicyConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfiguration)}.
         * 
         * @param targetTrackingScalingPolicyConfiguration
         *        a consumer that will call methods on {@link TargetTrackingScalingPolicyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfiguration)
         */
        default Builder targetTrackingScalingPolicyConfiguration(
                Consumer<TargetTrackingScalingPolicyConfiguration.Builder> targetTrackingScalingPolicyConfiguration) {
            return targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfiguration.builder()
                    .applyMutation(targetTrackingScalingPolicyConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TargetTrackingScalingPolicyConfiguration targetTrackingScalingPolicyConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingPolicy model) {
            targetTrackingScalingPolicyConfiguration(model.targetTrackingScalingPolicyConfiguration);
        }

        public final TargetTrackingScalingPolicyConfiguration.Builder getTargetTrackingScalingPolicyConfiguration() {
            return targetTrackingScalingPolicyConfiguration != null ? targetTrackingScalingPolicyConfiguration.toBuilder() : null;
        }

        public final void setTargetTrackingScalingPolicyConfiguration(
                TargetTrackingScalingPolicyConfiguration.BuilderImpl targetTrackingScalingPolicyConfiguration) {
            this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration != null ? targetTrackingScalingPolicyConfiguration
                    .build() : null;
        }

        @Override
        public final Builder targetTrackingScalingPolicyConfiguration(
                TargetTrackingScalingPolicyConfiguration targetTrackingScalingPolicyConfiguration) {
            this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration;
            return this;
        }

        @Override
        public AutoScalingPolicy build() {
            return new AutoScalingPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
