/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings of the CDC stream of the table. For more information about CDC streams, see <a
 * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cdc.html">Working with change data capture (CDC) streams
 * in Amazon Keyspaces</a> in the <i>Amazon Keyspaces Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CdcSpecificationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CdcSpecificationSummary.Builder, CdcSpecificationSummary> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CdcSpecificationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> VIEW_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("viewType").getter(getter(CdcSpecificationSummary::viewTypeAsString)).setter(setter(Builder::viewType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("viewType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(STATUS_FIELD, VIEW_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String viewType;

    private CdcSpecificationSummary(BuilderImpl builder) {
        this.status = builder.status;
        this.viewType = builder.viewType;
    }

    /**
     * <p>
     * The status of the CDC stream. Specifies if the table has a CDC stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CdcStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the CDC stream. Specifies if the table has a CDC stream.
     * @see CdcStatus
     */
    public final CdcStatus status() {
        return CdcStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the CDC stream. Specifies if the table has a CDC stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CdcStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the CDC stream. Specifies if the table has a CDC stream.
     * @see CdcStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The view type specifies the changes Amazon Keyspaces records for each changed row in the stream. This setting
     * can't be changed, after the stream has been created.
     * </p>
     * <p>
     * The options are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NEW_AND_OLD_IMAGES</code> - both versions of the row, before and after the change. This is the default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_IMAGE</code> - the version of the row after the change.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OLD_IMAGE</code> - the version of the row before the change.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KEYS_ONLY</code> - the partition and clustering keys of the row that was changed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #viewType} will
     * return {@link ViewType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #viewTypeAsString}.
     * </p>
     * 
     * @return The view type specifies the changes Amazon Keyspaces records for each changed row in the stream. This
     *         setting can't be changed, after the stream has been created. </p>
     *         <p>
     *         The options are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NEW_AND_OLD_IMAGES</code> - both versions of the row, before and after the change. This is the
     *         default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_IMAGE</code> - the version of the row after the change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OLD_IMAGE</code> - the version of the row before the change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KEYS_ONLY</code> - the partition and clustering keys of the row that was changed.
     *         </p>
     *         </li>
     * @see ViewType
     */
    public final ViewType viewType() {
        return ViewType.fromValue(viewType);
    }

    /**
     * <p>
     * The view type specifies the changes Amazon Keyspaces records for each changed row in the stream. This setting
     * can't be changed, after the stream has been created.
     * </p>
     * <p>
     * The options are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NEW_AND_OLD_IMAGES</code> - both versions of the row, before and after the change. This is the default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_IMAGE</code> - the version of the row after the change.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OLD_IMAGE</code> - the version of the row before the change.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KEYS_ONLY</code> - the partition and clustering keys of the row that was changed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #viewType} will
     * return {@link ViewType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #viewTypeAsString}.
     * </p>
     * 
     * @return The view type specifies the changes Amazon Keyspaces records for each changed row in the stream. This
     *         setting can't be changed, after the stream has been created. </p>
     *         <p>
     *         The options are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NEW_AND_OLD_IMAGES</code> - both versions of the row, before and after the change. This is the
     *         default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_IMAGE</code> - the version of the row after the change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OLD_IMAGE</code> - the version of the row before the change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KEYS_ONLY</code> - the partition and clustering keys of the row that was changed.
     *         </p>
     *         </li>
     * @see ViewType
     */
    public final String viewTypeAsString() {
        return viewType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(viewTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CdcSpecificationSummary)) {
            return false;
        }
        CdcSpecificationSummary other = (CdcSpecificationSummary) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(viewTypeAsString(), other.viewTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CdcSpecificationSummary").add("Status", statusAsString()).add("ViewType", viewTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "viewType":
            return Optional.ofNullable(clazz.cast(viewTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("viewType", VIEW_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CdcSpecificationSummary, T> g) {
        return obj -> g.apply((CdcSpecificationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CdcSpecificationSummary> {
        /**
         * <p>
         * The status of the CDC stream. Specifies if the table has a CDC stream.
         * </p>
         * 
         * @param status
         *        The status of the CDC stream. Specifies if the table has a CDC stream.
         * @see CdcStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CdcStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the CDC stream. Specifies if the table has a CDC stream.
         * </p>
         * 
         * @param status
         *        The status of the CDC stream. Specifies if the table has a CDC stream.
         * @see CdcStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CdcStatus
         */
        Builder status(CdcStatus status);

        /**
         * <p>
         * The view type specifies the changes Amazon Keyspaces records for each changed row in the stream. This setting
         * can't be changed, after the stream has been created.
         * </p>
         * <p>
         * The options are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NEW_AND_OLD_IMAGES</code> - both versions of the row, before and after the change. This is the default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_IMAGE</code> - the version of the row after the change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OLD_IMAGE</code> - the version of the row before the change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - the partition and clustering keys of the row that was changed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param viewType
         *        The view type specifies the changes Amazon Keyspaces records for each changed row in the stream. This
         *        setting can't be changed, after the stream has been created. </p>
         *        <p>
         *        The options are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NEW_AND_OLD_IMAGES</code> - both versions of the row, before and after the change. This is the
         *        default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_IMAGE</code> - the version of the row after the change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OLD_IMAGE</code> - the version of the row before the change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - the partition and clustering keys of the row that was changed.
         *        </p>
         *        </li>
         * @see ViewType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewType
         */
        Builder viewType(String viewType);

        /**
         * <p>
         * The view type specifies the changes Amazon Keyspaces records for each changed row in the stream. This setting
         * can't be changed, after the stream has been created.
         * </p>
         * <p>
         * The options are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NEW_AND_OLD_IMAGES</code> - both versions of the row, before and after the change. This is the default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_IMAGE</code> - the version of the row after the change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OLD_IMAGE</code> - the version of the row before the change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - the partition and clustering keys of the row that was changed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param viewType
         *        The view type specifies the changes Amazon Keyspaces records for each changed row in the stream. This
         *        setting can't be changed, after the stream has been created. </p>
         *        <p>
         *        The options are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NEW_AND_OLD_IMAGES</code> - both versions of the row, before and after the change. This is the
         *        default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_IMAGE</code> - the version of the row after the change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OLD_IMAGE</code> - the version of the row before the change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - the partition and clustering keys of the row that was changed.
         *        </p>
         *        </li>
         * @see ViewType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewType
         */
        Builder viewType(ViewType viewType);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String viewType;

        private BuilderImpl() {
        }

        private BuilderImpl(CdcSpecificationSummary model) {
            status(model.status);
            viewType(model.viewType);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CdcStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getViewType() {
            return viewType;
        }

        public final void setViewType(String viewType) {
            this.viewType = viewType;
        }

        @Override
        public final Builder viewType(String viewType) {
            this.viewType = viewType;
            return this;
        }

        @Override
        public final Builder viewType(ViewType viewType) {
            this.viewType(viewType == null ? null : viewType.toString());
            return this;
        }

        @Override
        public CdcSpecificationSummary build() {
            return new CdcSpecificationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
