/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Web Services Region specific settings of a multi-Region table.
 * </p>
 * <p>
 * For a multi-Region table, you can configure the table's read capacity differently per Amazon Web Services Region. You
 * can do this by configuring the following parameters.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>region</code>: The Region where these settings are applied. (Required)
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>readCapacityUnits</code>: The provisioned read capacity units. (Optional)
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>readCapacityAutoScaling</code>: The read capacity auto scaling settings for the table. (Optional)
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicaSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicaSpecification.Builder, ReplicaSpecification> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(ReplicaSpecification::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<Long> READ_CAPACITY_UNITS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("readCapacityUnits").getter(getter(ReplicaSpecification::readCapacityUnits))
            .setter(setter(Builder::readCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readCapacityUnits").build()).build();

    private static final SdkField<AutoScalingSettings> READ_CAPACITY_AUTO_SCALING_FIELD = SdkField
            .<AutoScalingSettings> builder(MarshallingType.SDK_POJO).memberName("readCapacityAutoScaling")
            .getter(getter(ReplicaSpecification::readCapacityAutoScaling)).setter(setter(Builder::readCapacityAutoScaling))
            .constructor(AutoScalingSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readCapacityAutoScaling").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD,
            READ_CAPACITY_UNITS_FIELD, READ_CAPACITY_AUTO_SCALING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String region;

    private final Long readCapacityUnits;

    private final AutoScalingSettings readCapacityAutoScaling;

    private ReplicaSpecification(BuilderImpl builder) {
        this.region = builder.region;
        this.readCapacityUnits = builder.readCapacityUnits;
        this.readCapacityAutoScaling = builder.readCapacityAutoScaling;
    }

    /**
     * <p>
     * The Amazon Web Services Region.
     * </p>
     * 
     * @return The Amazon Web Services Region.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The provisioned read capacity units for the multi-Region table in the specified Amazon Web Services Region.
     * </p>
     * 
     * @return The provisioned read capacity units for the multi-Region table in the specified Amazon Web Services
     *         Region.
     */
    public final Long readCapacityUnits() {
        return readCapacityUnits;
    }

    /**
     * <p>
     * The read capacity auto scaling settings for the multi-Region table in the specified Amazon Web Services Region.
     * </p>
     * 
     * @return The read capacity auto scaling settings for the multi-Region table in the specified Amazon Web Services
     *         Region.
     */
    public final AutoScalingSettings readCapacityAutoScaling() {
        return readCapacityAutoScaling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(readCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(readCapacityAutoScaling());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaSpecification)) {
            return false;
        }
        ReplicaSpecification other = (ReplicaSpecification) obj;
        return Objects.equals(region(), other.region()) && Objects.equals(readCapacityUnits(), other.readCapacityUnits())
                && Objects.equals(readCapacityAutoScaling(), other.readCapacityAutoScaling());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicaSpecification").add("Region", region()).add("ReadCapacityUnits", readCapacityUnits())
                .add("ReadCapacityAutoScaling", readCapacityAutoScaling()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "readCapacityUnits":
            return Optional.ofNullable(clazz.cast(readCapacityUnits()));
        case "readCapacityAutoScaling":
            return Optional.ofNullable(clazz.cast(readCapacityAutoScaling()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("region", REGION_FIELD);
        map.put("readCapacityUnits", READ_CAPACITY_UNITS_FIELD);
        map.put("readCapacityAutoScaling", READ_CAPACITY_AUTO_SCALING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicaSpecification, T> g) {
        return obj -> g.apply((ReplicaSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicaSpecification> {
        /**
         * <p>
         * The Amazon Web Services Region.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The provisioned read capacity units for the multi-Region table in the specified Amazon Web Services Region.
         * </p>
         * 
         * @param readCapacityUnits
         *        The provisioned read capacity units for the multi-Region table in the specified Amazon Web Services
         *        Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readCapacityUnits(Long readCapacityUnits);

        /**
         * <p>
         * The read capacity auto scaling settings for the multi-Region table in the specified Amazon Web Services
         * Region.
         * </p>
         * 
         * @param readCapacityAutoScaling
         *        The read capacity auto scaling settings for the multi-Region table in the specified Amazon Web
         *        Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readCapacityAutoScaling(AutoScalingSettings readCapacityAutoScaling);

        /**
         * <p>
         * The read capacity auto scaling settings for the multi-Region table in the specified Amazon Web Services
         * Region.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoScalingSettings.Builder} avoiding the
         * need to create one manually via {@link AutoScalingSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoScalingSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #readCapacityAutoScaling(AutoScalingSettings)}.
         * 
         * @param readCapacityAutoScaling
         *        a consumer that will call methods on {@link AutoScalingSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #readCapacityAutoScaling(AutoScalingSettings)
         */
        default Builder readCapacityAutoScaling(Consumer<AutoScalingSettings.Builder> readCapacityAutoScaling) {
            return readCapacityAutoScaling(AutoScalingSettings.builder().applyMutation(readCapacityAutoScaling).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private Long readCapacityUnits;

        private AutoScalingSettings readCapacityAutoScaling;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaSpecification model) {
            region(model.region);
            readCapacityUnits(model.readCapacityUnits);
            readCapacityAutoScaling(model.readCapacityAutoScaling);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Long getReadCapacityUnits() {
            return readCapacityUnits;
        }

        public final void setReadCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
        }

        @Override
        public final Builder readCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
            return this;
        }

        public final AutoScalingSettings.Builder getReadCapacityAutoScaling() {
            return readCapacityAutoScaling != null ? readCapacityAutoScaling.toBuilder() : null;
        }

        public final void setReadCapacityAutoScaling(AutoScalingSettings.BuilderImpl readCapacityAutoScaling) {
            this.readCapacityAutoScaling = readCapacityAutoScaling != null ? readCapacityAutoScaling.build() : null;
        }

        @Override
        public final Builder readCapacityAutoScaling(AutoScalingSettings readCapacityAutoScaling) {
            this.readCapacityAutoScaling = readCapacityAutoScaling;
            return this;
        }

        @Override
        public ReplicaSpecification build() {
            return new ReplicaSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
