/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Region-specific settings of a multi-Region table in the specified Amazon Web Services Region.
 * </p>
 * <p>
 * If the multi-Region table is using provisioned capacity and has optional auto scaling policies configured, note that
 * the Region specific summary returns both read and write capacity settings. But only Region specific read capacity
 * settings can be configured for a multi-Region table. In a multi-Region table, your write capacity units will be
 * synced across all Amazon Web Services Regions to ensure that there is enough capacity to replicate write events
 * across Regions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicaSpecificationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicaSpecificationSummary.Builder, ReplicaSpecificationSummary> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(ReplicaSpecificationSummary::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ReplicaSpecificationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<CapacitySpecificationSummary> CAPACITY_SPECIFICATION_FIELD = SdkField
            .<CapacitySpecificationSummary> builder(MarshallingType.SDK_POJO).memberName("capacitySpecification")
            .getter(getter(ReplicaSpecificationSummary::capacitySpecification)).setter(setter(Builder::capacitySpecification))
            .constructor(CapacitySpecificationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacitySpecification").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD, STATUS_FIELD,
            CAPACITY_SPECIFICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String region;

    private final String status;

    private final CapacitySpecificationSummary capacitySpecification;

    private ReplicaSpecificationSummary(BuilderImpl builder) {
        this.region = builder.region;
        this.status = builder.status;
        this.capacitySpecification = builder.capacitySpecification;
    }

    /**
     * <p>
     * The Amazon Web Services Region.
     * </p>
     * 
     * @return The Amazon Web Services Region.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The status of the multi-Region table in the specified Amazon Web Services Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TableStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the multi-Region table in the specified Amazon Web Services Region.
     * @see TableStatus
     */
    public final TableStatus status() {
        return TableStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the multi-Region table in the specified Amazon Web Services Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TableStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the multi-Region table in the specified Amazon Web Services Region.
     * @see TableStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the CapacitySpecification property for this object.
     * 
     * @return The value of the CapacitySpecification property for this object.
     */
    public final CapacitySpecificationSummary capacitySpecification() {
        return capacitySpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(capacitySpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaSpecificationSummary)) {
            return false;
        }
        ReplicaSpecificationSummary other = (ReplicaSpecificationSummary) obj;
        return Objects.equals(region(), other.region()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(capacitySpecification(), other.capacitySpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicaSpecificationSummary").add("Region", region()).add("Status", statusAsString())
                .add("CapacitySpecification", capacitySpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "capacitySpecification":
            return Optional.ofNullable(clazz.cast(capacitySpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("region", REGION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("capacitySpecification", CAPACITY_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicaSpecificationSummary, T> g) {
        return obj -> g.apply((ReplicaSpecificationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicaSpecificationSummary> {
        /**
         * <p>
         * The Amazon Web Services Region.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The status of the multi-Region table in the specified Amazon Web Services Region.
         * </p>
         * 
         * @param status
         *        The status of the multi-Region table in the specified Amazon Web Services Region.
         * @see TableStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the multi-Region table in the specified Amazon Web Services Region.
         * </p>
         * 
         * @param status
         *        The status of the multi-Region table in the specified Amazon Web Services Region.
         * @see TableStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableStatus
         */
        Builder status(TableStatus status);

        /**
         * Sets the value of the CapacitySpecification property for this object.
         *
         * @param capacitySpecification
         *        The new value for the CapacitySpecification property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacitySpecification(CapacitySpecificationSummary capacitySpecification);

        /**
         * Sets the value of the CapacitySpecification property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CapacitySpecificationSummary.Builder}
         * avoiding the need to create one manually via {@link CapacitySpecificationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacitySpecificationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #capacitySpecification(CapacitySpecificationSummary)}.
         * 
         * @param capacitySpecification
         *        a consumer that will call methods on {@link CapacitySpecificationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacitySpecification(CapacitySpecificationSummary)
         */
        default Builder capacitySpecification(Consumer<CapacitySpecificationSummary.Builder> capacitySpecification) {
            return capacitySpecification(CapacitySpecificationSummary.builder().applyMutation(capacitySpecification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private String status;

        private CapacitySpecificationSummary capacitySpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaSpecificationSummary model) {
            region(model.region);
            status(model.status);
            capacitySpecification(model.capacitySpecification);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TableStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final CapacitySpecificationSummary.Builder getCapacitySpecification() {
            return capacitySpecification != null ? capacitySpecification.toBuilder() : null;
        }

        public final void setCapacitySpecification(CapacitySpecificationSummary.BuilderImpl capacitySpecification) {
            this.capacitySpecification = capacitySpecification != null ? capacitySpecification.build() : null;
        }

        @Override
        public final Builder capacitySpecification(CapacitySpecificationSummary capacitySpecification) {
            this.capacitySpecification = capacitySpecification;
            return this;
        }

        @Override
        public ReplicaSpecificationSummary build() {
            return new ReplicaSpecificationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
