/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTypeRequest extends KeyspacesRequest implements
        ToCopyableBuilder<CreateTypeRequest.Builder, CreateTypeRequest> {
    private static final SdkField<String> KEYSPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyspaceName").getter(getter(CreateTypeRequest::keyspaceName)).setter(setter(Builder::keyspaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceName").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("typeName").getter(getter(CreateTypeRequest::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeName").build()).build();

    private static final SdkField<List<FieldDefinition>> FIELD_DEFINITIONS_FIELD = SdkField
            .<List<FieldDefinition>> builder(MarshallingType.LIST)
            .memberName("fieldDefinitions")
            .getter(getter(CreateTypeRequest::fieldDefinitions))
            .setter(setter(Builder::fieldDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYSPACE_NAME_FIELD,
            TYPE_NAME_FIELD, FIELD_DEFINITIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String keyspaceName;

    private final String typeName;

    private final List<FieldDefinition> fieldDefinitions;

    private CreateTypeRequest(BuilderImpl builder) {
        super(builder);
        this.keyspaceName = builder.keyspaceName;
        this.typeName = builder.typeName;
        this.fieldDefinitions = builder.fieldDefinitions;
    }

    /**
     * <p>
     * The name of the keyspace.
     * </p>
     * 
     * @return The name of the keyspace.
     */
    public final String keyspaceName() {
        return keyspaceName;
    }

    /**
     * <p>
     * The name of the user-defined type.
     * </p>
     * <p>
     * UDT names must contain 48 characters or less, must begin with an alphabetic character, and can only contain
     * alpha-numeric characters and underscores. Amazon Keyspaces converts upper case characters automatically into
     * lower case characters.
     * </p>
     * <p>
     * Alternatively, you can declare a UDT name in double quotes. When declaring a UDT name inside double quotes,
     * Amazon Keyspaces preserves upper casing and allows special characters.
     * </p>
     * <p>
     * You can also use double quotes as part of the name when you create the UDT, but you must escape each double quote
     * character with an additional double quote character.
     * </p>
     * 
     * @return The name of the user-defined type. </p>
     *         <p>
     *         UDT names must contain 48 characters or less, must begin with an alphabetic character, and can only
     *         contain alpha-numeric characters and underscores. Amazon Keyspaces converts upper case characters
     *         automatically into lower case characters.
     *         </p>
     *         <p>
     *         Alternatively, you can declare a UDT name in double quotes. When declaring a UDT name inside double
     *         quotes, Amazon Keyspaces preserves upper casing and allows special characters.
     *         </p>
     *         <p>
     *         You can also use double quotes as part of the name when you create the UDT, but you must escape each
     *         double quote character with an additional double quote character.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldDefinitions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFieldDefinitions() {
        return fieldDefinitions != null && !(fieldDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The field definitions, consisting of names and types, that define this type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldDefinitions} method.
     * </p>
     * 
     * @return The field definitions, consisting of names and types, that define this type.
     */
    public final List<FieldDefinition> fieldDefinitions() {
        return fieldDefinitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldDefinitions() ? fieldDefinitions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTypeRequest)) {
            return false;
        }
        CreateTypeRequest other = (CreateTypeRequest) obj;
        return Objects.equals(keyspaceName(), other.keyspaceName()) && Objects.equals(typeName(), other.typeName())
                && hasFieldDefinitions() == other.hasFieldDefinitions()
                && Objects.equals(fieldDefinitions(), other.fieldDefinitions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTypeRequest").add("KeyspaceName", keyspaceName()).add("TypeName", typeName())
                .add("FieldDefinitions", hasFieldDefinitions() ? fieldDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "keyspaceName":
            return Optional.ofNullable(clazz.cast(keyspaceName()));
        case "typeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "fieldDefinitions":
            return Optional.ofNullable(clazz.cast(fieldDefinitions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("keyspaceName", KEYSPACE_NAME_FIELD);
        map.put("typeName", TYPE_NAME_FIELD);
        map.put("fieldDefinitions", FIELD_DEFINITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTypeRequest, T> g) {
        return obj -> g.apply((CreateTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KeyspacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTypeRequest> {
        /**
         * <p>
         * The name of the keyspace.
         * </p>
         * 
         * @param keyspaceName
         *        The name of the keyspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyspaceName(String keyspaceName);

        /**
         * <p>
         * The name of the user-defined type.
         * </p>
         * <p>
         * UDT names must contain 48 characters or less, must begin with an alphabetic character, and can only contain
         * alpha-numeric characters and underscores. Amazon Keyspaces converts upper case characters automatically into
         * lower case characters.
         * </p>
         * <p>
         * Alternatively, you can declare a UDT name in double quotes. When declaring a UDT name inside double quotes,
         * Amazon Keyspaces preserves upper casing and allows special characters.
         * </p>
         * <p>
         * You can also use double quotes as part of the name when you create the UDT, but you must escape each double
         * quote character with an additional double quote character.
         * </p>
         * 
         * @param typeName
         *        The name of the user-defined type. </p>
         *        <p>
         *        UDT names must contain 48 characters or less, must begin with an alphabetic character, and can only
         *        contain alpha-numeric characters and underscores. Amazon Keyspaces converts upper case characters
         *        automatically into lower case characters.
         *        </p>
         *        <p>
         *        Alternatively, you can declare a UDT name in double quotes. When declaring a UDT name inside double
         *        quotes, Amazon Keyspaces preserves upper casing and allows special characters.
         *        </p>
         *        <p>
         *        You can also use double quotes as part of the name when you create the UDT, but you must escape each
         *        double quote character with an additional double quote character.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The field definitions, consisting of names and types, that define this type.
         * </p>
         * 
         * @param fieldDefinitions
         *        The field definitions, consisting of names and types, that define this type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldDefinitions(Collection<FieldDefinition> fieldDefinitions);

        /**
         * <p>
         * The field definitions, consisting of names and types, that define this type.
         * </p>
         * 
         * @param fieldDefinitions
         *        The field definitions, consisting of names and types, that define this type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldDefinitions(FieldDefinition... fieldDefinitions);

        /**
         * <p>
         * The field definitions, consisting of names and types, that define this type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.keyspaces.model.FieldDefinition.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.keyspaces.model.FieldDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.keyspaces.model.FieldDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #fieldDefinitions(List<FieldDefinition>)}.
         * 
         * @param fieldDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.keyspaces.model.FieldDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldDefinitions(java.util.Collection<FieldDefinition>)
         */
        Builder fieldDefinitions(Consumer<FieldDefinition.Builder>... fieldDefinitions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KeyspacesRequest.BuilderImpl implements Builder {
        private String keyspaceName;

        private String typeName;

        private List<FieldDefinition> fieldDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTypeRequest model) {
            super(model);
            keyspaceName(model.keyspaceName);
            typeName(model.typeName);
            fieldDefinitions(model.fieldDefinitions);
        }

        public final String getKeyspaceName() {
            return keyspaceName;
        }

        public final void setKeyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        @Override
        public final Builder keyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final List<FieldDefinition.Builder> getFieldDefinitions() {
            List<FieldDefinition.Builder> result = FieldListCopier.copyToBuilder(this.fieldDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldDefinitions(Collection<FieldDefinition.BuilderImpl> fieldDefinitions) {
            this.fieldDefinitions = FieldListCopier.copyFromBuilder(fieldDefinitions);
        }

        @Override
        public final Builder fieldDefinitions(Collection<FieldDefinition> fieldDefinitions) {
            this.fieldDefinitions = FieldListCopier.copy(fieldDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldDefinitions(FieldDefinition... fieldDefinitions) {
            fieldDefinitions(Arrays.asList(fieldDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldDefinitions(Consumer<FieldDefinition.Builder>... fieldDefinitions) {
            fieldDefinitions(Stream.of(fieldDefinitions).map(c -> FieldDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTypeRequest build() {
            return new CreateTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
