/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the schema of the table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchemaDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<SchemaDefinition.Builder, SchemaDefinition> {
    private static final SdkField<List<ColumnDefinition>> ALL_COLUMNS_FIELD = SdkField
            .<List<ColumnDefinition>> builder(MarshallingType.LIST)
            .memberName("allColumns")
            .getter(getter(SchemaDefinition::allColumns))
            .setter(setter(Builder::allColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PartitionKey>> PARTITION_KEYS_FIELD = SdkField
            .<List<PartitionKey>> builder(MarshallingType.LIST)
            .memberName("partitionKeys")
            .getter(getter(SchemaDefinition::partitionKeys))
            .setter(setter(Builder::partitionKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partitionKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PartitionKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(PartitionKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ClusteringKey>> CLUSTERING_KEYS_FIELD = SdkField
            .<List<ClusteringKey>> builder(MarshallingType.LIST)
            .memberName("clusteringKeys")
            .getter(getter(SchemaDefinition::clusteringKeys))
            .setter(setter(Builder::clusteringKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusteringKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClusteringKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusteringKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StaticColumn>> STATIC_COLUMNS_FIELD = SdkField
            .<List<StaticColumn>> builder(MarshallingType.LIST)
            .memberName("staticColumns")
            .getter(getter(SchemaDefinition::staticColumns))
            .setter(setter(Builder::staticColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("staticColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StaticColumn> builder(MarshallingType.SDK_POJO)
                                            .constructor(StaticColumn::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALL_COLUMNS_FIELD,
            PARTITION_KEYS_FIELD, CLUSTERING_KEYS_FIELD, STATIC_COLUMNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ColumnDefinition> allColumns;

    private final List<PartitionKey> partitionKeys;

    private final List<ClusteringKey> clusteringKeys;

    private final List<StaticColumn> staticColumns;

    private SchemaDefinition(BuilderImpl builder) {
        this.allColumns = builder.allColumns;
        this.partitionKeys = builder.partitionKeys;
        this.clusteringKeys = builder.clusteringKeys;
        this.staticColumns = builder.staticColumns;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllColumns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAllColumns() {
        return allColumns != null && !(allColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The regular columns of the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllColumns} method.
     * </p>
     * 
     * @return The regular columns of the table.
     */
    public final List<ColumnDefinition> allColumns() {
        return allColumns;
    }

    /**
     * For responses, this returns true if the service returned a value for the PartitionKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPartitionKeys() {
        return partitionKeys != null && !(partitionKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The columns that are part of the partition key of the table .
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartitionKeys} method.
     * </p>
     * 
     * @return The columns that are part of the partition key of the table .
     */
    public final List<PartitionKey> partitionKeys() {
        return partitionKeys;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusteringKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClusteringKeys() {
        return clusteringKeys != null && !(clusteringKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The columns that are part of the clustering key of the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusteringKeys} method.
     * </p>
     * 
     * @return The columns that are part of the clustering key of the table.
     */
    public final List<ClusteringKey> clusteringKeys() {
        return clusteringKeys;
    }

    /**
     * For responses, this returns true if the service returned a value for the StaticColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStaticColumns() {
        return staticColumns != null && !(staticColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The columns that have been defined as <code>STATIC</code>. Static columns store values that are shared by all
     * rows in the same partition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStaticColumns} method.
     * </p>
     * 
     * @return The columns that have been defined as <code>STATIC</code>. Static columns store values that are shared by
     *         all rows in the same partition.
     */
    public final List<StaticColumn> staticColumns() {
        return staticColumns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAllColumns() ? allColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPartitionKeys() ? partitionKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasClusteringKeys() ? clusteringKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStaticColumns() ? staticColumns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaDefinition)) {
            return false;
        }
        SchemaDefinition other = (SchemaDefinition) obj;
        return hasAllColumns() == other.hasAllColumns() && Objects.equals(allColumns(), other.allColumns())
                && hasPartitionKeys() == other.hasPartitionKeys() && Objects.equals(partitionKeys(), other.partitionKeys())
                && hasClusteringKeys() == other.hasClusteringKeys() && Objects.equals(clusteringKeys(), other.clusteringKeys())
                && hasStaticColumns() == other.hasStaticColumns() && Objects.equals(staticColumns(), other.staticColumns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SchemaDefinition").add("AllColumns", hasAllColumns() ? allColumns() : null)
                .add("PartitionKeys", hasPartitionKeys() ? partitionKeys() : null)
                .add("ClusteringKeys", hasClusteringKeys() ? clusteringKeys() : null)
                .add("StaticColumns", hasStaticColumns() ? staticColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allColumns":
            return Optional.ofNullable(clazz.cast(allColumns()));
        case "partitionKeys":
            return Optional.ofNullable(clazz.cast(partitionKeys()));
        case "clusteringKeys":
            return Optional.ofNullable(clazz.cast(clusteringKeys()));
        case "staticColumns":
            return Optional.ofNullable(clazz.cast(staticColumns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("allColumns", ALL_COLUMNS_FIELD);
        map.put("partitionKeys", PARTITION_KEYS_FIELD);
        map.put("clusteringKeys", CLUSTERING_KEYS_FIELD);
        map.put("staticColumns", STATIC_COLUMNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SchemaDefinition, T> g) {
        return obj -> g.apply((SchemaDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchemaDefinition> {
        /**
         * <p>
         * The regular columns of the table.
         * </p>
         * 
         * @param allColumns
         *        The regular columns of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allColumns(Collection<ColumnDefinition> allColumns);

        /**
         * <p>
         * The regular columns of the table.
         * </p>
         * 
         * @param allColumns
         *        The regular columns of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allColumns(ColumnDefinition... allColumns);

        /**
         * <p>
         * The regular columns of the table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.keyspaces.model.ColumnDefinition.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.keyspaces.model.ColumnDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.keyspaces.model.ColumnDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #allColumns(List<ColumnDefinition>)}.
         * 
         * @param allColumns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.keyspaces.model.ColumnDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allColumns(java.util.Collection<ColumnDefinition>)
         */
        Builder allColumns(Consumer<ColumnDefinition.Builder>... allColumns);

        /**
         * <p>
         * The columns that are part of the partition key of the table .
         * </p>
         * 
         * @param partitionKeys
         *        The columns that are part of the partition key of the table .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionKeys(Collection<PartitionKey> partitionKeys);

        /**
         * <p>
         * The columns that are part of the partition key of the table .
         * </p>
         * 
         * @param partitionKeys
         *        The columns that are part of the partition key of the table .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionKeys(PartitionKey... partitionKeys);

        /**
         * <p>
         * The columns that are part of the partition key of the table .
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.keyspaces.model.PartitionKey.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.keyspaces.model.PartitionKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.keyspaces.model.PartitionKey.Builder#build()} is called immediately
         * and its result is passed to {@link #partitionKeys(List<PartitionKey>)}.
         * 
         * @param partitionKeys
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.keyspaces.model.PartitionKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partitionKeys(java.util.Collection<PartitionKey>)
         */
        Builder partitionKeys(Consumer<PartitionKey.Builder>... partitionKeys);

        /**
         * <p>
         * The columns that are part of the clustering key of the table.
         * </p>
         * 
         * @param clusteringKeys
         *        The columns that are part of the clustering key of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusteringKeys(Collection<ClusteringKey> clusteringKeys);

        /**
         * <p>
         * The columns that are part of the clustering key of the table.
         * </p>
         * 
         * @param clusteringKeys
         *        The columns that are part of the clustering key of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusteringKeys(ClusteringKey... clusteringKeys);

        /**
         * <p>
         * The columns that are part of the clustering key of the table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.keyspaces.model.ClusteringKey.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.keyspaces.model.ClusteringKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.keyspaces.model.ClusteringKey.Builder#build()} is called immediately
         * and its result is passed to {@link #clusteringKeys(List<ClusteringKey>)}.
         * 
         * @param clusteringKeys
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.keyspaces.model.ClusteringKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusteringKeys(java.util.Collection<ClusteringKey>)
         */
        Builder clusteringKeys(Consumer<ClusteringKey.Builder>... clusteringKeys);

        /**
         * <p>
         * The columns that have been defined as <code>STATIC</code>. Static columns store values that are shared by all
         * rows in the same partition.
         * </p>
         * 
         * @param staticColumns
         *        The columns that have been defined as <code>STATIC</code>. Static columns store values that are shared
         *        by all rows in the same partition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticColumns(Collection<StaticColumn> staticColumns);

        /**
         * <p>
         * The columns that have been defined as <code>STATIC</code>. Static columns store values that are shared by all
         * rows in the same partition.
         * </p>
         * 
         * @param staticColumns
         *        The columns that have been defined as <code>STATIC</code>. Static columns store values that are shared
         *        by all rows in the same partition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticColumns(StaticColumn... staticColumns);

        /**
         * <p>
         * The columns that have been defined as <code>STATIC</code>. Static columns store values that are shared by all
         * rows in the same partition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.keyspaces.model.StaticColumn.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.keyspaces.model.StaticColumn#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.keyspaces.model.StaticColumn.Builder#build()} is called immediately
         * and its result is passed to {@link #staticColumns(List<StaticColumn>)}.
         * 
         * @param staticColumns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.keyspaces.model.StaticColumn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #staticColumns(java.util.Collection<StaticColumn>)
         */
        Builder staticColumns(Consumer<StaticColumn.Builder>... staticColumns);
    }

    static final class BuilderImpl implements Builder {
        private List<ColumnDefinition> allColumns = DefaultSdkAutoConstructList.getInstance();

        private List<PartitionKey> partitionKeys = DefaultSdkAutoConstructList.getInstance();

        private List<ClusteringKey> clusteringKeys = DefaultSdkAutoConstructList.getInstance();

        private List<StaticColumn> staticColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaDefinition model) {
            allColumns(model.allColumns);
            partitionKeys(model.partitionKeys);
            clusteringKeys(model.clusteringKeys);
            staticColumns(model.staticColumns);
        }

        public final List<ColumnDefinition.Builder> getAllColumns() {
            List<ColumnDefinition.Builder> result = ColumnDefinitionListCopier.copyToBuilder(this.allColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllColumns(Collection<ColumnDefinition.BuilderImpl> allColumns) {
            this.allColumns = ColumnDefinitionListCopier.copyFromBuilder(allColumns);
        }

        @Override
        public final Builder allColumns(Collection<ColumnDefinition> allColumns) {
            this.allColumns = ColumnDefinitionListCopier.copy(allColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allColumns(ColumnDefinition... allColumns) {
            allColumns(Arrays.asList(allColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allColumns(Consumer<ColumnDefinition.Builder>... allColumns) {
            allColumns(Stream.of(allColumns).map(c -> ColumnDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<PartitionKey.Builder> getPartitionKeys() {
            List<PartitionKey.Builder> result = PartitionKeyListCopier.copyToBuilder(this.partitionKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartitionKeys(Collection<PartitionKey.BuilderImpl> partitionKeys) {
            this.partitionKeys = PartitionKeyListCopier.copyFromBuilder(partitionKeys);
        }

        @Override
        public final Builder partitionKeys(Collection<PartitionKey> partitionKeys) {
            this.partitionKeys = PartitionKeyListCopier.copy(partitionKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionKeys(PartitionKey... partitionKeys) {
            partitionKeys(Arrays.asList(partitionKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionKeys(Consumer<PartitionKey.Builder>... partitionKeys) {
            partitionKeys(Stream.of(partitionKeys).map(c -> PartitionKey.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ClusteringKey.Builder> getClusteringKeys() {
            List<ClusteringKey.Builder> result = ClusteringKeyListCopier.copyToBuilder(this.clusteringKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusteringKeys(Collection<ClusteringKey.BuilderImpl> clusteringKeys) {
            this.clusteringKeys = ClusteringKeyListCopier.copyFromBuilder(clusteringKeys);
        }

        @Override
        public final Builder clusteringKeys(Collection<ClusteringKey> clusteringKeys) {
            this.clusteringKeys = ClusteringKeyListCopier.copy(clusteringKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusteringKeys(ClusteringKey... clusteringKeys) {
            clusteringKeys(Arrays.asList(clusteringKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusteringKeys(Consumer<ClusteringKey.Builder>... clusteringKeys) {
            clusteringKeys(Stream.of(clusteringKeys).map(c -> ClusteringKey.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StaticColumn.Builder> getStaticColumns() {
            List<StaticColumn.Builder> result = StaticColumnListCopier.copyToBuilder(this.staticColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStaticColumns(Collection<StaticColumn.BuilderImpl> staticColumns) {
            this.staticColumns = StaticColumnListCopier.copyFromBuilder(staticColumns);
        }

        @Override
        public final Builder staticColumns(Collection<StaticColumn> staticColumns) {
            this.staticColumns = StaticColumnListCopier.copy(staticColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staticColumns(StaticColumn... staticColumns) {
            staticColumns(Arrays.asList(staticColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staticColumns(Consumer<StaticColumn.Builder>... staticColumns) {
            staticColumns(Stream.of(staticColumns).map(c -> StaticColumn.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SchemaDefinition build() {
            return new SchemaDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
