/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class StaticColumnListCopier {
    static List<StaticColumn> copy(Collection<? extends StaticColumn> staticColumnListParam) {
        List<StaticColumn> list;
        if (staticColumnListParam == null || staticColumnListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<StaticColumn> modifiableList = new ArrayList<>(staticColumnListParam.size());
            staticColumnListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<StaticColumn> copyFromBuilder(Collection<? extends StaticColumn.Builder> staticColumnListParam) {
        List<StaticColumn> list;
        if (staticColumnListParam == null || staticColumnListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<StaticColumn> modifiableList = new ArrayList<>(staticColumnListParam.size());
            staticColumnListParam.forEach(entry -> {
                StaticColumn member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<StaticColumn.Builder> copyToBuilder(Collection<? extends StaticColumn> staticColumnListParam) {
        List<StaticColumn.Builder> list;
        if (staticColumnListParam == null || staticColumnListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<StaticColumn.Builder> modifiableList = new ArrayList<>(staticColumnListParam.size());
            staticColumnListParam.forEach(entry -> {
                StaticColumn.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
