/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateKeyspaceRequest extends KeyspacesRequest implements
        ToCopyableBuilder<UpdateKeyspaceRequest.Builder, UpdateKeyspaceRequest> {
    private static final SdkField<String> KEYSPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyspaceName").getter(getter(UpdateKeyspaceRequest::keyspaceName)).setter(setter(Builder::keyspaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceName").build()).build();

    private static final SdkField<ReplicationSpecification> REPLICATION_SPECIFICATION_FIELD = SdkField
            .<ReplicationSpecification> builder(MarshallingType.SDK_POJO).memberName("replicationSpecification")
            .getter(getter(UpdateKeyspaceRequest::replicationSpecification)).setter(setter(Builder::replicationSpecification))
            .constructor(ReplicationSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationSpecification").build())
            .build();

    private static final SdkField<ClientSideTimestamps> CLIENT_SIDE_TIMESTAMPS_FIELD = SdkField
            .<ClientSideTimestamps> builder(MarshallingType.SDK_POJO).memberName("clientSideTimestamps")
            .getter(getter(UpdateKeyspaceRequest::clientSideTimestamps)).setter(setter(Builder::clientSideTimestamps))
            .constructor(ClientSideTimestamps::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSideTimestamps").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYSPACE_NAME_FIELD,
            REPLICATION_SPECIFICATION_FIELD, CLIENT_SIDE_TIMESTAMPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String keyspaceName;

    private final ReplicationSpecification replicationSpecification;

    private final ClientSideTimestamps clientSideTimestamps;

    private UpdateKeyspaceRequest(BuilderImpl builder) {
        super(builder);
        this.keyspaceName = builder.keyspaceName;
        this.replicationSpecification = builder.replicationSpecification;
        this.clientSideTimestamps = builder.clientSideTimestamps;
    }

    /**
     * <p>
     * The name of the keyspace.
     * </p>
     * 
     * @return The name of the keyspace.
     */
    public final String keyspaceName() {
        return keyspaceName;
    }

    /**
     * Returns the value of the ReplicationSpecification property for this object.
     * 
     * @return The value of the ReplicationSpecification property for this object.
     */
    public final ReplicationSpecification replicationSpecification() {
        return replicationSpecification;
    }

    /**
     * Returns the value of the ClientSideTimestamps property for this object.
     * 
     * @return The value of the ClientSideTimestamps property for this object.
     */
    public final ClientSideTimestamps clientSideTimestamps() {
        return clientSideTimestamps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(replicationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(clientSideTimestamps());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKeyspaceRequest)) {
            return false;
        }
        UpdateKeyspaceRequest other = (UpdateKeyspaceRequest) obj;
        return Objects.equals(keyspaceName(), other.keyspaceName())
                && Objects.equals(replicationSpecification(), other.replicationSpecification())
                && Objects.equals(clientSideTimestamps(), other.clientSideTimestamps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateKeyspaceRequest").add("KeyspaceName", keyspaceName())
                .add("ReplicationSpecification", replicationSpecification()).add("ClientSideTimestamps", clientSideTimestamps())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "keyspaceName":
            return Optional.ofNullable(clazz.cast(keyspaceName()));
        case "replicationSpecification":
            return Optional.ofNullable(clazz.cast(replicationSpecification()));
        case "clientSideTimestamps":
            return Optional.ofNullable(clazz.cast(clientSideTimestamps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("keyspaceName", KEYSPACE_NAME_FIELD);
        map.put("replicationSpecification", REPLICATION_SPECIFICATION_FIELD);
        map.put("clientSideTimestamps", CLIENT_SIDE_TIMESTAMPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateKeyspaceRequest, T> g) {
        return obj -> g.apply((UpdateKeyspaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KeyspacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateKeyspaceRequest> {
        /**
         * <p>
         * The name of the keyspace.
         * </p>
         * 
         * @param keyspaceName
         *        The name of the keyspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyspaceName(String keyspaceName);

        /**
         * Sets the value of the ReplicationSpecification property for this object.
         *
         * @param replicationSpecification
         *        The new value for the ReplicationSpecification property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationSpecification(ReplicationSpecification replicationSpecification);

        /**
         * Sets the value of the ReplicationSpecification property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ReplicationSpecification.Builder}
         * avoiding the need to create one manually via {@link ReplicationSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReplicationSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #replicationSpecification(ReplicationSpecification)}.
         * 
         * @param replicationSpecification
         *        a consumer that will call methods on {@link ReplicationSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationSpecification(ReplicationSpecification)
         */
        default Builder replicationSpecification(Consumer<ReplicationSpecification.Builder> replicationSpecification) {
            return replicationSpecification(ReplicationSpecification.builder().applyMutation(replicationSpecification).build());
        }

        /**
         * Sets the value of the ClientSideTimestamps property for this object.
         *
         * @param clientSideTimestamps
         *        The new value for the ClientSideTimestamps property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSideTimestamps(ClientSideTimestamps clientSideTimestamps);

        /**
         * Sets the value of the ClientSideTimestamps property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ClientSideTimestamps.Builder} avoiding
         * the need to create one manually via {@link ClientSideTimestamps#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClientSideTimestamps.Builder#build()} is called immediately and
         * its result is passed to {@link #clientSideTimestamps(ClientSideTimestamps)}.
         * 
         * @param clientSideTimestamps
         *        a consumer that will call methods on {@link ClientSideTimestamps.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientSideTimestamps(ClientSideTimestamps)
         */
        default Builder clientSideTimestamps(Consumer<ClientSideTimestamps.Builder> clientSideTimestamps) {
            return clientSideTimestamps(ClientSideTimestamps.builder().applyMutation(clientSideTimestamps).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KeyspacesRequest.BuilderImpl implements Builder {
        private String keyspaceName;

        private ReplicationSpecification replicationSpecification;

        private ClientSideTimestamps clientSideTimestamps;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKeyspaceRequest model) {
            super(model);
            keyspaceName(model.keyspaceName);
            replicationSpecification(model.replicationSpecification);
            clientSideTimestamps(model.clientSideTimestamps);
        }

        public final String getKeyspaceName() {
            return keyspaceName;
        }

        public final void setKeyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        @Override
        public final Builder keyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public final ReplicationSpecification.Builder getReplicationSpecification() {
            return replicationSpecification != null ? replicationSpecification.toBuilder() : null;
        }

        public final void setReplicationSpecification(ReplicationSpecification.BuilderImpl replicationSpecification) {
            this.replicationSpecification = replicationSpecification != null ? replicationSpecification.build() : null;
        }

        @Override
        public final Builder replicationSpecification(ReplicationSpecification replicationSpecification) {
            this.replicationSpecification = replicationSpecification;
            return this;
        }

        public final ClientSideTimestamps.Builder getClientSideTimestamps() {
            return clientSideTimestamps != null ? clientSideTimestamps.toBuilder() : null;
        }

        public final void setClientSideTimestamps(ClientSideTimestamps.BuilderImpl clientSideTimestamps) {
            this.clientSideTimestamps = clientSideTimestamps != null ? clientSideTimestamps.build() : null;
        }

        @Override
        public final Builder clientSideTimestamps(ClientSideTimestamps clientSideTimestamps) {
            this.clientSideTimestamps = clientSideTimestamps;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateKeyspaceRequest build() {
            return new UpdateKeyspaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
