/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspacesstreams.model;

import java.beans.Transient;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the value of a cell in an Amazon Keyspaces table, supporting various data types with type-specific fields.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeyspacesCellValue implements SdkPojo, Serializable,
        ToCopyableBuilder<KeyspacesCellValue.Builder, KeyspacesCellValue> {
    private static final SdkField<String> ASCIIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("asciiT")
            .getter(getter(KeyspacesCellValue::asciiT)).setter(setter(Builder::asciiT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asciiT").build()).build();

    private static final SdkField<String> BIGINTT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("bigintT")
            .getter(getter(KeyspacesCellValue::bigintT)).setter(setter(Builder::bigintT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bigintT").build()).build();

    private static final SdkField<SdkBytes> BLOBT_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("blobT").getter(getter(KeyspacesCellValue::blobT)).setter(setter(Builder::blobT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blobT").build()).build();

    private static final SdkField<Boolean> BOOLT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("boolT")
            .getter(getter(KeyspacesCellValue::boolT)).setter(setter(Builder::boolT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("boolT").build()).build();

    private static final SdkField<String> COUNTERT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("counterT").getter(getter(KeyspacesCellValue::counterT)).setter(setter(Builder::counterT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("counterT").build()).build();

    private static final SdkField<String> DATET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("dateT")
            .getter(getter(KeyspacesCellValue::dateT)).setter(setter(Builder::dateT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateT").build()).build();

    private static final SdkField<String> DECIMALT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("decimalT").getter(getter(KeyspacesCellValue::decimalT)).setter(setter(Builder::decimalT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decimalT").build()).build();

    private static final SdkField<String> DOUBLET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("doubleT")
            .getter(getter(KeyspacesCellValue::doubleT)).setter(setter(Builder::doubleT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleT").build()).build();

    private static final SdkField<String> FLOATT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("floatT")
            .getter(getter(KeyspacesCellValue::floatT)).setter(setter(Builder::floatT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("floatT").build()).build();

    private static final SdkField<String> INETT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("inetT")
            .getter(getter(KeyspacesCellValue::inetT)).setter(setter(Builder::inetT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inetT").build()).build();

    private static final SdkField<String> INTT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("intT")
            .getter(getter(KeyspacesCellValue::intT)).setter(setter(Builder::intT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intT").build()).build();

    private static final SdkField<List<KeyspacesCell>> LISTT_FIELD = SdkField
            .<List<KeyspacesCell>> builder(MarshallingType.LIST)
            .memberName("listT")
            .getter(getter(KeyspacesCellValue::listT))
            .setter(setter(Builder::listT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listT").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeyspacesCell> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyspacesCell::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<KeyspacesCellMapDefinition>> MAPT_FIELD = SdkField
            .<List<KeyspacesCellMapDefinition>> builder(MarshallingType.LIST)
            .memberName("mapT")
            .getter(getter(KeyspacesCellValue::mapT))
            .setter(setter(Builder::mapT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapT").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeyspacesCellMapDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyspacesCellMapDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<KeyspacesCell>> SETT_FIELD = SdkField
            .<List<KeyspacesCell>> builder(MarshallingType.LIST)
            .memberName("setT")
            .getter(getter(KeyspacesCellValue::setT))
            .setter(setter(Builder::setT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("setT").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeyspacesCell> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyspacesCell::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SMALLINTT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("smallintT").getter(getter(KeyspacesCellValue::smallintT)).setter(setter(Builder::smallintT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smallintT").build()).build();

    private static final SdkField<String> TEXTT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("textT")
            .getter(getter(KeyspacesCellValue::textT)).setter(setter(Builder::textT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textT").build()).build();

    private static final SdkField<String> TIMET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("timeT")
            .getter(getter(KeyspacesCellValue::timeT)).setter(setter(Builder::timeT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeT").build()).build();

    private static final SdkField<String> TIMESTAMPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timestampT").getter(getter(KeyspacesCellValue::timestampT)).setter(setter(Builder::timestampT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestampT").build()).build();

    private static final SdkField<String> TIMEUUIDT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timeuuidT").getter(getter(KeyspacesCellValue::timeuuidT)).setter(setter(Builder::timeuuidT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeuuidT").build()).build();

    private static final SdkField<String> TINYINTT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tinyintT").getter(getter(KeyspacesCellValue::tinyintT)).setter(setter(Builder::tinyintT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tinyintT").build()).build();

    private static final SdkField<List<KeyspacesCell>> TUPLET_FIELD = SdkField
            .<List<KeyspacesCell>> builder(MarshallingType.LIST)
            .memberName("tupleT")
            .getter(getter(KeyspacesCellValue::tupleT))
            .setter(setter(Builder::tupleT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tupleT").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeyspacesCell> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyspacesCell::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> UUIDT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("uuidT")
            .getter(getter(KeyspacesCellValue::uuidT)).setter(setter(Builder::uuidT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uuidT").build()).build();

    private static final SdkField<String> VARCHART_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("varcharT").getter(getter(KeyspacesCellValue::varcharT)).setter(setter(Builder::varcharT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("varcharT").build()).build();

    private static final SdkField<String> VARINTT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("varintT")
            .getter(getter(KeyspacesCellValue::varintT)).setter(setter(Builder::varintT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("varintT").build()).build();

    private static final SdkField<Map<String, KeyspacesCell>> UDTT_FIELD = SdkField
            .<Map<String, KeyspacesCell>> builder(MarshallingType.MAP)
            .memberName("udtT")
            .getter(getter(KeyspacesCellValue::udtT))
            .setter(setter(Builder::udtT))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("udtT").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<KeyspacesCell> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyspacesCell::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASCIIT_FIELD, BIGINTT_FIELD,
            BLOBT_FIELD, BOOLT_FIELD, COUNTERT_FIELD, DATET_FIELD, DECIMALT_FIELD, DOUBLET_FIELD, FLOATT_FIELD, INETT_FIELD,
            INTT_FIELD, LISTT_FIELD, MAPT_FIELD, SETT_FIELD, SMALLINTT_FIELD, TEXTT_FIELD, TIMET_FIELD, TIMESTAMPT_FIELD,
            TIMEUUIDT_FIELD, TINYINTT_FIELD, TUPLET_FIELD, UUIDT_FIELD, VARCHART_FIELD, VARINTT_FIELD, UDTT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String asciiT;

    private final String bigintT;

    private final SdkBytes blobT;

    private final Boolean boolT;

    private final String counterT;

    private final String dateT;

    private final String decimalT;

    private final String doubleT;

    private final String floatT;

    private final String inetT;

    private final String intT;

    private final List<KeyspacesCell> listT;

    private final List<KeyspacesCellMapDefinition> mapT;

    private final List<KeyspacesCell> setT;

    private final String smallintT;

    private final String textT;

    private final String timeT;

    private final String timestampT;

    private final String timeuuidT;

    private final String tinyintT;

    private final List<KeyspacesCell> tupleT;

    private final String uuidT;

    private final String varcharT;

    private final String varintT;

    private final Map<String, KeyspacesCell> udtT;

    private final Type type;

    private KeyspacesCellValue(BuilderImpl builder) {
        this.asciiT = builder.asciiT;
        this.bigintT = builder.bigintT;
        this.blobT = builder.blobT;
        this.boolT = builder.boolT;
        this.counterT = builder.counterT;
        this.dateT = builder.dateT;
        this.decimalT = builder.decimalT;
        this.doubleT = builder.doubleT;
        this.floatT = builder.floatT;
        this.inetT = builder.inetT;
        this.intT = builder.intT;
        this.listT = builder.listT;
        this.mapT = builder.mapT;
        this.setT = builder.setT;
        this.smallintT = builder.smallintT;
        this.textT = builder.textT;
        this.timeT = builder.timeT;
        this.timestampT = builder.timestampT;
        this.timeuuidT = builder.timeuuidT;
        this.tinyintT = builder.tinyintT;
        this.tupleT = builder.tupleT;
        this.uuidT = builder.uuidT;
        this.varcharT = builder.varcharT;
        this.varintT = builder.varintT;
        this.udtT = builder.udtT;
        this.type = builder.type;
    }

    /**
     * <p>
     * A value of ASCII text type, containing US-ASCII characters.
     * </p>
     * 
     * @return A value of ASCII text type, containing US-ASCII characters.
     */
    public final String asciiT() {
        return asciiT;
    }

    /**
     * <p>
     * A 64-bit signed integer value.
     * </p>
     * 
     * @return A 64-bit signed integer value.
     */
    public final String bigintT() {
        return bigintT;
    }

    /**
     * <p>
     * A binary large object (BLOB) value stored as a Base64-encoded string.
     * </p>
     * 
     * @return A binary large object (BLOB) value stored as a Base64-encoded string.
     */
    public final SdkBytes blobT() {
        return blobT;
    }

    /**
     * <p>
     * A Boolean value, either <code>true</code> or <code>false</code>.
     * </p>
     * 
     * @return A Boolean value, either <code>true</code> or <code>false</code>.
     */
    public final Boolean boolT() {
        return boolT;
    }

    /**
     * <p>
     * A distributed counter value that can be incremented and decremented.
     * </p>
     * 
     * @return A distributed counter value that can be incremented and decremented.
     */
    public final String counterT() {
        return counterT;
    }

    /**
     * <p>
     * A date value without a time component, represented as days since epoch (January 1, 1970).
     * </p>
     * 
     * @return A date value without a time component, represented as days since epoch (January 1, 1970).
     */
    public final String dateT() {
        return dateT;
    }

    /**
     * <p>
     * A variable-precision decimal number value.
     * </p>
     * 
     * @return A variable-precision decimal number value.
     */
    public final String decimalT() {
        return decimalT;
    }

    /**
     * <p>
     * A 64-bit double-precision floating point value.
     * </p>
     * 
     * @return A 64-bit double-precision floating point value.
     */
    public final String doubleT() {
        return doubleT;
    }

    /**
     * <p>
     * A 32-bit single-precision floating point value.
     * </p>
     * 
     * @return A 32-bit single-precision floating point value.
     */
    public final String floatT() {
        return floatT;
    }

    /**
     * <p>
     * An IP address value, either IPv4 or IPv6 format.
     * </p>
     * 
     * @return An IP address value, either IPv4 or IPv6 format.
     */
    public final String inetT() {
        return inetT;
    }

    /**
     * <p>
     * A 32-bit signed integer value.
     * </p>
     * 
     * @return A 32-bit signed integer value.
     */
    public final String intT() {
        return intT;
    }

    /**
     * For responses, this returns true if the service returned a value for the ListT property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasListT() {
        return listT != null && !(listT instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An ordered collection of elements that can contain duplicate values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListT} method.
     * </p>
     * 
     * @return An ordered collection of elements that can contain duplicate values.
     */
    public final List<KeyspacesCell> listT() {
        return listT;
    }

    /**
     * For responses, this returns true if the service returned a value for the MapT property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasMapT() {
        return mapT != null && !(mapT instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of key-value pairs where each key is unique.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMapT} method.
     * </p>
     * 
     * @return A collection of key-value pairs where each key is unique.
     */
    public final List<KeyspacesCellMapDefinition> mapT() {
        return mapT;
    }

    /**
     * For responses, this returns true if the service returned a value for the SetT property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSetT() {
        return setT != null && !(setT instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An unordered collection of unique elements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSetT} method.
     * </p>
     * 
     * @return An unordered collection of unique elements.
     */
    public final List<KeyspacesCell> setT() {
        return setT;
    }

    /**
     * <p>
     * A 16-bit signed integer value.
     * </p>
     * 
     * @return A 16-bit signed integer value.
     */
    public final String smallintT() {
        return smallintT;
    }

    /**
     * <p>
     * A UTF-8 encoded string value.
     * </p>
     * 
     * @return A UTF-8 encoded string value.
     */
    public final String textT() {
        return textT;
    }

    /**
     * <p>
     * A time value without a date component, with nanosecond precision.
     * </p>
     * 
     * @return A time value without a date component, with nanosecond precision.
     */
    public final String timeT() {
        return timeT;
    }

    /**
     * <p>
     * A timestamp value representing date and time with millisecond precision.
     * </p>
     * 
     * @return A timestamp value representing date and time with millisecond precision.
     */
    public final String timestampT() {
        return timestampT;
    }

    /**
     * <p>
     * A universally unique identifier (UUID) that includes a timestamp component, ensuring both uniqueness and time
     * ordering.
     * </p>
     * 
     * @return A universally unique identifier (UUID) that includes a timestamp component, ensuring both uniqueness and
     *         time ordering.
     */
    public final String timeuuidT() {
        return timeuuidT;
    }

    /**
     * <p>
     * An 8-bit signed integer value.
     * </p>
     * 
     * @return An 8-bit signed integer value.
     */
    public final String tinyintT() {
        return tinyintT;
    }

    /**
     * For responses, this returns true if the service returned a value for the TupleT property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTupleT() {
        return tupleT != null && !(tupleT instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A fixed-length ordered list of elements, where each element can be of a different data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTupleT} method.
     * </p>
     * 
     * @return A fixed-length ordered list of elements, where each element can be of a different data type.
     */
    public final List<KeyspacesCell> tupleT() {
        return tupleT;
    }

    /**
     * <p>
     * A universally unique identifier (UUID) value.
     * </p>
     * 
     * @return A universally unique identifier (UUID) value.
     */
    public final String uuidT() {
        return uuidT;
    }

    /**
     * <p>
     * A UTF-8 encoded string value, functionally equivalent to text type.
     * </p>
     * 
     * @return A UTF-8 encoded string value, functionally equivalent to text type.
     */
    public final String varcharT() {
        return varcharT;
    }

    /**
     * <p>
     * A variable precision integer value with arbitrary length.
     * </p>
     * 
     * @return A variable precision integer value with arbitrary length.
     */
    public final String varintT() {
        return varintT;
    }

    /**
     * For responses, this returns true if the service returned a value for the UdtT property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasUdtT() {
        return udtT != null && !(udtT instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A user-defined type (UDT) value consisting of named fields, each with its own data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUdtT} method.
     * </p>
     * 
     * @return A user-defined type (UDT) value consisting of named fields, each with its own data type.
     */
    public final Map<String, KeyspacesCell> udtT() {
        return udtT;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(asciiT());
        hashCode = 31 * hashCode + Objects.hashCode(bigintT());
        hashCode = 31 * hashCode + Objects.hashCode(blobT());
        hashCode = 31 * hashCode + Objects.hashCode(boolT());
        hashCode = 31 * hashCode + Objects.hashCode(counterT());
        hashCode = 31 * hashCode + Objects.hashCode(dateT());
        hashCode = 31 * hashCode + Objects.hashCode(decimalT());
        hashCode = 31 * hashCode + Objects.hashCode(doubleT());
        hashCode = 31 * hashCode + Objects.hashCode(floatT());
        hashCode = 31 * hashCode + Objects.hashCode(inetT());
        hashCode = 31 * hashCode + Objects.hashCode(intT());
        hashCode = 31 * hashCode + Objects.hashCode(hasListT() ? listT() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMapT() ? mapT() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSetT() ? setT() : null);
        hashCode = 31 * hashCode + Objects.hashCode(smallintT());
        hashCode = 31 * hashCode + Objects.hashCode(textT());
        hashCode = 31 * hashCode + Objects.hashCode(timeT());
        hashCode = 31 * hashCode + Objects.hashCode(timestampT());
        hashCode = 31 * hashCode + Objects.hashCode(timeuuidT());
        hashCode = 31 * hashCode + Objects.hashCode(tinyintT());
        hashCode = 31 * hashCode + Objects.hashCode(hasTupleT() ? tupleT() : null);
        hashCode = 31 * hashCode + Objects.hashCode(uuidT());
        hashCode = 31 * hashCode + Objects.hashCode(varcharT());
        hashCode = 31 * hashCode + Objects.hashCode(varintT());
        hashCode = 31 * hashCode + Objects.hashCode(hasUdtT() ? udtT() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyspacesCellValue)) {
            return false;
        }
        KeyspacesCellValue other = (KeyspacesCellValue) obj;
        return Objects.equals(asciiT(), other.asciiT()) && Objects.equals(bigintT(), other.bigintT())
                && Objects.equals(blobT(), other.blobT()) && Objects.equals(boolT(), other.boolT())
                && Objects.equals(counterT(), other.counterT()) && Objects.equals(dateT(), other.dateT())
                && Objects.equals(decimalT(), other.decimalT()) && Objects.equals(doubleT(), other.doubleT())
                && Objects.equals(floatT(), other.floatT()) && Objects.equals(inetT(), other.inetT())
                && Objects.equals(intT(), other.intT()) && hasListT() == other.hasListT()
                && Objects.equals(listT(), other.listT()) && hasMapT() == other.hasMapT() && Objects.equals(mapT(), other.mapT())
                && hasSetT() == other.hasSetT() && Objects.equals(setT(), other.setT())
                && Objects.equals(smallintT(), other.smallintT()) && Objects.equals(textT(), other.textT())
                && Objects.equals(timeT(), other.timeT()) && Objects.equals(timestampT(), other.timestampT())
                && Objects.equals(timeuuidT(), other.timeuuidT()) && Objects.equals(tinyintT(), other.tinyintT())
                && hasTupleT() == other.hasTupleT() && Objects.equals(tupleT(), other.tupleT())
                && Objects.equals(uuidT(), other.uuidT()) && Objects.equals(varcharT(), other.varcharT())
                && Objects.equals(varintT(), other.varintT()) && hasUdtT() == other.hasUdtT()
                && Objects.equals(udtT(), other.udtT());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeyspacesCellValue").add("AsciiT", asciiT()).add("BigintT", bigintT()).add("BlobT", blobT())
                .add("BoolT", boolT()).add("CounterT", counterT()).add("DateT", dateT()).add("DecimalT", decimalT())
                .add("DoubleT", doubleT()).add("FloatT", floatT()).add("InetT", inetT()).add("IntT", intT())
                .add("ListT", hasListT() ? listT() : null).add("MapT", hasMapT() ? mapT() : null)
                .add("SetT", hasSetT() ? setT() : null).add("SmallintT", smallintT()).add("TextT", textT()).add("TimeT", timeT())
                .add("TimestampT", timestampT()).add("TimeuuidT", timeuuidT()).add("TinyintT", tinyintT())
                .add("TupleT", hasTupleT() ? tupleT() : null).add("UuidT", uuidT()).add("VarcharT", varcharT())
                .add("VarintT", varintT()).add("UdtT", hasUdtT() ? udtT() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "asciiT":
            return Optional.ofNullable(clazz.cast(asciiT()));
        case "bigintT":
            return Optional.ofNullable(clazz.cast(bigintT()));
        case "blobT":
            return Optional.ofNullable(clazz.cast(blobT()));
        case "boolT":
            return Optional.ofNullable(clazz.cast(boolT()));
        case "counterT":
            return Optional.ofNullable(clazz.cast(counterT()));
        case "dateT":
            return Optional.ofNullable(clazz.cast(dateT()));
        case "decimalT":
            return Optional.ofNullable(clazz.cast(decimalT()));
        case "doubleT":
            return Optional.ofNullable(clazz.cast(doubleT()));
        case "floatT":
            return Optional.ofNullable(clazz.cast(floatT()));
        case "inetT":
            return Optional.ofNullable(clazz.cast(inetT()));
        case "intT":
            return Optional.ofNullable(clazz.cast(intT()));
        case "listT":
            return Optional.ofNullable(clazz.cast(listT()));
        case "mapT":
            return Optional.ofNullable(clazz.cast(mapT()));
        case "setT":
            return Optional.ofNullable(clazz.cast(setT()));
        case "smallintT":
            return Optional.ofNullable(clazz.cast(smallintT()));
        case "textT":
            return Optional.ofNullable(clazz.cast(textT()));
        case "timeT":
            return Optional.ofNullable(clazz.cast(timeT()));
        case "timestampT":
            return Optional.ofNullable(clazz.cast(timestampT()));
        case "timeuuidT":
            return Optional.ofNullable(clazz.cast(timeuuidT()));
        case "tinyintT":
            return Optional.ofNullable(clazz.cast(tinyintT()));
        case "tupleT":
            return Optional.ofNullable(clazz.cast(tupleT()));
        case "uuidT":
            return Optional.ofNullable(clazz.cast(uuidT()));
        case "varcharT":
            return Optional.ofNullable(clazz.cast(varcharT()));
        case "varintT":
            return Optional.ofNullable(clazz.cast(varintT()));
        case "udtT":
            return Optional.ofNullable(clazz.cast(udtT()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #asciiT()} initialized to the given value.
     *
     * <p>
     * A value of ASCII text type, containing US-ASCII characters.
     * </p>
     * 
     * @param asciiT
     *        A value of ASCII text type, containing US-ASCII characters.
     */
    public static KeyspacesCellValue fromAsciiT(String asciiT) {
        return builder().asciiT(asciiT).build();
    }

    /**
     * Create an instance of this class with {@link #bigintT()} initialized to the given value.
     *
     * <p>
     * A 64-bit signed integer value.
     * </p>
     * 
     * @param bigintT
     *        A 64-bit signed integer value.
     */
    public static KeyspacesCellValue fromBigintT(String bigintT) {
        return builder().bigintT(bigintT).build();
    }

    /**
     * Create an instance of this class with {@link #blobT()} initialized to the given value.
     *
     * <p>
     * A binary large object (BLOB) value stored as a Base64-encoded string.
     * </p>
     * 
     * @param blobT
     *        A binary large object (BLOB) value stored as a Base64-encoded string.
     */
    public static KeyspacesCellValue fromBlobT(SdkBytes blobT) {
        return builder().blobT(blobT).build();
    }

    /**
     * Create an instance of this class with {@link #boolT()} initialized to the given value.
     *
     * <p>
     * A Boolean value, either <code>true</code> or <code>false</code>.
     * </p>
     * 
     * @param boolT
     *        A Boolean value, either <code>true</code> or <code>false</code>.
     */
    public static KeyspacesCellValue fromBoolT(Boolean boolT) {
        return builder().boolT(boolT).build();
    }

    /**
     * Create an instance of this class with {@link #counterT()} initialized to the given value.
     *
     * <p>
     * A distributed counter value that can be incremented and decremented.
     * </p>
     * 
     * @param counterT
     *        A distributed counter value that can be incremented and decremented.
     */
    public static KeyspacesCellValue fromCounterT(String counterT) {
        return builder().counterT(counterT).build();
    }

    /**
     * Create an instance of this class with {@link #dateT()} initialized to the given value.
     *
     * <p>
     * A date value without a time component, represented as days since epoch (January 1, 1970).
     * </p>
     * 
     * @param dateT
     *        A date value without a time component, represented as days since epoch (January 1, 1970).
     */
    public static KeyspacesCellValue fromDateT(String dateT) {
        return builder().dateT(dateT).build();
    }

    /**
     * Create an instance of this class with {@link #decimalT()} initialized to the given value.
     *
     * <p>
     * A variable-precision decimal number value.
     * </p>
     * 
     * @param decimalT
     *        A variable-precision decimal number value.
     */
    public static KeyspacesCellValue fromDecimalT(String decimalT) {
        return builder().decimalT(decimalT).build();
    }

    /**
     * Create an instance of this class with {@link #doubleT()} initialized to the given value.
     *
     * <p>
     * A 64-bit double-precision floating point value.
     * </p>
     * 
     * @param doubleT
     *        A 64-bit double-precision floating point value.
     */
    public static KeyspacesCellValue fromDoubleT(String doubleT) {
        return builder().doubleT(doubleT).build();
    }

    /**
     * Create an instance of this class with {@link #floatT()} initialized to the given value.
     *
     * <p>
     * A 32-bit single-precision floating point value.
     * </p>
     * 
     * @param floatT
     *        A 32-bit single-precision floating point value.
     */
    public static KeyspacesCellValue fromFloatT(String floatT) {
        return builder().floatT(floatT).build();
    }

    /**
     * Create an instance of this class with {@link #inetT()} initialized to the given value.
     *
     * <p>
     * An IP address value, either IPv4 or IPv6 format.
     * </p>
     * 
     * @param inetT
     *        An IP address value, either IPv4 or IPv6 format.
     */
    public static KeyspacesCellValue fromInetT(String inetT) {
        return builder().inetT(inetT).build();
    }

    /**
     * Create an instance of this class with {@link #intT()} initialized to the given value.
     *
     * <p>
     * A 32-bit signed integer value.
     * </p>
     * 
     * @param intT
     *        A 32-bit signed integer value.
     */
    public static KeyspacesCellValue fromIntT(String intT) {
        return builder().intT(intT).build();
    }

    /**
     * Create an instance of this class with {@link #listT()} initialized to the given value.
     *
     * <p>
     * An ordered collection of elements that can contain duplicate values.
     * </p>
     * 
     * @param listT
     *        An ordered collection of elements that can contain duplicate values.
     */
    public static KeyspacesCellValue fromListT(List<KeyspacesCell> listT) {
        return builder().listT(listT).build();
    }

    /**
     * Create an instance of this class with {@link #mapT()} initialized to the given value.
     *
     * <p>
     * A collection of key-value pairs where each key is unique.
     * </p>
     * 
     * @param mapT
     *        A collection of key-value pairs where each key is unique.
     */
    public static KeyspacesCellValue fromMapT(List<KeyspacesCellMapDefinition> mapT) {
        return builder().mapT(mapT).build();
    }

    /**
     * Create an instance of this class with {@link #setT()} initialized to the given value.
     *
     * <p>
     * An unordered collection of unique elements.
     * </p>
     * 
     * @param setT
     *        An unordered collection of unique elements.
     */
    public static KeyspacesCellValue fromSetT(List<KeyspacesCell> setT) {
        return builder().setT(setT).build();
    }

    /**
     * Create an instance of this class with {@link #smallintT()} initialized to the given value.
     *
     * <p>
     * A 16-bit signed integer value.
     * </p>
     * 
     * @param smallintT
     *        A 16-bit signed integer value.
     */
    public static KeyspacesCellValue fromSmallintT(String smallintT) {
        return builder().smallintT(smallintT).build();
    }

    /**
     * Create an instance of this class with {@link #textT()} initialized to the given value.
     *
     * <p>
     * A UTF-8 encoded string value.
     * </p>
     * 
     * @param textT
     *        A UTF-8 encoded string value.
     */
    public static KeyspacesCellValue fromTextT(String textT) {
        return builder().textT(textT).build();
    }

    /**
     * Create an instance of this class with {@link #timeT()} initialized to the given value.
     *
     * <p>
     * A time value without a date component, with nanosecond precision.
     * </p>
     * 
     * @param timeT
     *        A time value without a date component, with nanosecond precision.
     */
    public static KeyspacesCellValue fromTimeT(String timeT) {
        return builder().timeT(timeT).build();
    }

    /**
     * Create an instance of this class with {@link #timestampT()} initialized to the given value.
     *
     * <p>
     * A timestamp value representing date and time with millisecond precision.
     * </p>
     * 
     * @param timestampT
     *        A timestamp value representing date and time with millisecond precision.
     */
    public static KeyspacesCellValue fromTimestampT(String timestampT) {
        return builder().timestampT(timestampT).build();
    }

    /**
     * Create an instance of this class with {@link #timeuuidT()} initialized to the given value.
     *
     * <p>
     * A universally unique identifier (UUID) that includes a timestamp component, ensuring both uniqueness and time
     * ordering.
     * </p>
     * 
     * @param timeuuidT
     *        A universally unique identifier (UUID) that includes a timestamp component, ensuring both uniqueness and
     *        time ordering.
     */
    public static KeyspacesCellValue fromTimeuuidT(String timeuuidT) {
        return builder().timeuuidT(timeuuidT).build();
    }

    /**
     * Create an instance of this class with {@link #tinyintT()} initialized to the given value.
     *
     * <p>
     * An 8-bit signed integer value.
     * </p>
     * 
     * @param tinyintT
     *        An 8-bit signed integer value.
     */
    public static KeyspacesCellValue fromTinyintT(String tinyintT) {
        return builder().tinyintT(tinyintT).build();
    }

    /**
     * Create an instance of this class with {@link #tupleT()} initialized to the given value.
     *
     * <p>
     * A fixed-length ordered list of elements, where each element can be of a different data type.
     * </p>
     * 
     * @param tupleT
     *        A fixed-length ordered list of elements, where each element can be of a different data type.
     */
    public static KeyspacesCellValue fromTupleT(List<KeyspacesCell> tupleT) {
        return builder().tupleT(tupleT).build();
    }

    /**
     * Create an instance of this class with {@link #uuidT()} initialized to the given value.
     *
     * <p>
     * A universally unique identifier (UUID) value.
     * </p>
     * 
     * @param uuidT
     *        A universally unique identifier (UUID) value.
     */
    public static KeyspacesCellValue fromUuidT(String uuidT) {
        return builder().uuidT(uuidT).build();
    }

    /**
     * Create an instance of this class with {@link #varcharT()} initialized to the given value.
     *
     * <p>
     * A UTF-8 encoded string value, functionally equivalent to text type.
     * </p>
     * 
     * @param varcharT
     *        A UTF-8 encoded string value, functionally equivalent to text type.
     */
    public static KeyspacesCellValue fromVarcharT(String varcharT) {
        return builder().varcharT(varcharT).build();
    }

    /**
     * Create an instance of this class with {@link #varintT()} initialized to the given value.
     *
     * <p>
     * A variable precision integer value with arbitrary length.
     * </p>
     * 
     * @param varintT
     *        A variable precision integer value with arbitrary length.
     */
    public static KeyspacesCellValue fromVarintT(String varintT) {
        return builder().varintT(varintT).build();
    }

    /**
     * Create an instance of this class with {@link #udtT()} initialized to the given value.
     *
     * <p>
     * A user-defined type (UDT) value consisting of named fields, each with its own data type.
     * </p>
     * 
     * @param udtT
     *        A user-defined type (UDT) value consisting of named fields, each with its own data type.
     */
    public static KeyspacesCellValue fromUdtT(Map<String, KeyspacesCell> udtT) {
        return builder().udtT(udtT).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("asciiT", ASCIIT_FIELD);
        map.put("bigintT", BIGINTT_FIELD);
        map.put("blobT", BLOBT_FIELD);
        map.put("boolT", BOOLT_FIELD);
        map.put("counterT", COUNTERT_FIELD);
        map.put("dateT", DATET_FIELD);
        map.put("decimalT", DECIMALT_FIELD);
        map.put("doubleT", DOUBLET_FIELD);
        map.put("floatT", FLOATT_FIELD);
        map.put("inetT", INETT_FIELD);
        map.put("intT", INTT_FIELD);
        map.put("listT", LISTT_FIELD);
        map.put("mapT", MAPT_FIELD);
        map.put("setT", SETT_FIELD);
        map.put("smallintT", SMALLINTT_FIELD);
        map.put("textT", TEXTT_FIELD);
        map.put("timeT", TIMET_FIELD);
        map.put("timestampT", TIMESTAMPT_FIELD);
        map.put("timeuuidT", TIMEUUIDT_FIELD);
        map.put("tinyintT", TINYINTT_FIELD);
        map.put("tupleT", TUPLET_FIELD);
        map.put("uuidT", UUIDT_FIELD);
        map.put("varcharT", VARCHART_FIELD);
        map.put("varintT", VARINTT_FIELD);
        map.put("udtT", UDTT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeyspacesCellValue, T> g) {
        return obj -> g.apply((KeyspacesCellValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeyspacesCellValue> {
        /**
         * <p>
         * A value of ASCII text type, containing US-ASCII characters.
         * </p>
         * 
         * @param asciiT
         *        A value of ASCII text type, containing US-ASCII characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asciiT(String asciiT);

        /**
         * <p>
         * A 64-bit signed integer value.
         * </p>
         * 
         * @param bigintT
         *        A 64-bit signed integer value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bigintT(String bigintT);

        /**
         * <p>
         * A binary large object (BLOB) value stored as a Base64-encoded string.
         * </p>
         * 
         * @param blobT
         *        A binary large object (BLOB) value stored as a Base64-encoded string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blobT(SdkBytes blobT);

        /**
         * <p>
         * A Boolean value, either <code>true</code> or <code>false</code>.
         * </p>
         * 
         * @param boolT
         *        A Boolean value, either <code>true</code> or <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boolT(Boolean boolT);

        /**
         * <p>
         * A distributed counter value that can be incremented and decremented.
         * </p>
         * 
         * @param counterT
         *        A distributed counter value that can be incremented and decremented.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder counterT(String counterT);

        /**
         * <p>
         * A date value without a time component, represented as days since epoch (January 1, 1970).
         * </p>
         * 
         * @param dateT
         *        A date value without a time component, represented as days since epoch (January 1, 1970).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateT(String dateT);

        /**
         * <p>
         * A variable-precision decimal number value.
         * </p>
         * 
         * @param decimalT
         *        A variable-precision decimal number value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decimalT(String decimalT);

        /**
         * <p>
         * A 64-bit double-precision floating point value.
         * </p>
         * 
         * @param doubleT
         *        A 64-bit double-precision floating point value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleT(String doubleT);

        /**
         * <p>
         * A 32-bit single-precision floating point value.
         * </p>
         * 
         * @param floatT
         *        A 32-bit single-precision floating point value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder floatT(String floatT);

        /**
         * <p>
         * An IP address value, either IPv4 or IPv6 format.
         * </p>
         * 
         * @param inetT
         *        An IP address value, either IPv4 or IPv6 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inetT(String inetT);

        /**
         * <p>
         * A 32-bit signed integer value.
         * </p>
         * 
         * @param intT
         *        A 32-bit signed integer value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intT(String intT);

        /**
         * <p>
         * An ordered collection of elements that can contain duplicate values.
         * </p>
         * 
         * @param listT
         *        An ordered collection of elements that can contain duplicate values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listT(Collection<KeyspacesCell> listT);

        /**
         * <p>
         * An ordered collection of elements that can contain duplicate values.
         * </p>
         * 
         * @param listT
         *        An ordered collection of elements that can contain duplicate values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listT(KeyspacesCell... listT);

        /**
         * <p>
         * An ordered collection of elements that can contain duplicate values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesCell.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesCell#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesCell.Builder#build()} is called
         * immediately and its result is passed to {@link #listT(List<KeyspacesCell>)}.
         * 
         * @param listT
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesCell.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listT(java.util.Collection<KeyspacesCell>)
         */
        Builder listT(Consumer<KeyspacesCell.Builder>... listT);

        /**
         * <p>
         * A collection of key-value pairs where each key is unique.
         * </p>
         * 
         * @param mapT
         *        A collection of key-value pairs where each key is unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapT(Collection<KeyspacesCellMapDefinition> mapT);

        /**
         * <p>
         * A collection of key-value pairs where each key is unique.
         * </p>
         * 
         * @param mapT
         *        A collection of key-value pairs where each key is unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapT(KeyspacesCellMapDefinition... mapT);

        /**
         * <p>
         * A collection of key-value pairs where each key is unique.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesCellMapDefinition.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesCellMapDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesCellMapDefinition.Builder#build()} is
         * called immediately and its result is passed to {@link #mapT(List<KeyspacesCellMapDefinition>)}.
         * 
         * @param mapT
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesCellMapDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mapT(java.util.Collection<KeyspacesCellMapDefinition>)
         */
        Builder mapT(Consumer<KeyspacesCellMapDefinition.Builder>... mapT);

        /**
         * <p>
         * An unordered collection of unique elements.
         * </p>
         * 
         * @param setT
         *        An unordered collection of unique elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setT(Collection<KeyspacesCell> setT);

        /**
         * <p>
         * An unordered collection of unique elements.
         * </p>
         * 
         * @param setT
         *        An unordered collection of unique elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setT(KeyspacesCell... setT);

        /**
         * <p>
         * An unordered collection of unique elements.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesCell.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesCell#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesCell.Builder#build()} is called
         * immediately and its result is passed to {@link #setT(List<KeyspacesCell>)}.
         * 
         * @param setT
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesCell.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #setT(java.util.Collection<KeyspacesCell>)
         */
        Builder setT(Consumer<KeyspacesCell.Builder>... setT);

        /**
         * <p>
         * A 16-bit signed integer value.
         * </p>
         * 
         * @param smallintT
         *        A 16-bit signed integer value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smallintT(String smallintT);

        /**
         * <p>
         * A UTF-8 encoded string value.
         * </p>
         * 
         * @param textT
         *        A UTF-8 encoded string value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textT(String textT);

        /**
         * <p>
         * A time value without a date component, with nanosecond precision.
         * </p>
         * 
         * @param timeT
         *        A time value without a date component, with nanosecond precision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeT(String timeT);

        /**
         * <p>
         * A timestamp value representing date and time with millisecond precision.
         * </p>
         * 
         * @param timestampT
         *        A timestamp value representing date and time with millisecond precision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampT(String timestampT);

        /**
         * <p>
         * A universally unique identifier (UUID) that includes a timestamp component, ensuring both uniqueness and time
         * ordering.
         * </p>
         * 
         * @param timeuuidT
         *        A universally unique identifier (UUID) that includes a timestamp component, ensuring both uniqueness
         *        and time ordering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeuuidT(String timeuuidT);

        /**
         * <p>
         * An 8-bit signed integer value.
         * </p>
         * 
         * @param tinyintT
         *        An 8-bit signed integer value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tinyintT(String tinyintT);

        /**
         * <p>
         * A fixed-length ordered list of elements, where each element can be of a different data type.
         * </p>
         * 
         * @param tupleT
         *        A fixed-length ordered list of elements, where each element can be of a different data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tupleT(Collection<KeyspacesCell> tupleT);

        /**
         * <p>
         * A fixed-length ordered list of elements, where each element can be of a different data type.
         * </p>
         * 
         * @param tupleT
         *        A fixed-length ordered list of elements, where each element can be of a different data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tupleT(KeyspacesCell... tupleT);

        /**
         * <p>
         * A fixed-length ordered list of elements, where each element can be of a different data type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesCell.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesCell#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesCell.Builder#build()} is called
         * immediately and its result is passed to {@link #tupleT(List<KeyspacesCell>)}.
         * 
         * @param tupleT
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesCell.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tupleT(java.util.Collection<KeyspacesCell>)
         */
        Builder tupleT(Consumer<KeyspacesCell.Builder>... tupleT);

        /**
         * <p>
         * A universally unique identifier (UUID) value.
         * </p>
         * 
         * @param uuidT
         *        A universally unique identifier (UUID) value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uuidT(String uuidT);

        /**
         * <p>
         * A UTF-8 encoded string value, functionally equivalent to text type.
         * </p>
         * 
         * @param varcharT
         *        A UTF-8 encoded string value, functionally equivalent to text type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder varcharT(String varcharT);

        /**
         * <p>
         * A variable precision integer value with arbitrary length.
         * </p>
         * 
         * @param varintT
         *        A variable precision integer value with arbitrary length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder varintT(String varintT);

        /**
         * <p>
         * A user-defined type (UDT) value consisting of named fields, each with its own data type.
         * </p>
         * 
         * @param udtT
         *        A user-defined type (UDT) value consisting of named fields, each with its own data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder udtT(Map<String, KeyspacesCell> udtT);
    }

    static final class BuilderImpl implements Builder {
        private String asciiT;

        private String bigintT;

        private SdkBytes blobT;

        private Boolean boolT;

        private String counterT;

        private String dateT;

        private String decimalT;

        private String doubleT;

        private String floatT;

        private String inetT;

        private String intT;

        private List<KeyspacesCell> listT = DefaultSdkAutoConstructList.getInstance();

        private List<KeyspacesCellMapDefinition> mapT = DefaultSdkAutoConstructList.getInstance();

        private List<KeyspacesCell> setT = DefaultSdkAutoConstructList.getInstance();

        private String smallintT;

        private String textT;

        private String timeT;

        private String timestampT;

        private String timeuuidT;

        private String tinyintT;

        private List<KeyspacesCell> tupleT = DefaultSdkAutoConstructList.getInstance();

        private String uuidT;

        private String varcharT;

        private String varintT;

        private Map<String, KeyspacesCell> udtT = DefaultSdkAutoConstructMap.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(KeyspacesCellValue model) {
            asciiT(model.asciiT);
            bigintT(model.bigintT);
            blobT(model.blobT);
            boolT(model.boolT);
            counterT(model.counterT);
            dateT(model.dateT);
            decimalT(model.decimalT);
            doubleT(model.doubleT);
            floatT(model.floatT);
            inetT(model.inetT);
            intT(model.intT);
            listT(model.listT);
            mapT(model.mapT);
            setT(model.setT);
            smallintT(model.smallintT);
            textT(model.textT);
            timeT(model.timeT);
            timestampT(model.timestampT);
            timeuuidT(model.timeuuidT);
            tinyintT(model.tinyintT);
            tupleT(model.tupleT);
            uuidT(model.uuidT);
            varcharT(model.varcharT);
            varintT(model.varintT);
            udtT(model.udtT);
        }

        public final String getAsciiT() {
            return asciiT;
        }

        public final void setAsciiT(String asciiT) {
            Object oldValue = this.asciiT;
            this.asciiT = asciiT;
            handleUnionValueChange(Type.ASCIIT, oldValue, this.asciiT);
        }

        @Override
        public final Builder asciiT(String asciiT) {
            Object oldValue = this.asciiT;
            this.asciiT = asciiT;
            handleUnionValueChange(Type.ASCIIT, oldValue, this.asciiT);
            return this;
        }

        public final String getBigintT() {
            return bigintT;
        }

        public final void setBigintT(String bigintT) {
            Object oldValue = this.bigintT;
            this.bigintT = bigintT;
            handleUnionValueChange(Type.BIGINTT, oldValue, this.bigintT);
        }

        @Override
        public final Builder bigintT(String bigintT) {
            Object oldValue = this.bigintT;
            this.bigintT = bigintT;
            handleUnionValueChange(Type.BIGINTT, oldValue, this.bigintT);
            return this;
        }

        public final ByteBuffer getBlobT() {
            return blobT == null ? null : blobT.asByteBuffer();
        }

        public final void setBlobT(ByteBuffer blobT) {
            blobT(blobT == null ? null : SdkBytes.fromByteBuffer(blobT));
        }

        @Override
        public final Builder blobT(SdkBytes blobT) {
            Object oldValue = this.blobT;
            this.blobT = blobT;
            handleUnionValueChange(Type.BLOBT, oldValue, this.blobT);
            return this;
        }

        public final Boolean getBoolT() {
            return boolT;
        }

        public final void setBoolT(Boolean boolT) {
            Object oldValue = this.boolT;
            this.boolT = boolT;
            handleUnionValueChange(Type.BOOLT, oldValue, this.boolT);
        }

        @Override
        public final Builder boolT(Boolean boolT) {
            Object oldValue = this.boolT;
            this.boolT = boolT;
            handleUnionValueChange(Type.BOOLT, oldValue, this.boolT);
            return this;
        }

        public final String getCounterT() {
            return counterT;
        }

        public final void setCounterT(String counterT) {
            Object oldValue = this.counterT;
            this.counterT = counterT;
            handleUnionValueChange(Type.COUNTERT, oldValue, this.counterT);
        }

        @Override
        public final Builder counterT(String counterT) {
            Object oldValue = this.counterT;
            this.counterT = counterT;
            handleUnionValueChange(Type.COUNTERT, oldValue, this.counterT);
            return this;
        }

        public final String getDateT() {
            return dateT;
        }

        public final void setDateT(String dateT) {
            Object oldValue = this.dateT;
            this.dateT = dateT;
            handleUnionValueChange(Type.DATET, oldValue, this.dateT);
        }

        @Override
        public final Builder dateT(String dateT) {
            Object oldValue = this.dateT;
            this.dateT = dateT;
            handleUnionValueChange(Type.DATET, oldValue, this.dateT);
            return this;
        }

        public final String getDecimalT() {
            return decimalT;
        }

        public final void setDecimalT(String decimalT) {
            Object oldValue = this.decimalT;
            this.decimalT = decimalT;
            handleUnionValueChange(Type.DECIMALT, oldValue, this.decimalT);
        }

        @Override
        public final Builder decimalT(String decimalT) {
            Object oldValue = this.decimalT;
            this.decimalT = decimalT;
            handleUnionValueChange(Type.DECIMALT, oldValue, this.decimalT);
            return this;
        }

        public final String getDoubleT() {
            return doubleT;
        }

        public final void setDoubleT(String doubleT) {
            Object oldValue = this.doubleT;
            this.doubleT = doubleT;
            handleUnionValueChange(Type.DOUBLET, oldValue, this.doubleT);
        }

        @Override
        public final Builder doubleT(String doubleT) {
            Object oldValue = this.doubleT;
            this.doubleT = doubleT;
            handleUnionValueChange(Type.DOUBLET, oldValue, this.doubleT);
            return this;
        }

        public final String getFloatT() {
            return floatT;
        }

        public final void setFloatT(String floatT) {
            Object oldValue = this.floatT;
            this.floatT = floatT;
            handleUnionValueChange(Type.FLOATT, oldValue, this.floatT);
        }

        @Override
        public final Builder floatT(String floatT) {
            Object oldValue = this.floatT;
            this.floatT = floatT;
            handleUnionValueChange(Type.FLOATT, oldValue, this.floatT);
            return this;
        }

        public final String getInetT() {
            return inetT;
        }

        public final void setInetT(String inetT) {
            Object oldValue = this.inetT;
            this.inetT = inetT;
            handleUnionValueChange(Type.INETT, oldValue, this.inetT);
        }

        @Override
        public final Builder inetT(String inetT) {
            Object oldValue = this.inetT;
            this.inetT = inetT;
            handleUnionValueChange(Type.INETT, oldValue, this.inetT);
            return this;
        }

        public final String getIntT() {
            return intT;
        }

        public final void setIntT(String intT) {
            Object oldValue = this.intT;
            this.intT = intT;
            handleUnionValueChange(Type.INTT, oldValue, this.intT);
        }

        @Override
        public final Builder intT(String intT) {
            Object oldValue = this.intT;
            this.intT = intT;
            handleUnionValueChange(Type.INTT, oldValue, this.intT);
            return this;
        }

        public final List<KeyspacesCell.Builder> getListT() {
            List<KeyspacesCell.Builder> result = KeyspacesCellListCopier.copyToBuilder(this.listT);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListT(Collection<KeyspacesCell.BuilderImpl> listT) {
            Object oldValue = this.listT;
            this.listT = KeyspacesCellListCopier.copyFromBuilder(listT);
            handleUnionValueChange(Type.LISTT, oldValue, this.listT);
        }

        @Override
        public final Builder listT(Collection<KeyspacesCell> listT) {
            Object oldValue = this.listT;
            this.listT = KeyspacesCellListCopier.copy(listT);
            handleUnionValueChange(Type.LISTT, oldValue, this.listT);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listT(KeyspacesCell... listT) {
            listT(Arrays.asList(listT));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listT(Consumer<KeyspacesCell.Builder>... listT) {
            listT(Stream.of(listT).map(c -> KeyspacesCell.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<KeyspacesCellMapDefinition.Builder> getMapT() {
            List<KeyspacesCellMapDefinition.Builder> result = KeyspacesCellMapCopier.copyToBuilder(this.mapT);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMapT(Collection<KeyspacesCellMapDefinition.BuilderImpl> mapT) {
            Object oldValue = this.mapT;
            this.mapT = KeyspacesCellMapCopier.copyFromBuilder(mapT);
            handleUnionValueChange(Type.MAPT, oldValue, this.mapT);
        }

        @Override
        public final Builder mapT(Collection<KeyspacesCellMapDefinition> mapT) {
            Object oldValue = this.mapT;
            this.mapT = KeyspacesCellMapCopier.copy(mapT);
            handleUnionValueChange(Type.MAPT, oldValue, this.mapT);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapT(KeyspacesCellMapDefinition... mapT) {
            mapT(Arrays.asList(mapT));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapT(Consumer<KeyspacesCellMapDefinition.Builder>... mapT) {
            mapT(Stream.of(mapT).map(c -> KeyspacesCellMapDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<KeyspacesCell.Builder> getSetT() {
            List<KeyspacesCell.Builder> result = KeyspacesCellListCopier.copyToBuilder(this.setT);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSetT(Collection<KeyspacesCell.BuilderImpl> setT) {
            Object oldValue = this.setT;
            this.setT = KeyspacesCellListCopier.copyFromBuilder(setT);
            handleUnionValueChange(Type.SETT, oldValue, this.setT);
        }

        @Override
        @Transient
        public final Builder setT(Collection<KeyspacesCell> setT) {
            Object oldValue = this.setT;
            this.setT = KeyspacesCellListCopier.copy(setT);
            handleUnionValueChange(Type.SETT, oldValue, this.setT);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder setT(KeyspacesCell... setT) {
            setT(Arrays.asList(setT));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder setT(Consumer<KeyspacesCell.Builder>... setT) {
            setT(Stream.of(setT).map(c -> KeyspacesCell.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSmallintT() {
            return smallintT;
        }

        public final void setSmallintT(String smallintT) {
            Object oldValue = this.smallintT;
            this.smallintT = smallintT;
            handleUnionValueChange(Type.SMALLINTT, oldValue, this.smallintT);
        }

        @Override
        public final Builder smallintT(String smallintT) {
            Object oldValue = this.smallintT;
            this.smallintT = smallintT;
            handleUnionValueChange(Type.SMALLINTT, oldValue, this.smallintT);
            return this;
        }

        public final String getTextT() {
            return textT;
        }

        public final void setTextT(String textT) {
            Object oldValue = this.textT;
            this.textT = textT;
            handleUnionValueChange(Type.TEXTT, oldValue, this.textT);
        }

        @Override
        public final Builder textT(String textT) {
            Object oldValue = this.textT;
            this.textT = textT;
            handleUnionValueChange(Type.TEXTT, oldValue, this.textT);
            return this;
        }

        public final String getTimeT() {
            return timeT;
        }

        public final void setTimeT(String timeT) {
            Object oldValue = this.timeT;
            this.timeT = timeT;
            handleUnionValueChange(Type.TIMET, oldValue, this.timeT);
        }

        @Override
        public final Builder timeT(String timeT) {
            Object oldValue = this.timeT;
            this.timeT = timeT;
            handleUnionValueChange(Type.TIMET, oldValue, this.timeT);
            return this;
        }

        public final String getTimestampT() {
            return timestampT;
        }

        public final void setTimestampT(String timestampT) {
            Object oldValue = this.timestampT;
            this.timestampT = timestampT;
            handleUnionValueChange(Type.TIMESTAMPT, oldValue, this.timestampT);
        }

        @Override
        public final Builder timestampT(String timestampT) {
            Object oldValue = this.timestampT;
            this.timestampT = timestampT;
            handleUnionValueChange(Type.TIMESTAMPT, oldValue, this.timestampT);
            return this;
        }

        public final String getTimeuuidT() {
            return timeuuidT;
        }

        public final void setTimeuuidT(String timeuuidT) {
            Object oldValue = this.timeuuidT;
            this.timeuuidT = timeuuidT;
            handleUnionValueChange(Type.TIMEUUIDT, oldValue, this.timeuuidT);
        }

        @Override
        public final Builder timeuuidT(String timeuuidT) {
            Object oldValue = this.timeuuidT;
            this.timeuuidT = timeuuidT;
            handleUnionValueChange(Type.TIMEUUIDT, oldValue, this.timeuuidT);
            return this;
        }

        public final String getTinyintT() {
            return tinyintT;
        }

        public final void setTinyintT(String tinyintT) {
            Object oldValue = this.tinyintT;
            this.tinyintT = tinyintT;
            handleUnionValueChange(Type.TINYINTT, oldValue, this.tinyintT);
        }

        @Override
        public final Builder tinyintT(String tinyintT) {
            Object oldValue = this.tinyintT;
            this.tinyintT = tinyintT;
            handleUnionValueChange(Type.TINYINTT, oldValue, this.tinyintT);
            return this;
        }

        public final List<KeyspacesCell.Builder> getTupleT() {
            List<KeyspacesCell.Builder> result = KeyspacesCellListCopier.copyToBuilder(this.tupleT);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTupleT(Collection<KeyspacesCell.BuilderImpl> tupleT) {
            Object oldValue = this.tupleT;
            this.tupleT = KeyspacesCellListCopier.copyFromBuilder(tupleT);
            handleUnionValueChange(Type.TUPLET, oldValue, this.tupleT);
        }

        @Override
        public final Builder tupleT(Collection<KeyspacesCell> tupleT) {
            Object oldValue = this.tupleT;
            this.tupleT = KeyspacesCellListCopier.copy(tupleT);
            handleUnionValueChange(Type.TUPLET, oldValue, this.tupleT);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tupleT(KeyspacesCell... tupleT) {
            tupleT(Arrays.asList(tupleT));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tupleT(Consumer<KeyspacesCell.Builder>... tupleT) {
            tupleT(Stream.of(tupleT).map(c -> KeyspacesCell.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUuidT() {
            return uuidT;
        }

        public final void setUuidT(String uuidT) {
            Object oldValue = this.uuidT;
            this.uuidT = uuidT;
            handleUnionValueChange(Type.UUIDT, oldValue, this.uuidT);
        }

        @Override
        public final Builder uuidT(String uuidT) {
            Object oldValue = this.uuidT;
            this.uuidT = uuidT;
            handleUnionValueChange(Type.UUIDT, oldValue, this.uuidT);
            return this;
        }

        public final String getVarcharT() {
            return varcharT;
        }

        public final void setVarcharT(String varcharT) {
            Object oldValue = this.varcharT;
            this.varcharT = varcharT;
            handleUnionValueChange(Type.VARCHART, oldValue, this.varcharT);
        }

        @Override
        public final Builder varcharT(String varcharT) {
            Object oldValue = this.varcharT;
            this.varcharT = varcharT;
            handleUnionValueChange(Type.VARCHART, oldValue, this.varcharT);
            return this;
        }

        public final String getVarintT() {
            return varintT;
        }

        public final void setVarintT(String varintT) {
            Object oldValue = this.varintT;
            this.varintT = varintT;
            handleUnionValueChange(Type.VARINTT, oldValue, this.varintT);
        }

        @Override
        public final Builder varintT(String varintT) {
            Object oldValue = this.varintT;
            this.varintT = varintT;
            handleUnionValueChange(Type.VARINTT, oldValue, this.varintT);
            return this;
        }

        public final Map<String, KeyspacesCell.Builder> getUdtT() {
            Map<String, KeyspacesCell.Builder> result = KeyspacesUdtMapCopier.copyToBuilder(this.udtT);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setUdtT(Map<String, KeyspacesCell.BuilderImpl> udtT) {
            Object oldValue = this.udtT;
            this.udtT = KeyspacesUdtMapCopier.copyFromBuilder(udtT);
            handleUnionValueChange(Type.UDTT, oldValue, this.udtT);
        }

        @Override
        public final Builder udtT(Map<String, KeyspacesCell> udtT) {
            Object oldValue = this.udtT;
            this.udtT = KeyspacesUdtMapCopier.copy(udtT);
            handleUnionValueChange(Type.UDTT, oldValue, this.udtT);
            return this;
        }

        @Override
        public KeyspacesCellValue build() {
            return new KeyspacesCellValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see KeyspacesCellValue#type()
     */
    public enum Type {
        ASCIIT,

        BIGINTT,

        BLOBT,

        BOOLT,

        COUNTERT,

        DATET,

        DECIMALT,

        DOUBLET,

        FLOATT,

        INETT,

        INTT,

        LISTT,

        MAPT,

        SETT,

        SMALLINTT,

        TEXTT,

        TIMET,

        TIMESTAMPT,

        TIMEUUIDT,

        TINYINTT,

        TUPLET,

        UUIDT,

        VARCHART,

        VARINTT,

        UDTT,

        UNKNOWN_TO_SDK_VERSION
    }
}
