/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.firehose.transform.DeliveryStreamDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a delivery stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeliveryStreamDescription implements StructuredPojo,
        ToCopyableBuilder<DeliveryStreamDescription.Builder, DeliveryStreamDescription> {
    private final String deliveryStreamName;

    private final String deliveryStreamARN;

    private final String deliveryStreamStatus;

    private final String versionId;

    private final Date createTimestamp;

    private final Date lastUpdateTimestamp;

    private final List<DestinationDescription> destinations;

    private final Boolean hasMoreDestinations;

    private DeliveryStreamDescription(BuilderImpl builder) {
        this.deliveryStreamName = builder.deliveryStreamName;
        this.deliveryStreamARN = builder.deliveryStreamARN;
        this.deliveryStreamStatus = builder.deliveryStreamStatus;
        this.versionId = builder.versionId;
        this.createTimestamp = builder.createTimestamp;
        this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
        this.destinations = builder.destinations;
        this.hasMoreDestinations = builder.hasMoreDestinations;
    }

    /**
     * <p>
     * The name of the delivery stream.
     * </p>
     * 
     * @return The name of the delivery stream.
     */
    public String deliveryStreamName() {
        return deliveryStreamName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the delivery stream.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the delivery stream.
     */
    public String deliveryStreamARN() {
        return deliveryStreamARN;
    }

    /**
     * <p>
     * The status of the delivery stream.
     * </p>
     * 
     * @return The status of the delivery stream.
     * @see DeliveryStreamStatus
     */
    public String deliveryStreamStatus() {
        return deliveryStreamStatus;
    }

    /**
     * <p>
     * Each time the destination is updated for a delivery stream, the version ID is changed, and the current version ID
     * is required when updating the destination. This is so that the service knows it is applying the changes to the
     * correct version of the delivery stream.
     * </p>
     * 
     * @return Each time the destination is updated for a delivery stream, the version ID is changed, and the current
     *         version ID is required when updating the destination. This is so that the service knows it is applying
     *         the changes to the correct version of the delivery stream.
     */
    public String versionId() {
        return versionId;
    }

    /**
     * <p>
     * The date and time that the delivery stream was created.
     * </p>
     * 
     * @return The date and time that the delivery stream was created.
     */
    public Date createTimestamp() {
        return createTimestamp;
    }

    /**
     * <p>
     * The date and time that the delivery stream was last updated.
     * </p>
     * 
     * @return The date and time that the delivery stream was last updated.
     */
    public Date lastUpdateTimestamp() {
        return lastUpdateTimestamp;
    }

    /**
     * <p>
     * The destinations.
     * </p>
     * 
     * @return The destinations.
     */
    public List<DestinationDescription> destinations() {
        return destinations;
    }

    /**
     * <p>
     * Indicates whether there are more destinations available to list.
     * </p>
     * 
     * @return Indicates whether there are more destinations available to list.
     */
    public Boolean hasMoreDestinations() {
        return hasMoreDestinations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deliveryStreamName() == null) ? 0 : deliveryStreamName().hashCode());
        hashCode = 31 * hashCode + ((deliveryStreamARN() == null) ? 0 : deliveryStreamARN().hashCode());
        hashCode = 31 * hashCode + ((deliveryStreamStatus() == null) ? 0 : deliveryStreamStatus().hashCode());
        hashCode = 31 * hashCode + ((versionId() == null) ? 0 : versionId().hashCode());
        hashCode = 31 * hashCode + ((createTimestamp() == null) ? 0 : createTimestamp().hashCode());
        hashCode = 31 * hashCode + ((lastUpdateTimestamp() == null) ? 0 : lastUpdateTimestamp().hashCode());
        hashCode = 31 * hashCode + ((destinations() == null) ? 0 : destinations().hashCode());
        hashCode = 31 * hashCode + ((hasMoreDestinations() == null) ? 0 : hasMoreDestinations().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliveryStreamDescription)) {
            return false;
        }
        DeliveryStreamDescription other = (DeliveryStreamDescription) obj;
        if (other.deliveryStreamName() == null ^ this.deliveryStreamName() == null) {
            return false;
        }
        if (other.deliveryStreamName() != null && !other.deliveryStreamName().equals(this.deliveryStreamName())) {
            return false;
        }
        if (other.deliveryStreamARN() == null ^ this.deliveryStreamARN() == null) {
            return false;
        }
        if (other.deliveryStreamARN() != null && !other.deliveryStreamARN().equals(this.deliveryStreamARN())) {
            return false;
        }
        if (other.deliveryStreamStatus() == null ^ this.deliveryStreamStatus() == null) {
            return false;
        }
        if (other.deliveryStreamStatus() != null && !other.deliveryStreamStatus().equals(this.deliveryStreamStatus())) {
            return false;
        }
        if (other.versionId() == null ^ this.versionId() == null) {
            return false;
        }
        if (other.versionId() != null && !other.versionId().equals(this.versionId())) {
            return false;
        }
        if (other.createTimestamp() == null ^ this.createTimestamp() == null) {
            return false;
        }
        if (other.createTimestamp() != null && !other.createTimestamp().equals(this.createTimestamp())) {
            return false;
        }
        if (other.lastUpdateTimestamp() == null ^ this.lastUpdateTimestamp() == null) {
            return false;
        }
        if (other.lastUpdateTimestamp() != null && !other.lastUpdateTimestamp().equals(this.lastUpdateTimestamp())) {
            return false;
        }
        if (other.destinations() == null ^ this.destinations() == null) {
            return false;
        }
        if (other.destinations() != null && !other.destinations().equals(this.destinations())) {
            return false;
        }
        if (other.hasMoreDestinations() == null ^ this.hasMoreDestinations() == null) {
            return false;
        }
        if (other.hasMoreDestinations() != null && !other.hasMoreDestinations().equals(this.hasMoreDestinations())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deliveryStreamName() != null) {
            sb.append("DeliveryStreamName: ").append(deliveryStreamName()).append(",");
        }
        if (deliveryStreamARN() != null) {
            sb.append("DeliveryStreamARN: ").append(deliveryStreamARN()).append(",");
        }
        if (deliveryStreamStatus() != null) {
            sb.append("DeliveryStreamStatus: ").append(deliveryStreamStatus()).append(",");
        }
        if (versionId() != null) {
            sb.append("VersionId: ").append(versionId()).append(",");
        }
        if (createTimestamp() != null) {
            sb.append("CreateTimestamp: ").append(createTimestamp()).append(",");
        }
        if (lastUpdateTimestamp() != null) {
            sb.append("LastUpdateTimestamp: ").append(lastUpdateTimestamp()).append(",");
        }
        if (destinations() != null) {
            sb.append("Destinations: ").append(destinations()).append(",");
        }
        if (hasMoreDestinations() != null) {
            sb.append("HasMoreDestinations: ").append(hasMoreDestinations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeliveryStreamDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DeliveryStreamDescription> {
        /**
         * <p>
         * The name of the delivery stream.
         * </p>
         * 
         * @param deliveryStreamName
         *        The name of the delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamName(String deliveryStreamName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the delivery stream.
         * </p>
         * 
         * @param deliveryStreamARN
         *        The Amazon Resource Name (ARN) of the delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamARN(String deliveryStreamARN);

        /**
         * <p>
         * The status of the delivery stream.
         * </p>
         * 
         * @param deliveryStreamStatus
         *        The status of the delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryStreamStatus
         */
        Builder deliveryStreamStatus(String deliveryStreamStatus);

        /**
         * <p>
         * The status of the delivery stream.
         * </p>
         * 
         * @param deliveryStreamStatus
         *        The status of the delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryStreamStatus
         */
        Builder deliveryStreamStatus(DeliveryStreamStatus deliveryStreamStatus);

        /**
         * <p>
         * Each time the destination is updated for a delivery stream, the version ID is changed, and the current
         * version ID is required when updating the destination. This is so that the service knows it is applying the
         * changes to the correct version of the delivery stream.
         * </p>
         * 
         * @param versionId
         *        Each time the destination is updated for a delivery stream, the version ID is changed, and the current
         *        version ID is required when updating the destination. This is so that the service knows it is applying
         *        the changes to the correct version of the delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * The date and time that the delivery stream was created.
         * </p>
         * 
         * @param createTimestamp
         *        The date and time that the delivery stream was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTimestamp(Date createTimestamp);

        /**
         * <p>
         * The date and time that the delivery stream was last updated.
         * </p>
         * 
         * @param lastUpdateTimestamp
         *        The date and time that the delivery stream was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTimestamp(Date lastUpdateTimestamp);

        /**
         * <p>
         * The destinations.
         * </p>
         * 
         * @param destinations
         *        The destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<DestinationDescription> destinations);

        /**
         * <p>
         * The destinations.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setDestinations(java.util.Collection)} or {@link #withDestinations(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param destinations
         *        The destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(DestinationDescription... destinations);

        /**
         * <p>
         * Indicates whether there are more destinations available to list.
         * </p>
         * 
         * @param hasMoreDestinations
         *        Indicates whether there are more destinations available to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasMoreDestinations(Boolean hasMoreDestinations);
    }

    private static final class BuilderImpl implements Builder {
        private String deliveryStreamName;

        private String deliveryStreamARN;

        private String deliveryStreamStatus;

        private String versionId;

        private Date createTimestamp;

        private Date lastUpdateTimestamp;

        private List<DestinationDescription> destinations;

        private Boolean hasMoreDestinations;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliveryStreamDescription model) {
            setDeliveryStreamName(model.deliveryStreamName);
            setDeliveryStreamARN(model.deliveryStreamARN);
            setDeliveryStreamStatus(model.deliveryStreamStatus);
            setVersionId(model.versionId);
            setCreateTimestamp(model.createTimestamp);
            setLastUpdateTimestamp(model.lastUpdateTimestamp);
            setDestinations(model.destinations);
            setHasMoreDestinations(model.hasMoreDestinations);
        }

        public final String getDeliveryStreamName() {
            return deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final String getDeliveryStreamARN() {
            return deliveryStreamARN;
        }

        @Override
        public final Builder deliveryStreamARN(String deliveryStreamARN) {
            this.deliveryStreamARN = deliveryStreamARN;
            return this;
        }

        public final void setDeliveryStreamARN(String deliveryStreamARN) {
            this.deliveryStreamARN = deliveryStreamARN;
        }

        public final String getDeliveryStreamStatus() {
            return deliveryStreamStatus;
        }

        @Override
        public final Builder deliveryStreamStatus(String deliveryStreamStatus) {
            this.deliveryStreamStatus = deliveryStreamStatus;
            return this;
        }

        @Override
        public final Builder deliveryStreamStatus(DeliveryStreamStatus deliveryStreamStatus) {
            this.deliveryStreamStatus(deliveryStreamStatus.toString());
            return this;
        }

        public final void setDeliveryStreamStatus(String deliveryStreamStatus) {
            this.deliveryStreamStatus = deliveryStreamStatus;
        }

        public final void setDeliveryStreamStatus(DeliveryStreamStatus deliveryStreamStatus) {
            this.deliveryStreamStatus(deliveryStreamStatus.toString());
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Date getCreateTimestamp() {
            return createTimestamp;
        }

        @Override
        public final Builder createTimestamp(Date createTimestamp) {
            this.createTimestamp = StandardMemberCopier.copy(createTimestamp);
            return this;
        }

        public final void setCreateTimestamp(Date createTimestamp) {
            this.createTimestamp = StandardMemberCopier.copy(createTimestamp);
        }

        public final Date getLastUpdateTimestamp() {
            return lastUpdateTimestamp;
        }

        @Override
        public final Builder lastUpdateTimestamp(Date lastUpdateTimestamp) {
            this.lastUpdateTimestamp = StandardMemberCopier.copy(lastUpdateTimestamp);
            return this;
        }

        public final void setLastUpdateTimestamp(Date lastUpdateTimestamp) {
            this.lastUpdateTimestamp = StandardMemberCopier.copy(lastUpdateTimestamp);
        }

        public final Collection<DestinationDescription> getDestinations() {
            return destinations;
        }

        @Override
        public final Builder destinations(Collection<DestinationDescription> destinations) {
            this.destinations = DestinationDescriptionListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(DestinationDescription... destinations) {
            if (this.destinations == null) {
                this.destinations = new ArrayList<>(destinations.length);
            }
            for (DestinationDescription e : destinations) {
                this.destinations.add(e);
            }
            return this;
        }

        public final void setDestinations(Collection<DestinationDescription> destinations) {
            this.destinations = DestinationDescriptionListCopier.copy(destinations);
        }

        @SafeVarargs
        public final void setDestinations(DestinationDescription... destinations) {
            if (this.destinations == null) {
                this.destinations = new ArrayList<>(destinations.length);
            }
            for (DestinationDescription e : destinations) {
                this.destinations.add(e);
            }
        }

        public final Boolean getHasMoreDestinations() {
            return hasMoreDestinations;
        }

        @Override
        public final Builder hasMoreDestinations(Boolean hasMoreDestinations) {
            this.hasMoreDestinations = hasMoreDestinations;
            return this;
        }

        public final void setHasMoreDestinations(Boolean hasMoreDestinations) {
            this.hasMoreDestinations = hasMoreDestinations;
        }

        @Override
        public DeliveryStreamDescription build() {
            return new DeliveryStreamDescription(this);
        }
    }
}
