/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.KMSEncryptionConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an encryption key for a destination in Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class KMSEncryptionConfig implements StructuredPojo, ToCopyableBuilder<KMSEncryptionConfig.Builder, KMSEncryptionConfig> {
    private final String awskmsKeyARN;

    private KMSEncryptionConfig(BuilderImpl builder) {
        this.awskmsKeyARN = builder.awskmsKeyARN;
    }

    /**
     * <p>
     * The ARN of the encryption key. Must belong to the same region as the destination Amazon S3 bucket.
     * </p>
     * 
     * @return The ARN of the encryption key. Must belong to the same region as the destination Amazon S3 bucket.
     */
    public String awskmsKeyARN() {
        return awskmsKeyARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((awskmsKeyARN() == null) ? 0 : awskmsKeyARN().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KMSEncryptionConfig)) {
            return false;
        }
        KMSEncryptionConfig other = (KMSEncryptionConfig) obj;
        if (other.awskmsKeyARN() == null ^ this.awskmsKeyARN() == null) {
            return false;
        }
        if (other.awskmsKeyARN() != null && !other.awskmsKeyARN().equals(this.awskmsKeyARN())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (awskmsKeyARN() != null) {
            sb.append("AWSKMSKeyARN: ").append(awskmsKeyARN()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KMSEncryptionConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, KMSEncryptionConfig> {
        /**
         * <p>
         * The ARN of the encryption key. Must belong to the same region as the destination Amazon S3 bucket.
         * </p>
         * 
         * @param awskmsKeyARN
         *        The ARN of the encryption key. Must belong to the same region as the destination Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awskmsKeyARN(String awskmsKeyARN);
    }

    private static final class BuilderImpl implements Builder {
        private String awskmsKeyARN;

        private BuilderImpl() {
        }

        private BuilderImpl(KMSEncryptionConfig model) {
            setAWSKMSKeyARN(model.awskmsKeyARN);
        }

        public final String getAWSKMSKeyARN() {
            return awskmsKeyARN;
        }

        @Override
        public final Builder awskmsKeyARN(String awskmsKeyARN) {
            this.awskmsKeyARN = awskmsKeyARN;
            return this;
        }

        public final void setAWSKMSKeyARN(String awskmsKeyARN) {
            this.awskmsKeyARN = awskmsKeyARN;
        }

        @Override
        public KMSEncryptionConfig build() {
            return new KMSEncryptionConfig(this);
        }
    }
}
