/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.ProcessorParameterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the processor parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ProcessorParameter implements StructuredPojo, ToCopyableBuilder<ProcessorParameter.Builder, ProcessorParameter> {
    private final String parameterName;

    private final String parameterValue;

    private ProcessorParameter(BuilderImpl builder) {
        this.parameterName = builder.parameterName;
        this.parameterValue = builder.parameterValue;
    }

    /**
     * <p>
     * The name of the parameter.
     * </p>
     * 
     * @return The name of the parameter.
     * @see ProcessorParameterName
     */
    public String parameterName() {
        return parameterName;
    }

    /**
     * <p>
     * The parameter value.
     * </p>
     * 
     * @return The parameter value.
     */
    public String parameterValue() {
        return parameterValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((parameterName() == null) ? 0 : parameterName().hashCode());
        hashCode = 31 * hashCode + ((parameterValue() == null) ? 0 : parameterValue().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessorParameter)) {
            return false;
        }
        ProcessorParameter other = (ProcessorParameter) obj;
        if (other.parameterName() == null ^ this.parameterName() == null) {
            return false;
        }
        if (other.parameterName() != null && !other.parameterName().equals(this.parameterName())) {
            return false;
        }
        if (other.parameterValue() == null ^ this.parameterValue() == null) {
            return false;
        }
        if (other.parameterValue() != null && !other.parameterValue().equals(this.parameterValue())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (parameterName() != null) {
            sb.append("ParameterName: ").append(parameterName()).append(",");
        }
        if (parameterValue() != null) {
            sb.append("ParameterValue: ").append(parameterValue()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProcessorParameterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ProcessorParameter> {
        /**
         * <p>
         * The name of the parameter.
         * </p>
         * 
         * @param parameterName
         *        The name of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessorParameterName
         */
        Builder parameterName(String parameterName);

        /**
         * <p>
         * The name of the parameter.
         * </p>
         * 
         * @param parameterName
         *        The name of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessorParameterName
         */
        Builder parameterName(ProcessorParameterName parameterName);

        /**
         * <p>
         * The parameter value.
         * </p>
         * 
         * @param parameterValue
         *        The parameter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterValue(String parameterValue);
    }

    private static final class BuilderImpl implements Builder {
        private String parameterName;

        private String parameterValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessorParameter model) {
            setParameterName(model.parameterName);
            setParameterValue(model.parameterValue);
        }

        public final String getParameterName() {
            return parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        @Override
        public final Builder parameterName(ProcessorParameterName parameterName) {
            this.parameterName(parameterName.toString());
            return this;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public final void setParameterName(ProcessorParameterName parameterName) {
            this.parameterName(parameterName.toString());
        }

        public final String getParameterValue() {
            return parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        @Override
        public ProcessorParameter build() {
            return new ProcessorParameter(this);
        }
    }
}
