/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutRecordBatchRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutRecordBatchRequest.Builder, PutRecordBatchRequest> {
    private final String deliveryStreamName;

    private final List<Record> records;

    private PutRecordBatchRequest(BuilderImpl builder) {
        this.deliveryStreamName = builder.deliveryStreamName;
        this.records = builder.records;
    }

    /**
     * <p>
     * The name of the delivery stream.
     * </p>
     * 
     * @return The name of the delivery stream.
     */
    public String deliveryStreamName() {
        return deliveryStreamName;
    }

    /**
     * <p>
     * One or more records.
     * </p>
     * 
     * @return One or more records.
     */
    public List<Record> records() {
        return records;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deliveryStreamName() == null) ? 0 : deliveryStreamName().hashCode());
        hashCode = 31 * hashCode + ((records() == null) ? 0 : records().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordBatchRequest)) {
            return false;
        }
        PutRecordBatchRequest other = (PutRecordBatchRequest) obj;
        if (other.deliveryStreamName() == null ^ this.deliveryStreamName() == null) {
            return false;
        }
        if (other.deliveryStreamName() != null && !other.deliveryStreamName().equals(this.deliveryStreamName())) {
            return false;
        }
        if (other.records() == null ^ this.records() == null) {
            return false;
        }
        if (other.records() != null && !other.records().equals(this.records())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deliveryStreamName() != null) {
            sb.append("DeliveryStreamName: ").append(deliveryStreamName()).append(",");
        }
        if (records() != null) {
            sb.append("Records: ").append(records()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutRecordBatchRequest> {
        /**
         * <p>
         * The name of the delivery stream.
         * </p>
         * 
         * @param deliveryStreamName
         *        The name of the delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamName(String deliveryStreamName);

        /**
         * <p>
         * One or more records.
         * </p>
         * 
         * @param records
         *        One or more records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<Record> records);

        /**
         * <p>
         * One or more records.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setRecords(java.util.Collection)} or {@link #withRecords(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param records
         *        One or more records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Record... records);
    }

    private static final class BuilderImpl implements Builder {
        private String deliveryStreamName;

        private List<Record> records;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordBatchRequest model) {
            setDeliveryStreamName(model.deliveryStreamName);
            setRecords(model.records);
        }

        public final String getDeliveryStreamName() {
            return deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final Collection<Record> getRecords() {
            return records;
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = PutRecordBatchRequestEntryListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record... records) {
            if (this.records == null) {
                this.records = new ArrayList<>(records.length);
            }
            for (Record e : records) {
                this.records.add(e);
            }
            return this;
        }

        public final void setRecords(Collection<Record> records) {
            this.records = PutRecordBatchRequestEntryListCopier.copy(records);
        }

        @SafeVarargs
        public final void setRecords(Record... records) {
            if (this.records == null) {
                this.records = new ArrayList<>(records.length);
            }
            for (Record e : records) {
                this.records.add(e);
            }
        }

        @Override
        public PutRecordBatchRequest build() {
            return new PutRecordBatchRequest(this);
        }
    }
}
