/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutRecordRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutRecordRequest.Builder, PutRecordRequest> {
    private final String deliveryStreamName;

    private final Record record;

    private PutRecordRequest(BuilderImpl builder) {
        this.deliveryStreamName = builder.deliveryStreamName;
        this.record = builder.record;
    }

    /**
     * <p>
     * The name of the delivery stream.
     * </p>
     * 
     * @return The name of the delivery stream.
     */
    public String deliveryStreamName() {
        return deliveryStreamName;
    }

    /**
     * <p>
     * The record.
     * </p>
     * 
     * @return The record.
     */
    public Record record() {
        return record;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deliveryStreamName() == null) ? 0 : deliveryStreamName().hashCode());
        hashCode = 31 * hashCode + ((record() == null) ? 0 : record().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordRequest)) {
            return false;
        }
        PutRecordRequest other = (PutRecordRequest) obj;
        if (other.deliveryStreamName() == null ^ this.deliveryStreamName() == null) {
            return false;
        }
        if (other.deliveryStreamName() != null && !other.deliveryStreamName().equals(this.deliveryStreamName())) {
            return false;
        }
        if (other.record() == null ^ this.record() == null) {
            return false;
        }
        if (other.record() != null && !other.record().equals(this.record())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deliveryStreamName() != null) {
            sb.append("DeliveryStreamName: ").append(deliveryStreamName()).append(",");
        }
        if (record() != null) {
            sb.append("Record: ").append(record()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutRecordRequest> {
        /**
         * <p>
         * The name of the delivery stream.
         * </p>
         * 
         * @param deliveryStreamName
         *        The name of the delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamName(String deliveryStreamName);

        /**
         * <p>
         * The record.
         * </p>
         * 
         * @param record
         *        The record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder record(Record record);
    }

    private static final class BuilderImpl implements Builder {
        private String deliveryStreamName;

        private Record record;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordRequest model) {
            setDeliveryStreamName(model.deliveryStreamName);
            setRecord(model.record);
        }

        public final String getDeliveryStreamName() {
            return deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final Record getRecord() {
            return record;
        }

        @Override
        public final Builder record(Record record) {
            this.record = record;
            return this;
        }

        public final void setRecord(Record record) {
            this.record = record;
        }

        @Override
        public PutRecordRequest build() {
            return new PutRecordRequest(this);
        }
    }
}
