/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.nio.ByteBuffer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.firehose.transform.RecordMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The unit of data in a delivery stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Record implements StructuredPojo, ToCopyableBuilder<Record.Builder, Record> {
    private final ByteBuffer data;

    private Record(BuilderImpl builder) {
        this.data = builder.data;
    }

    /**
     * <p>
     * The data blob, which is base64-encoded when the blob is serialized. The maximum size of the data blob, before
     * base64-encoding, is 1,000 KB.
     * </p>
     * <p>
     * {@code ByteBuffer}s are stateful. Calling their {@code get} methods changes their {@code position}. We recommend
     * using {@link java.nio.ByteBuffer#asReadOnlyBuffer()} to create a read-only view of the buffer with an independent
     * {@code position}, and calling {@code get} methods on this rather than directly on the returned {@code ByteBuffer}
     * . Doing so will ensure that anyone else using the {@code ByteBuffer} will not be affected by changes to the
     * {@code position}.
     * </p>
     * 
     * @return The data blob, which is base64-encoded when the blob is serialized. The maximum size of the data blob,
     *         before base64-encoding, is 1,000 KB.
     */
    public ByteBuffer data() {
        return data;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((data() == null) ? 0 : data().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record other = (Record) obj;
        if (other.data() == null ^ this.data() == null) {
            return false;
        }
        if (other.data() != null && !other.data().equals(this.data())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (data() != null) {
            sb.append("Data: ").append(data()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Record> {
        /**
         * <p>
         * The data blob, which is base64-encoded when the blob is serialized. The maximum size of the data blob, before
         * base64-encoding, is 1,000 KB.
         * </p>
         * 
         * @param data
         *        The data blob, which is base64-encoded when the blob is serialized. The maximum size of the data blob,
         *        before base64-encoding, is 1,000 KB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(ByteBuffer data);
    }

    private static final class BuilderImpl implements Builder {
        private ByteBuffer data;

        private BuilderImpl() {
        }

        private BuilderImpl(Record model) {
            setData(model.data);
        }

        public final ByteBuffer getData() {
            return data;
        }

        @Override
        public final Builder data(ByteBuffer data) {
            this.data = StandardMemberCopier.copy(data);
            return this;
        }

        public final void setData(ByteBuffer data) {
            this.data = StandardMemberCopier.copy(data);
        }

        @Override
        public Record build() {
            return new Record(this);
        }
    }
}
