/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.firehose.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ExtendedS3DestinationConfiguration JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ExtendedS3DestinationConfigurationUnmarshaller implements
        Unmarshaller<ExtendedS3DestinationConfiguration, JsonUnmarshallerContext> {

    public ExtendedS3DestinationConfiguration unmarshall(JsonUnmarshallerContext context) throws Exception {
        ExtendedS3DestinationConfiguration.Builder extendedS3DestinationConfigurationBuilder = ExtendedS3DestinationConfiguration
                .builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("RoleARN", targetDepth)) {
                    context.nextToken();
                    extendedS3DestinationConfigurationBuilder.roleARN(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("BucketARN", targetDepth)) {
                    context.nextToken();
                    extendedS3DestinationConfigurationBuilder
                            .bucketARN(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Prefix", targetDepth)) {
                    context.nextToken();
                    extendedS3DestinationConfigurationBuilder.prefix(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("BufferingHints", targetDepth)) {
                    context.nextToken();
                    extendedS3DestinationConfigurationBuilder.bufferingHints(BufferingHintsUnmarshaller.getInstance().unmarshall(
                            context));
                }
                if (context.testExpression("CompressionFormat", targetDepth)) {
                    context.nextToken();
                    extendedS3DestinationConfigurationBuilder.compressionFormat(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("EncryptionConfiguration", targetDepth)) {
                    context.nextToken();
                    extendedS3DestinationConfigurationBuilder.encryptionConfiguration(EncryptionConfigurationUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("CloudWatchLoggingOptions", targetDepth)) {
                    context.nextToken();
                    extendedS3DestinationConfigurationBuilder.cloudWatchLoggingOptions(CloudWatchLoggingOptionsUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("ProcessingConfiguration", targetDepth)) {
                    context.nextToken();
                    extendedS3DestinationConfigurationBuilder.processingConfiguration(ProcessingConfigurationUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("S3BackupMode", targetDepth)) {
                    context.nextToken();
                    extendedS3DestinationConfigurationBuilder.s3BackupMode(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("S3BackupConfiguration", targetDepth)) {
                    context.nextToken();
                    extendedS3DestinationConfigurationBuilder.s3BackupConfiguration(S3DestinationConfigurationUnmarshaller
                            .getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return extendedS3DestinationConfigurationBuilder.build();
    }

    private static ExtendedS3DestinationConfigurationUnmarshaller INSTANCE;

    public static ExtendedS3DestinationConfigurationUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new ExtendedS3DestinationConfigurationUnmarshaller();
        return INSTANCE;
    }
}