/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesis.transform.HashKeyRangeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The range of possible hash key values for the shard, which is a set of ordered contiguous positive integers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class HashKeyRange implements StructuredPojo, ToCopyableBuilder<HashKeyRange.Builder, HashKeyRange> {
    private final String startingHashKey;

    private final String endingHashKey;

    private HashKeyRange(BuilderImpl builder) {
        this.startingHashKey = builder.startingHashKey;
        this.endingHashKey = builder.endingHashKey;
    }

    /**
     * <p>
     * The starting hash key of the hash key range.
     * </p>
     * 
     * @return The starting hash key of the hash key range.
     */
    public String startingHashKey() {
        return startingHashKey;
    }

    /**
     * <p>
     * The ending hash key of the hash key range.
     * </p>
     * 
     * @return The ending hash key of the hash key range.
     */
    public String endingHashKey() {
        return endingHashKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((startingHashKey() == null) ? 0 : startingHashKey().hashCode());
        hashCode = 31 * hashCode + ((endingHashKey() == null) ? 0 : endingHashKey().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HashKeyRange)) {
            return false;
        }
        HashKeyRange other = (HashKeyRange) obj;
        if (other.startingHashKey() == null ^ this.startingHashKey() == null) {
            return false;
        }
        if (other.startingHashKey() != null && !other.startingHashKey().equals(this.startingHashKey())) {
            return false;
        }
        if (other.endingHashKey() == null ^ this.endingHashKey() == null) {
            return false;
        }
        if (other.endingHashKey() != null && !other.endingHashKey().equals(this.endingHashKey())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (startingHashKey() != null) {
            sb.append("StartingHashKey: ").append(startingHashKey()).append(",");
        }
        if (endingHashKey() != null) {
            sb.append("EndingHashKey: ").append(endingHashKey()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HashKeyRangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, HashKeyRange> {
        /**
         * <p>
         * The starting hash key of the hash key range.
         * </p>
         * 
         * @param startingHashKey
         *        The starting hash key of the hash key range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingHashKey(String startingHashKey);

        /**
         * <p>
         * The ending hash key of the hash key range.
         * </p>
         * 
         * @param endingHashKey
         *        The ending hash key of the hash key range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endingHashKey(String endingHashKey);
    }

    private static final class BuilderImpl implements Builder {
        private String startingHashKey;

        private String endingHashKey;

        private BuilderImpl() {
        }

        private BuilderImpl(HashKeyRange model) {
            setStartingHashKey(model.startingHashKey);
            setEndingHashKey(model.endingHashKey);
        }

        public final String getStartingHashKey() {
            return startingHashKey;
        }

        @Override
        public final Builder startingHashKey(String startingHashKey) {
            this.startingHashKey = startingHashKey;
            return this;
        }

        public final void setStartingHashKey(String startingHashKey) {
            this.startingHashKey = startingHashKey;
        }

        public final String getEndingHashKey() {
            return endingHashKey;
        }

        @Override
        public final Builder endingHashKey(String endingHashKey) {
            this.endingHashKey = endingHashKey;
            return this;
        }

        public final void setEndingHashKey(String endingHashKey) {
            this.endingHashKey = endingHashKey;
        }

        @Override
        public HashKeyRange build() {
            return new HashKeyRange(this);
        }
    }
}
