/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for <code>ListTagsForStream</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTagsForStreamRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListTagsForStreamRequest.Builder, ListTagsForStreamRequest> {
    private final String streamName;

    private final String exclusiveStartTagKey;

    private final Integer limit;

    private ListTagsForStreamRequest(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.exclusiveStartTagKey = builder.exclusiveStartTagKey;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * The name of the stream.
     * </p>
     * 
     * @return The name of the stream.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The key to use as the starting point for the list of tags. If this parameter is set,
     * <code>ListTagsForStream</code> gets all tags that occur after <code>ExclusiveStartTagKey</code>.
     * </p>
     * 
     * @return The key to use as the starting point for the list of tags. If this parameter is set,
     *         <code>ListTagsForStream</code> gets all tags that occur after <code>ExclusiveStartTagKey</code>.
     */
    public String exclusiveStartTagKey() {
        return exclusiveStartTagKey;
    }

    /**
     * <p>
     * The number of tags to return. If this number is less than the total number of tags associated with the stream,
     * <code>HasMoreTags</code> is set to <code>true</code>. To list additional tags, set
     * <code>ExclusiveStartTagKey</code> to the last key in the response.
     * </p>
     * 
     * @return The number of tags to return. If this number is less than the total number of tags associated with the
     *         stream, <code>HasMoreTags</code> is set to <code>true</code>. To list additional tags, set
     *         <code>ExclusiveStartTagKey</code> to the last key in the response.
     */
    public Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((streamName() == null) ? 0 : streamName().hashCode());
        hashCode = 31 * hashCode + ((exclusiveStartTagKey() == null) ? 0 : exclusiveStartTagKey().hashCode());
        hashCode = 31 * hashCode + ((limit() == null) ? 0 : limit().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForStreamRequest)) {
            return false;
        }
        ListTagsForStreamRequest other = (ListTagsForStreamRequest) obj;
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        if (other.streamName() != null && !other.streamName().equals(this.streamName())) {
            return false;
        }
        if (other.exclusiveStartTagKey() == null ^ this.exclusiveStartTagKey() == null) {
            return false;
        }
        if (other.exclusiveStartTagKey() != null && !other.exclusiveStartTagKey().equals(this.exclusiveStartTagKey())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (streamName() != null) {
            sb.append("StreamName: ").append(streamName()).append(",");
        }
        if (exclusiveStartTagKey() != null) {
            sb.append("ExclusiveStartTagKey: ").append(exclusiveStartTagKey()).append(",");
        }
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListTagsForStreamRequest> {
        /**
         * <p>
         * The name of the stream.
         * </p>
         * 
         * @param streamName
         *        The name of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The key to use as the starting point for the list of tags. If this parameter is set,
         * <code>ListTagsForStream</code> gets all tags that occur after <code>ExclusiveStartTagKey</code>.
         * </p>
         * 
         * @param exclusiveStartTagKey
         *        The key to use as the starting point for the list of tags. If this parameter is set,
         *        <code>ListTagsForStream</code> gets all tags that occur after <code>ExclusiveStartTagKey</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartTagKey(String exclusiveStartTagKey);

        /**
         * <p>
         * The number of tags to return. If this number is less than the total number of tags associated with the
         * stream, <code>HasMoreTags</code> is set to <code>true</code>. To list additional tags, set
         * <code>ExclusiveStartTagKey</code> to the last key in the response.
         * </p>
         * 
         * @param limit
         *        The number of tags to return. If this number is less than the total number of tags associated with the
         *        stream, <code>HasMoreTags</code> is set to <code>true</code>. To list additional tags, set
         *        <code>ExclusiveStartTagKey</code> to the last key in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);
    }

    private static final class BuilderImpl implements Builder {
        private String streamName;

        private String exclusiveStartTagKey;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForStreamRequest model) {
            setStreamName(model.streamName);
            setExclusiveStartTagKey(model.exclusiveStartTagKey);
            setLimit(model.limit);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getExclusiveStartTagKey() {
            return exclusiveStartTagKey;
        }

        @Override
        public final Builder exclusiveStartTagKey(String exclusiveStartTagKey) {
            this.exclusiveStartTagKey = exclusiveStartTagKey;
            return this;
        }

        public final void setExclusiveStartTagKey(String exclusiveStartTagKey) {
            this.exclusiveStartTagKey = exclusiveStartTagKey;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public ListTagsForStreamRequest build() {
            return new ListTagsForStreamRequest(this);
        }
    }
}
