/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for <code>MergeShards</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MergeShardsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<MergeShardsRequest.Builder, MergeShardsRequest> {
    private final String streamName;

    private final String shardToMerge;

    private final String adjacentShardToMerge;

    private MergeShardsRequest(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.shardToMerge = builder.shardToMerge;
        this.adjacentShardToMerge = builder.adjacentShardToMerge;
    }

    /**
     * <p>
     * The name of the stream for the merge.
     * </p>
     * 
     * @return The name of the stream for the merge.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The shard ID of the shard to combine with the adjacent shard for the merge.
     * </p>
     * 
     * @return The shard ID of the shard to combine with the adjacent shard for the merge.
     */
    public String shardToMerge() {
        return shardToMerge;
    }

    /**
     * <p>
     * The shard ID of the adjacent shard for the merge.
     * </p>
     * 
     * @return The shard ID of the adjacent shard for the merge.
     */
    public String adjacentShardToMerge() {
        return adjacentShardToMerge;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((streamName() == null) ? 0 : streamName().hashCode());
        hashCode = 31 * hashCode + ((shardToMerge() == null) ? 0 : shardToMerge().hashCode());
        hashCode = 31 * hashCode + ((adjacentShardToMerge() == null) ? 0 : adjacentShardToMerge().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeShardsRequest)) {
            return false;
        }
        MergeShardsRequest other = (MergeShardsRequest) obj;
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        if (other.streamName() != null && !other.streamName().equals(this.streamName())) {
            return false;
        }
        if (other.shardToMerge() == null ^ this.shardToMerge() == null) {
            return false;
        }
        if (other.shardToMerge() != null && !other.shardToMerge().equals(this.shardToMerge())) {
            return false;
        }
        if (other.adjacentShardToMerge() == null ^ this.adjacentShardToMerge() == null) {
            return false;
        }
        if (other.adjacentShardToMerge() != null && !other.adjacentShardToMerge().equals(this.adjacentShardToMerge())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (streamName() != null) {
            sb.append("StreamName: ").append(streamName()).append(",");
        }
        if (shardToMerge() != null) {
            sb.append("ShardToMerge: ").append(shardToMerge()).append(",");
        }
        if (adjacentShardToMerge() != null) {
            sb.append("AdjacentShardToMerge: ").append(adjacentShardToMerge()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, MergeShardsRequest> {
        /**
         * <p>
         * The name of the stream for the merge.
         * </p>
         * 
         * @param streamName
         *        The name of the stream for the merge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The shard ID of the shard to combine with the adjacent shard for the merge.
         * </p>
         * 
         * @param shardToMerge
         *        The shard ID of the shard to combine with the adjacent shard for the merge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardToMerge(String shardToMerge);

        /**
         * <p>
         * The shard ID of the adjacent shard for the merge.
         * </p>
         * 
         * @param adjacentShardToMerge
         *        The shard ID of the adjacent shard for the merge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adjacentShardToMerge(String adjacentShardToMerge);
    }

    private static final class BuilderImpl implements Builder {
        private String streamName;

        private String shardToMerge;

        private String adjacentShardToMerge;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeShardsRequest model) {
            setStreamName(model.streamName);
            setShardToMerge(model.shardToMerge);
            setAdjacentShardToMerge(model.adjacentShardToMerge);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getShardToMerge() {
            return shardToMerge;
        }

        @Override
        public final Builder shardToMerge(String shardToMerge) {
            this.shardToMerge = shardToMerge;
            return this;
        }

        public final void setShardToMerge(String shardToMerge) {
            this.shardToMerge = shardToMerge;
        }

        public final String getAdjacentShardToMerge() {
            return adjacentShardToMerge;
        }

        @Override
        public final Builder adjacentShardToMerge(String adjacentShardToMerge) {
            this.adjacentShardToMerge = adjacentShardToMerge;
            return this;
        }

        public final void setAdjacentShardToMerge(String adjacentShardToMerge) {
            this.adjacentShardToMerge = adjacentShardToMerge;
        }

        @Override
        public MergeShardsRequest build() {
            return new MergeShardsRequest(this);
        }
    }
}
