/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for <code>RemoveTagsFromStream</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RemoveTagsFromStreamRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RemoveTagsFromStreamRequest.Builder, RemoveTagsFromStreamRequest> {
    private final String streamName;

    private final List<String> tagKeys;

    private RemoveTagsFromStreamRequest(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.tagKeys = builder.tagKeys;
    }

    /**
     * <p>
     * The name of the stream.
     * </p>
     * 
     * @return The name of the stream.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * A list of tag keys. Each corresponding tag is removed from the stream.
     * </p>
     * 
     * @return A list of tag keys. Each corresponding tag is removed from the stream.
     */
    public List<String> tagKeys() {
        return tagKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((streamName() == null) ? 0 : streamName().hashCode());
        hashCode = 31 * hashCode + ((tagKeys() == null) ? 0 : tagKeys().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveTagsFromStreamRequest)) {
            return false;
        }
        RemoveTagsFromStreamRequest other = (RemoveTagsFromStreamRequest) obj;
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        if (other.streamName() != null && !other.streamName().equals(this.streamName())) {
            return false;
        }
        if (other.tagKeys() == null ^ this.tagKeys() == null) {
            return false;
        }
        if (other.tagKeys() != null && !other.tagKeys().equals(this.tagKeys())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (streamName() != null) {
            sb.append("StreamName: ").append(streamName()).append(",");
        }
        if (tagKeys() != null) {
            sb.append("TagKeys: ").append(tagKeys()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RemoveTagsFromStreamRequest> {
        /**
         * <p>
         * The name of the stream.
         * </p>
         * 
         * @param streamName
         *        The name of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * A list of tag keys. Each corresponding tag is removed from the stream.
         * </p>
         * 
         * @param tagKeys
         *        A list of tag keys. Each corresponding tag is removed from the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeys(Collection<String> tagKeys);

        /**
         * <p>
         * A list of tag keys. Each corresponding tag is removed from the stream.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setTagKeys(java.util.Collection)} or {@link #withTagKeys(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param tagKeys
         *        A list of tag keys. Each corresponding tag is removed from the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeys(String... tagKeys);
    }

    private static final class BuilderImpl implements Builder {
        private String streamName;

        private List<String> tagKeys = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveTagsFromStreamRequest model) {
            setStreamName(model.streamName);
            setTagKeys(model.tagKeys);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Collection<String> getTagKeys() {
            return tagKeys;
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String... tagKeys) {
            if (this.tagKeys == null) {
                this.tagKeys = new SdkInternalList<>(tagKeys.length);
            }
            for (String e : tagKeys) {
                this.tagKeys.add(e);
            }
            return this;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
        }

        @SafeVarargs
        public final void setTagKeys(String... tagKeys) {
            if (this.tagKeys == null) {
                this.tagKeys = new SdkInternalList<>(tagKeys.length);
            }
            for (String e : tagKeys) {
                this.tagKeys.add(e);
            }
        }

        @Override
        public RemoveTagsFromStreamRequest build() {
            return new RemoveTagsFromStreamRequest(this);
        }
    }
}
