/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for <code>SplitShard</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SplitShardRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<SplitShardRequest.Builder, SplitShardRequest> {
    private final String streamName;

    private final String shardToSplit;

    private final String newStartingHashKey;

    private SplitShardRequest(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.shardToSplit = builder.shardToSplit;
        this.newStartingHashKey = builder.newStartingHashKey;
    }

    /**
     * <p>
     * The name of the stream for the shard split.
     * </p>
     * 
     * @return The name of the stream for the shard split.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The shard ID of the shard to split.
     * </p>
     * 
     * @return The shard ID of the shard to split.
     */
    public String shardToSplit() {
        return shardToSplit;
    }

    /**
     * <p>
     * A hash key value for the starting hash key of one of the child shards created by the split. The hash key range
     * for a given shard constitutes a set of ordered contiguous positive integers. The value for
     * <code>NewStartingHashKey</code> must be in the range of hash keys being mapped into the shard. The
     * <code>NewStartingHashKey</code> hash key value and all higher hash key values in hash key range are distributed
     * to one of the child shards. All the lower hash key values in the range are distributed to the other child shard.
     * </p>
     * 
     * @return A hash key value for the starting hash key of one of the child shards created by the split. The hash key
     *         range for a given shard constitutes a set of ordered contiguous positive integers. The value for
     *         <code>NewStartingHashKey</code> must be in the range of hash keys being mapped into the shard. The
     *         <code>NewStartingHashKey</code> hash key value and all higher hash key values in hash key range are
     *         distributed to one of the child shards. All the lower hash key values in the range are distributed to the
     *         other child shard.
     */
    public String newStartingHashKey() {
        return newStartingHashKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((streamName() == null) ? 0 : streamName().hashCode());
        hashCode = 31 * hashCode + ((shardToSplit() == null) ? 0 : shardToSplit().hashCode());
        hashCode = 31 * hashCode + ((newStartingHashKey() == null) ? 0 : newStartingHashKey().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SplitShardRequest)) {
            return false;
        }
        SplitShardRequest other = (SplitShardRequest) obj;
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        if (other.streamName() != null && !other.streamName().equals(this.streamName())) {
            return false;
        }
        if (other.shardToSplit() == null ^ this.shardToSplit() == null) {
            return false;
        }
        if (other.shardToSplit() != null && !other.shardToSplit().equals(this.shardToSplit())) {
            return false;
        }
        if (other.newStartingHashKey() == null ^ this.newStartingHashKey() == null) {
            return false;
        }
        if (other.newStartingHashKey() != null && !other.newStartingHashKey().equals(this.newStartingHashKey())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (streamName() != null) {
            sb.append("StreamName: ").append(streamName()).append(",");
        }
        if (shardToSplit() != null) {
            sb.append("ShardToSplit: ").append(shardToSplit()).append(",");
        }
        if (newStartingHashKey() != null) {
            sb.append("NewStartingHashKey: ").append(newStartingHashKey()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SplitShardRequest> {
        /**
         * <p>
         * The name of the stream for the shard split.
         * </p>
         * 
         * @param streamName
         *        The name of the stream for the shard split.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The shard ID of the shard to split.
         * </p>
         * 
         * @param shardToSplit
         *        The shard ID of the shard to split.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardToSplit(String shardToSplit);

        /**
         * <p>
         * A hash key value for the starting hash key of one of the child shards created by the split. The hash key
         * range for a given shard constitutes a set of ordered contiguous positive integers. The value for
         * <code>NewStartingHashKey</code> must be in the range of hash keys being mapped into the shard. The
         * <code>NewStartingHashKey</code> hash key value and all higher hash key values in hash key range are
         * distributed to one of the child shards. All the lower hash key values in the range are distributed to the
         * other child shard.
         * </p>
         * 
         * @param newStartingHashKey
         *        A hash key value for the starting hash key of one of the child shards created by the split. The hash
         *        key range for a given shard constitutes a set of ordered contiguous positive integers. The value for
         *        <code>NewStartingHashKey</code> must be in the range of hash keys being mapped into the shard. The
         *        <code>NewStartingHashKey</code> hash key value and all higher hash key values in hash key range are
         *        distributed to one of the child shards. All the lower hash key values in the range are distributed to
         *        the other child shard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newStartingHashKey(String newStartingHashKey);
    }

    private static final class BuilderImpl implements Builder {
        private String streamName;

        private String shardToSplit;

        private String newStartingHashKey;

        private BuilderImpl() {
        }

        private BuilderImpl(SplitShardRequest model) {
            setStreamName(model.streamName);
            setShardToSplit(model.shardToSplit);
            setNewStartingHashKey(model.newStartingHashKey);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getShardToSplit() {
            return shardToSplit;
        }

        @Override
        public final Builder shardToSplit(String shardToSplit) {
            this.shardToSplit = shardToSplit;
            return this;
        }

        public final void setShardToSplit(String shardToSplit) {
            this.shardToSplit = shardToSplit;
        }

        public final String getNewStartingHashKey() {
            return newStartingHashKey;
        }

        @Override
        public final Builder newStartingHashKey(String newStartingHashKey) {
            this.newStartingHashKey = newStartingHashKey;
            return this;
        }

        public final void setNewStartingHashKey(String newStartingHashKey) {
            this.newStartingHashKey = newStartingHashKey;
        }

        @Override
        public SplitShardRequest build() {
            return new SplitShardRequest(this);
        }
    }
}
