/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class AddApplicationCloudWatchLoggingOptionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<AddApplicationCloudWatchLoggingOptionRequest.Builder, AddApplicationCloudWatchLoggingOptionRequest> {
    private final String applicationName;

    private final Long currentApplicationVersionId;

    private final CloudWatchLoggingOption cloudWatchLoggingOption;

    private AddApplicationCloudWatchLoggingOptionRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.cloudWatchLoggingOption = builder.cloudWatchLoggingOption;
    }

    /**
     * <p>
     * The Amazon Kinesis Analytics application name.
     * </p>
     * 
     * @return The Amazon Kinesis Analytics application name.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The version ID of the Amazon Kinesis Analytics application.
     * </p>
     * 
     * @return The version ID of the Amazon Kinesis Analytics application.
     */
    public Long currentApplicationVersionId() {
        return currentApplicationVersionId;
    }

    /**
     * <p>
     * Provide the CloudWatch log stream ARN and the IAM role ARN. Note: To write application messages to CloudWatch,
     * the IAM role used must have the <code>PutLogEvents</code> policy action enabled.
     * </p>
     * 
     * @return Provide the CloudWatch log stream ARN and the IAM role ARN. Note: To write application messages to
     *         CloudWatch, the IAM role used must have the <code>PutLogEvents</code> policy action enabled.
     */
    public CloudWatchLoggingOption cloudWatchLoggingOption() {
        return cloudWatchLoggingOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationName() == null) ? 0 : applicationName().hashCode());
        hashCode = 31 * hashCode + ((currentApplicationVersionId() == null) ? 0 : currentApplicationVersionId().hashCode());
        hashCode = 31 * hashCode + ((cloudWatchLoggingOption() == null) ? 0 : cloudWatchLoggingOption().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationCloudWatchLoggingOptionRequest)) {
            return false;
        }
        AddApplicationCloudWatchLoggingOptionRequest other = (AddApplicationCloudWatchLoggingOptionRequest) obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.currentApplicationVersionId() == null ^ this.currentApplicationVersionId() == null) {
            return false;
        }
        if (other.currentApplicationVersionId() != null
                && !other.currentApplicationVersionId().equals(this.currentApplicationVersionId())) {
            return false;
        }
        if (other.cloudWatchLoggingOption() == null ^ this.cloudWatchLoggingOption() == null) {
            return false;
        }
        if (other.cloudWatchLoggingOption() != null && !other.cloudWatchLoggingOption().equals(this.cloudWatchLoggingOption())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (currentApplicationVersionId() != null) {
            sb.append("CurrentApplicationVersionId: ").append(currentApplicationVersionId()).append(",");
        }
        if (cloudWatchLoggingOption() != null) {
            sb.append("CloudWatchLoggingOption: ").append(cloudWatchLoggingOption()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AddApplicationCloudWatchLoggingOptionRequest> {
        /**
         * <p>
         * The Amazon Kinesis Analytics application name.
         * </p>
         * 
         * @param applicationName
         *        The Amazon Kinesis Analytics application name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The version ID of the Amazon Kinesis Analytics application.
         * </p>
         * 
         * @param currentApplicationVersionId
         *        The version ID of the Amazon Kinesis Analytics application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplicationVersionId(Long currentApplicationVersionId);

        /**
         * <p>
         * Provide the CloudWatch log stream ARN and the IAM role ARN. Note: To write application messages to
         * CloudWatch, the IAM role used must have the <code>PutLogEvents</code> policy action enabled.
         * </p>
         * 
         * @param cloudWatchLoggingOption
         *        Provide the CloudWatch log stream ARN and the IAM role ARN. Note: To write application messages to
         *        CloudWatch, the IAM role used must have the <code>PutLogEvents</code> policy action enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOption(CloudWatchLoggingOption cloudWatchLoggingOption);
    }

    private static final class BuilderImpl implements Builder {
        private String applicationName;

        private Long currentApplicationVersionId;

        private CloudWatchLoggingOption cloudWatchLoggingOption;

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationCloudWatchLoggingOptionRequest model) {
            setApplicationName(model.applicationName);
            setCurrentApplicationVersionId(model.currentApplicationVersionId);
            setCloudWatchLoggingOption(model.cloudWatchLoggingOption);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final CloudWatchLoggingOption getCloudWatchLoggingOption() {
            return cloudWatchLoggingOption;
        }

        @Override
        public final Builder cloudWatchLoggingOption(CloudWatchLoggingOption cloudWatchLoggingOption) {
            this.cloudWatchLoggingOption = cloudWatchLoggingOption;
            return this;
        }

        public final void setCloudWatchLoggingOption(CloudWatchLoggingOption cloudWatchLoggingOption) {
            this.cloudWatchLoggingOption = cloudWatchLoggingOption;
        }

        @Override
        public AddApplicationCloudWatchLoggingOptionRequest build() {
            return new AddApplicationCloudWatchLoggingOptionRequest(this);
        }
    }
}
