/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.kinesisanalytics.transform.ApplicationDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a description of the application, including the application Amazon Resource Name (ARN), status, latest
 * version, and input and output configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ApplicationDetail implements StructuredPojo, ToCopyableBuilder<ApplicationDetail.Builder, ApplicationDetail> {
    private final String applicationName;

    private final String applicationDescription;

    private final String applicationARN;

    private final String applicationStatus;

    private final Date createTimestamp;

    private final Date lastUpdateTimestamp;

    private final List<InputDescription> inputDescriptions;

    private final List<OutputDescription> outputDescriptions;

    private final List<ReferenceDataSourceDescription> referenceDataSourceDescriptions;

    private final List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions;

    private final String applicationCode;

    private final Long applicationVersionId;

    private ApplicationDetail(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.applicationDescription = builder.applicationDescription;
        this.applicationARN = builder.applicationARN;
        this.applicationStatus = builder.applicationStatus;
        this.createTimestamp = builder.createTimestamp;
        this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
        this.inputDescriptions = builder.inputDescriptions;
        this.outputDescriptions = builder.outputDescriptions;
        this.referenceDataSourceDescriptions = builder.referenceDataSourceDescriptions;
        this.cloudWatchLoggingOptionDescriptions = builder.cloudWatchLoggingOptionDescriptions;
        this.applicationCode = builder.applicationCode;
        this.applicationVersionId = builder.applicationVersionId;
    }

    /**
     * <p>
     * Name of the application.
     * </p>
     * 
     * @return Name of the application.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Description of the application.
     * </p>
     * 
     * @return Description of the application.
     */
    public String applicationDescription() {
        return applicationDescription;
    }

    /**
     * <p>
     * ARN of the application.
     * </p>
     * 
     * @return ARN of the application.
     */
    public String applicationARN() {
        return applicationARN;
    }

    /**
     * <p>
     * Status of the application.
     * </p>
     * 
     * @return Status of the application.
     * @see ApplicationStatus
     */
    public String applicationStatus() {
        return applicationStatus;
    }

    /**
     * <p>
     * Timestamp when the application version was created.
     * </p>
     * 
     * @return Timestamp when the application version was created.
     */
    public Date createTimestamp() {
        return createTimestamp;
    }

    /**
     * <p>
     * Timestamp when the application was last updated.
     * </p>
     * 
     * @return Timestamp when the application was last updated.
     */
    public Date lastUpdateTimestamp() {
        return lastUpdateTimestamp;
    }

    /**
     * <p>
     * Describes the application input configuration. For more information, see <a
     * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application
     * Input</a>.
     * </p>
     * 
     * @return Describes the application input configuration. For more information, see <a
     *         href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring
     *         Application Input</a>.
     */
    public List<InputDescription> inputDescriptions() {
        return inputDescriptions;
    }

    /**
     * <p>
     * Describes the application output configuration. For more information, see <a
     * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring Application
     * Output</a>.
     * </p>
     * 
     * @return Describes the application output configuration. For more information, see <a
     *         href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring
     *         Application Output</a>.
     */
    public List<OutputDescription> outputDescriptions() {
        return outputDescriptions;
    }

    /**
     * <p>
     * Describes reference data sources configured for the application. For more information, see <a
     * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application
     * Input</a>.
     * </p>
     * 
     * @return Describes reference data sources configured for the application. For more information, see <a
     *         href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring
     *         Application Input</a>.
     */
    public List<ReferenceDataSourceDescription> referenceDataSourceDescriptions() {
        return referenceDataSourceDescriptions;
    }

    /**
     * <p>
     * Describes the CloudWatch log streams configured to receive application messages. For more information about using
     * CloudWatch log streams with Amazon Kinesis Analytics applications, see <a
     * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-monitor-configuration.html">Monitoring
     * Configuration Errors</a>.
     * </p>
     * 
     * @return Describes the CloudWatch log streams configured to receive application messages. For more information
     *         about using CloudWatch log streams with Amazon Kinesis Analytics applications, see <a
     *         href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-monitor-configuration.html"
     *         >Monitoring Configuration Errors</a>.
     */
    public List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions() {
        return cloudWatchLoggingOptionDescriptions;
    }

    /**
     * <p>
     * Returns the application code that you provided to perform data analysis on any of the in-application streams in
     * your application.
     * </p>
     * 
     * @return Returns the application code that you provided to perform data analysis on any of the in-application
     *         streams in your application.
     */
    public String applicationCode() {
        return applicationCode;
    }

    /**
     * <p>
     * Provides the current application version.
     * </p>
     * 
     * @return Provides the current application version.
     */
    public Long applicationVersionId() {
        return applicationVersionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationName() == null) ? 0 : applicationName().hashCode());
        hashCode = 31 * hashCode + ((applicationDescription() == null) ? 0 : applicationDescription().hashCode());
        hashCode = 31 * hashCode + ((applicationARN() == null) ? 0 : applicationARN().hashCode());
        hashCode = 31 * hashCode + ((applicationStatus() == null) ? 0 : applicationStatus().hashCode());
        hashCode = 31 * hashCode + ((createTimestamp() == null) ? 0 : createTimestamp().hashCode());
        hashCode = 31 * hashCode + ((lastUpdateTimestamp() == null) ? 0 : lastUpdateTimestamp().hashCode());
        hashCode = 31 * hashCode + ((inputDescriptions() == null) ? 0 : inputDescriptions().hashCode());
        hashCode = 31 * hashCode + ((outputDescriptions() == null) ? 0 : outputDescriptions().hashCode());
        hashCode = 31 * hashCode
                + ((referenceDataSourceDescriptions() == null) ? 0 : referenceDataSourceDescriptions().hashCode());
        hashCode = 31 * hashCode
                + ((cloudWatchLoggingOptionDescriptions() == null) ? 0 : cloudWatchLoggingOptionDescriptions().hashCode());
        hashCode = 31 * hashCode + ((applicationCode() == null) ? 0 : applicationCode().hashCode());
        hashCode = 31 * hashCode + ((applicationVersionId() == null) ? 0 : applicationVersionId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationDetail)) {
            return false;
        }
        ApplicationDetail other = (ApplicationDetail) obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.applicationDescription() == null ^ this.applicationDescription() == null) {
            return false;
        }
        if (other.applicationDescription() != null && !other.applicationDescription().equals(this.applicationDescription())) {
            return false;
        }
        if (other.applicationARN() == null ^ this.applicationARN() == null) {
            return false;
        }
        if (other.applicationARN() != null && !other.applicationARN().equals(this.applicationARN())) {
            return false;
        }
        if (other.applicationStatus() == null ^ this.applicationStatus() == null) {
            return false;
        }
        if (other.applicationStatus() != null && !other.applicationStatus().equals(this.applicationStatus())) {
            return false;
        }
        if (other.createTimestamp() == null ^ this.createTimestamp() == null) {
            return false;
        }
        if (other.createTimestamp() != null && !other.createTimestamp().equals(this.createTimestamp())) {
            return false;
        }
        if (other.lastUpdateTimestamp() == null ^ this.lastUpdateTimestamp() == null) {
            return false;
        }
        if (other.lastUpdateTimestamp() != null && !other.lastUpdateTimestamp().equals(this.lastUpdateTimestamp())) {
            return false;
        }
        if (other.inputDescriptions() == null ^ this.inputDescriptions() == null) {
            return false;
        }
        if (other.inputDescriptions() != null && !other.inputDescriptions().equals(this.inputDescriptions())) {
            return false;
        }
        if (other.outputDescriptions() == null ^ this.outputDescriptions() == null) {
            return false;
        }
        if (other.outputDescriptions() != null && !other.outputDescriptions().equals(this.outputDescriptions())) {
            return false;
        }
        if (other.referenceDataSourceDescriptions() == null ^ this.referenceDataSourceDescriptions() == null) {
            return false;
        }
        if (other.referenceDataSourceDescriptions() != null
                && !other.referenceDataSourceDescriptions().equals(this.referenceDataSourceDescriptions())) {
            return false;
        }
        if (other.cloudWatchLoggingOptionDescriptions() == null ^ this.cloudWatchLoggingOptionDescriptions() == null) {
            return false;
        }
        if (other.cloudWatchLoggingOptionDescriptions() != null
                && !other.cloudWatchLoggingOptionDescriptions().equals(this.cloudWatchLoggingOptionDescriptions())) {
            return false;
        }
        if (other.applicationCode() == null ^ this.applicationCode() == null) {
            return false;
        }
        if (other.applicationCode() != null && !other.applicationCode().equals(this.applicationCode())) {
            return false;
        }
        if (other.applicationVersionId() == null ^ this.applicationVersionId() == null) {
            return false;
        }
        if (other.applicationVersionId() != null && !other.applicationVersionId().equals(this.applicationVersionId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (applicationDescription() != null) {
            sb.append("ApplicationDescription: ").append(applicationDescription()).append(",");
        }
        if (applicationARN() != null) {
            sb.append("ApplicationARN: ").append(applicationARN()).append(",");
        }
        if (applicationStatus() != null) {
            sb.append("ApplicationStatus: ").append(applicationStatus()).append(",");
        }
        if (createTimestamp() != null) {
            sb.append("CreateTimestamp: ").append(createTimestamp()).append(",");
        }
        if (lastUpdateTimestamp() != null) {
            sb.append("LastUpdateTimestamp: ").append(lastUpdateTimestamp()).append(",");
        }
        if (inputDescriptions() != null) {
            sb.append("InputDescriptions: ").append(inputDescriptions()).append(",");
        }
        if (outputDescriptions() != null) {
            sb.append("OutputDescriptions: ").append(outputDescriptions()).append(",");
        }
        if (referenceDataSourceDescriptions() != null) {
            sb.append("ReferenceDataSourceDescriptions: ").append(referenceDataSourceDescriptions()).append(",");
        }
        if (cloudWatchLoggingOptionDescriptions() != null) {
            sb.append("CloudWatchLoggingOptionDescriptions: ").append(cloudWatchLoggingOptionDescriptions()).append(",");
        }
        if (applicationCode() != null) {
            sb.append("ApplicationCode: ").append(applicationCode()).append(",");
        }
        if (applicationVersionId() != null) {
            sb.append("ApplicationVersionId: ").append(applicationVersionId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ApplicationDetail> {
        /**
         * <p>
         * Name of the application.
         * </p>
         * 
         * @param applicationName
         *        Name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Description of the application.
         * </p>
         * 
         * @param applicationDescription
         *        Description of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationDescription(String applicationDescription);

        /**
         * <p>
         * ARN of the application.
         * </p>
         * 
         * @param applicationARN
         *        ARN of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationARN(String applicationARN);

        /**
         * <p>
         * Status of the application.
         * </p>
         * 
         * @param applicationStatus
         *        Status of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder applicationStatus(String applicationStatus);

        /**
         * <p>
         * Status of the application.
         * </p>
         * 
         * @param applicationStatus
         *        Status of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder applicationStatus(ApplicationStatus applicationStatus);

        /**
         * <p>
         * Timestamp when the application version was created.
         * </p>
         * 
         * @param createTimestamp
         *        Timestamp when the application version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTimestamp(Date createTimestamp);

        /**
         * <p>
         * Timestamp when the application was last updated.
         * </p>
         * 
         * @param lastUpdateTimestamp
         *        Timestamp when the application was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTimestamp(Date lastUpdateTimestamp);

        /**
         * <p>
         * Describes the application input configuration. For more information, see <a
         * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application
         * Input</a>.
         * </p>
         * 
         * @param inputDescriptions
         *        Describes the application input configuration. For more information, see <a
         *        href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring
         *        Application Input</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDescriptions(Collection<InputDescription> inputDescriptions);

        /**
         * <p>
         * Describes the application input configuration. For more information, see <a
         * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application
         * Input</a>.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setInputDescriptions(java.util.Collection)} or {@link #withInputDescriptions(java.util.Collection)}
         * if you want to override the existing values.
         * </p>
         * 
         * @param inputDescriptions
         *        Describes the application input configuration. For more information, see <a
         *        href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring
         *        Application Input</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDescriptions(InputDescription... inputDescriptions);

        /**
         * <p>
         * Describes the application output configuration. For more information, see <a
         * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring
         * Application Output</a>.
         * </p>
         * 
         * @param outputDescriptions
         *        Describes the application output configuration. For more information, see <a
         *        href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring
         *        Application Output</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDescriptions(Collection<OutputDescription> outputDescriptions);

        /**
         * <p>
         * Describes the application output configuration. For more information, see <a
         * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring
         * Application Output</a>.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setOutputDescriptions(java.util.Collection)} or {@link #withOutputDescriptions(java.util.Collection)}
         * if you want to override the existing values.
         * </p>
         * 
         * @param outputDescriptions
         *        Describes the application output configuration. For more information, see <a
         *        href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring
         *        Application Output</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDescriptions(OutputDescription... outputDescriptions);

        /**
         * <p>
         * Describes reference data sources configured for the application. For more information, see <a
         * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application
         * Input</a>.
         * </p>
         * 
         * @param referenceDataSourceDescriptions
         *        Describes reference data sources configured for the application. For more information, see <a
         *        href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring
         *        Application Input</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceDataSourceDescriptions(Collection<ReferenceDataSourceDescription> referenceDataSourceDescriptions);

        /**
         * <p>
         * Describes reference data sources configured for the application. For more information, see <a
         * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application
         * Input</a>.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setReferenceDataSourceDescriptions(java.util.Collection)} or
         * {@link #withReferenceDataSourceDescriptions(java.util.Collection)} if you want to override the existing
         * values.
         * </p>
         * 
         * @param referenceDataSourceDescriptions
         *        Describes reference data sources configured for the application. For more information, see <a
         *        href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring
         *        Application Input</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceDataSourceDescriptions(ReferenceDataSourceDescription... referenceDataSourceDescriptions);

        /**
         * <p>
         * Describes the CloudWatch log streams configured to receive application messages. For more information about
         * using CloudWatch log streams with Amazon Kinesis Analytics applications, see <a
         * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-monitor-configuration.html"
         * >Monitoring Configuration Errors</a>.
         * </p>
         * 
         * @param cloudWatchLoggingOptionDescriptions
         *        Describes the CloudWatch log streams configured to receive application messages. For more information
         *        about using CloudWatch log streams with Amazon Kinesis Analytics applications, see <a
         *        href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-monitor-configuration.html"
         *        >Monitoring Configuration Errors</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptionDescriptions(
                Collection<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions);

        /**
         * <p>
         * Describes the CloudWatch log streams configured to receive application messages. For more information about
         * using CloudWatch log streams with Amazon Kinesis Analytics applications, see <a
         * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-monitor-configuration.html"
         * >Monitoring Configuration Errors</a>.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setCloudWatchLoggingOptionDescriptions(java.util.Collection)} or
         * {@link #withCloudWatchLoggingOptionDescriptions(java.util.Collection)} if you want to override the existing
         * values.
         * </p>
         * 
         * @param cloudWatchLoggingOptionDescriptions
         *        Describes the CloudWatch log streams configured to receive application messages. For more information
         *        about using CloudWatch log streams with Amazon Kinesis Analytics applications, see <a
         *        href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-monitor-configuration.html"
         *        >Monitoring Configuration Errors</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptionDescriptions(CloudWatchLoggingOptionDescription... cloudWatchLoggingOptionDescriptions);

        /**
         * <p>
         * Returns the application code that you provided to perform data analysis on any of the in-application streams
         * in your application.
         * </p>
         * 
         * @param applicationCode
         *        Returns the application code that you provided to perform data analysis on any of the in-application
         *        streams in your application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationCode(String applicationCode);

        /**
         * <p>
         * Provides the current application version.
         * </p>
         * 
         * @param applicationVersionId
         *        Provides the current application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersionId(Long applicationVersionId);
    }

    private static final class BuilderImpl implements Builder {
        private String applicationName;

        private String applicationDescription;

        private String applicationARN;

        private String applicationStatus;

        private Date createTimestamp;

        private Date lastUpdateTimestamp;

        private List<InputDescription> inputDescriptions;

        private List<OutputDescription> outputDescriptions;

        private List<ReferenceDataSourceDescription> referenceDataSourceDescriptions;

        private List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions;

        private String applicationCode;

        private Long applicationVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationDetail model) {
            setApplicationName(model.applicationName);
            setApplicationDescription(model.applicationDescription);
            setApplicationARN(model.applicationARN);
            setApplicationStatus(model.applicationStatus);
            setCreateTimestamp(model.createTimestamp);
            setLastUpdateTimestamp(model.lastUpdateTimestamp);
            setInputDescriptions(model.inputDescriptions);
            setOutputDescriptions(model.outputDescriptions);
            setReferenceDataSourceDescriptions(model.referenceDataSourceDescriptions);
            setCloudWatchLoggingOptionDescriptions(model.cloudWatchLoggingOptionDescriptions);
            setApplicationCode(model.applicationCode);
            setApplicationVersionId(model.applicationVersionId);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getApplicationDescription() {
            return applicationDescription;
        }

        @Override
        public final Builder applicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        public final void setApplicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
        }

        public final String getApplicationARN() {
            return applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        public final String getApplicationStatus() {
            return applicationStatus;
        }

        @Override
        public final Builder applicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
            return this;
        }

        @Override
        public final Builder applicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus(applicationStatus.toString());
            return this;
        }

        public final void setApplicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
        }

        public final void setApplicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus(applicationStatus.toString());
        }

        public final Date getCreateTimestamp() {
            return createTimestamp;
        }

        @Override
        public final Builder createTimestamp(Date createTimestamp) {
            this.createTimestamp = StandardMemberCopier.copy(createTimestamp);
            return this;
        }

        public final void setCreateTimestamp(Date createTimestamp) {
            this.createTimestamp = StandardMemberCopier.copy(createTimestamp);
        }

        public final Date getLastUpdateTimestamp() {
            return lastUpdateTimestamp;
        }

        @Override
        public final Builder lastUpdateTimestamp(Date lastUpdateTimestamp) {
            this.lastUpdateTimestamp = StandardMemberCopier.copy(lastUpdateTimestamp);
            return this;
        }

        public final void setLastUpdateTimestamp(Date lastUpdateTimestamp) {
            this.lastUpdateTimestamp = StandardMemberCopier.copy(lastUpdateTimestamp);
        }

        public final Collection<InputDescription> getInputDescriptions() {
            return inputDescriptions;
        }

        @Override
        public final Builder inputDescriptions(Collection<InputDescription> inputDescriptions) {
            this.inputDescriptions = InputDescriptionsCopier.copy(inputDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDescriptions(InputDescription... inputDescriptions) {
            if (this.inputDescriptions == null) {
                this.inputDescriptions = new ArrayList<>(inputDescriptions.length);
            }
            for (InputDescription e : inputDescriptions) {
                this.inputDescriptions.add(e);
            }
            return this;
        }

        public final void setInputDescriptions(Collection<InputDescription> inputDescriptions) {
            this.inputDescriptions = InputDescriptionsCopier.copy(inputDescriptions);
        }

        @SafeVarargs
        public final void setInputDescriptions(InputDescription... inputDescriptions) {
            if (this.inputDescriptions == null) {
                this.inputDescriptions = new ArrayList<>(inputDescriptions.length);
            }
            for (InputDescription e : inputDescriptions) {
                this.inputDescriptions.add(e);
            }
        }

        public final Collection<OutputDescription> getOutputDescriptions() {
            return outputDescriptions;
        }

        @Override
        public final Builder outputDescriptions(Collection<OutputDescription> outputDescriptions) {
            this.outputDescriptions = OutputDescriptionsCopier.copy(outputDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputDescriptions(OutputDescription... outputDescriptions) {
            if (this.outputDescriptions == null) {
                this.outputDescriptions = new ArrayList<>(outputDescriptions.length);
            }
            for (OutputDescription e : outputDescriptions) {
                this.outputDescriptions.add(e);
            }
            return this;
        }

        public final void setOutputDescriptions(Collection<OutputDescription> outputDescriptions) {
            this.outputDescriptions = OutputDescriptionsCopier.copy(outputDescriptions);
        }

        @SafeVarargs
        public final void setOutputDescriptions(OutputDescription... outputDescriptions) {
            if (this.outputDescriptions == null) {
                this.outputDescriptions = new ArrayList<>(outputDescriptions.length);
            }
            for (OutputDescription e : outputDescriptions) {
                this.outputDescriptions.add(e);
            }
        }

        public final Collection<ReferenceDataSourceDescription> getReferenceDataSourceDescriptions() {
            return referenceDataSourceDescriptions;
        }

        @Override
        public final Builder referenceDataSourceDescriptions(
                Collection<ReferenceDataSourceDescription> referenceDataSourceDescriptions) {
            this.referenceDataSourceDescriptions = ReferenceDataSourceDescriptionsCopier.copy(referenceDataSourceDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceDataSourceDescriptions(ReferenceDataSourceDescription... referenceDataSourceDescriptions) {
            if (this.referenceDataSourceDescriptions == null) {
                this.referenceDataSourceDescriptions = new ArrayList<>(referenceDataSourceDescriptions.length);
            }
            for (ReferenceDataSourceDescription e : referenceDataSourceDescriptions) {
                this.referenceDataSourceDescriptions.add(e);
            }
            return this;
        }

        public final void setReferenceDataSourceDescriptions(
                Collection<ReferenceDataSourceDescription> referenceDataSourceDescriptions) {
            this.referenceDataSourceDescriptions = ReferenceDataSourceDescriptionsCopier.copy(referenceDataSourceDescriptions);
        }

        @SafeVarargs
        public final void setReferenceDataSourceDescriptions(ReferenceDataSourceDescription... referenceDataSourceDescriptions) {
            if (this.referenceDataSourceDescriptions == null) {
                this.referenceDataSourceDescriptions = new ArrayList<>(referenceDataSourceDescriptions.length);
            }
            for (ReferenceDataSourceDescription e : referenceDataSourceDescriptions) {
                this.referenceDataSourceDescriptions.add(e);
            }
        }

        public final Collection<CloudWatchLoggingOptionDescription> getCloudWatchLoggingOptionDescriptions() {
            return cloudWatchLoggingOptionDescriptions;
        }

        @Override
        public final Builder cloudWatchLoggingOptionDescriptions(
                Collection<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions = CloudWatchLoggingOptionDescriptionsCopier
                    .copy(cloudWatchLoggingOptionDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionDescriptions(
                CloudWatchLoggingOptionDescription... cloudWatchLoggingOptionDescriptions) {
            if (this.cloudWatchLoggingOptionDescriptions == null) {
                this.cloudWatchLoggingOptionDescriptions = new ArrayList<>(cloudWatchLoggingOptionDescriptions.length);
            }
            for (CloudWatchLoggingOptionDescription e : cloudWatchLoggingOptionDescriptions) {
                this.cloudWatchLoggingOptionDescriptions.add(e);
            }
            return this;
        }

        public final void setCloudWatchLoggingOptionDescriptions(
                Collection<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions = CloudWatchLoggingOptionDescriptionsCopier
                    .copy(cloudWatchLoggingOptionDescriptions);
        }

        @SafeVarargs
        public final void setCloudWatchLoggingOptionDescriptions(
                CloudWatchLoggingOptionDescription... cloudWatchLoggingOptionDescriptions) {
            if (this.cloudWatchLoggingOptionDescriptions == null) {
                this.cloudWatchLoggingOptionDescriptions = new ArrayList<>(cloudWatchLoggingOptionDescriptions.length);
            }
            for (CloudWatchLoggingOptionDescription e : cloudWatchLoggingOptionDescriptions) {
                this.cloudWatchLoggingOptionDescriptions.add(e);
            }
        }

        public final String getApplicationCode() {
            return applicationCode;
        }

        @Override
        public final Builder applicationCode(String applicationCode) {
            this.applicationCode = applicationCode;
            return this;
        }

        public final void setApplicationCode(String applicationCode) {
            this.applicationCode = applicationCode;
        }

        public final Long getApplicationVersionId() {
            return applicationVersionId;
        }

        @Override
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        @Override
        public ApplicationDetail build() {
            return new ApplicationDetail(this);
        }
    }
}
