/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteApplicationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteApplicationRequest.Builder, DeleteApplicationRequest> {
    private final String applicationName;

    private final Date createTimestamp;

    private DeleteApplicationRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.createTimestamp = builder.createTimestamp;
    }

    /**
     * <p>
     * Name of the Amazon Kinesis Analytics application to delete.
     * </p>
     * 
     * @return Name of the Amazon Kinesis Analytics application to delete.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * You can use the <code>DescribeApplication</code> operation to get this value.
     * </p>
     * 
     * @return You can use the <code>DescribeApplication</code> operation to get this value.
     */
    public Date createTimestamp() {
        return createTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationName() == null) ? 0 : applicationName().hashCode());
        hashCode = 31 * hashCode + ((createTimestamp() == null) ? 0 : createTimestamp().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationRequest)) {
            return false;
        }
        DeleteApplicationRequest other = (DeleteApplicationRequest) obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.createTimestamp() == null ^ this.createTimestamp() == null) {
            return false;
        }
        if (other.createTimestamp() != null && !other.createTimestamp().equals(this.createTimestamp())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (createTimestamp() != null) {
            sb.append("CreateTimestamp: ").append(createTimestamp()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteApplicationRequest> {
        /**
         * <p>
         * Name of the Amazon Kinesis Analytics application to delete.
         * </p>
         * 
         * @param applicationName
         *        Name of the Amazon Kinesis Analytics application to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * You can use the <code>DescribeApplication</code> operation to get this value.
         * </p>
         * 
         * @param createTimestamp
         *        You can use the <code>DescribeApplication</code> operation to get this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTimestamp(Date createTimestamp);
    }

    private static final class BuilderImpl implements Builder {
        private String applicationName;

        private Date createTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationRequest model) {
            setApplicationName(model.applicationName);
            setCreateTimestamp(model.createTimestamp);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Date getCreateTimestamp() {
            return createTimestamp;
        }

        @Override
        public final Builder createTimestamp(Date createTimestamp) {
            this.createTimestamp = StandardMemberCopier.copy(createTimestamp);
            return this;
        }

        public final void setCreateTimestamp(Date createTimestamp) {
            this.createTimestamp = StandardMemberCopier.copy(createTimestamp);
        }

        @Override
        public DeleteApplicationRequest build() {
            return new DeleteApplicationRequest(this);
        }
    }
}
