/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DiscoverInputSchemaRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DiscoverInputSchemaRequest.Builder, DiscoverInputSchemaRequest> {
    private final String resourceARN;

    private final String roleARN;

    private final InputStartingPositionConfiguration inputStartingPositionConfiguration;

    private DiscoverInputSchemaRequest(BuilderImpl builder) {
        this.resourceARN = builder.resourceARN;
        this.roleARN = builder.roleARN;
        this.inputStartingPositionConfiguration = builder.inputStartingPositionConfiguration;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the streaming source.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the streaming source.
     */
    public String resourceARN() {
        return resourceARN;
    }

    /**
     * <p>
     * ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf.
     * </p>
     * 
     * @return ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * Point at which you want Amazon Kinesis Analytics to start reading records from the specified streaming source
     * discovery purposes.
     * </p>
     * 
     * @return Point at which you want Amazon Kinesis Analytics to start reading records from the specified streaming
     *         source discovery purposes.
     */
    public InputStartingPositionConfiguration inputStartingPositionConfiguration() {
        return inputStartingPositionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((resourceARN() == null) ? 0 : resourceARN().hashCode());
        hashCode = 31 * hashCode + ((roleARN() == null) ? 0 : roleARN().hashCode());
        hashCode = 31 * hashCode
                + ((inputStartingPositionConfiguration() == null) ? 0 : inputStartingPositionConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverInputSchemaRequest)) {
            return false;
        }
        DiscoverInputSchemaRequest other = (DiscoverInputSchemaRequest) obj;
        if (other.resourceARN() == null ^ this.resourceARN() == null) {
            return false;
        }
        if (other.resourceARN() != null && !other.resourceARN().equals(this.resourceARN())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.inputStartingPositionConfiguration() == null ^ this.inputStartingPositionConfiguration() == null) {
            return false;
        }
        if (other.inputStartingPositionConfiguration() != null
                && !other.inputStartingPositionConfiguration().equals(this.inputStartingPositionConfiguration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (resourceARN() != null) {
            sb.append("ResourceARN: ").append(resourceARN()).append(",");
        }
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (inputStartingPositionConfiguration() != null) {
            sb.append("InputStartingPositionConfiguration: ").append(inputStartingPositionConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DiscoverInputSchemaRequest> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the streaming source.
         * </p>
         * 
         * @param resourceARN
         *        Amazon Resource Name (ARN) of the streaming source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceARN(String resourceARN);

        /**
         * <p>
         * ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf.
         * </p>
         * 
         * @param roleARN
         *        ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * Point at which you want Amazon Kinesis Analytics to start reading records from the specified streaming source
         * discovery purposes.
         * </p>
         * 
         * @param inputStartingPositionConfiguration
         *        Point at which you want Amazon Kinesis Analytics to start reading records from the specified streaming
         *        source discovery purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputStartingPositionConfiguration(InputStartingPositionConfiguration inputStartingPositionConfiguration);
    }

    private static final class BuilderImpl implements Builder {
        private String resourceARN;

        private String roleARN;

        private InputStartingPositionConfiguration inputStartingPositionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoverInputSchemaRequest model) {
            setResourceARN(model.resourceARN);
            setRoleARN(model.roleARN);
            setInputStartingPositionConfiguration(model.inputStartingPositionConfiguration);
        }

        public final String getResourceARN() {
            return resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final InputStartingPositionConfiguration getInputStartingPositionConfiguration() {
            return inputStartingPositionConfiguration;
        }

        @Override
        public final Builder inputStartingPositionConfiguration(
                InputStartingPositionConfiguration inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration;
            return this;
        }

        public final void setInputStartingPositionConfiguration(
                InputStartingPositionConfiguration inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration;
        }

        @Override
        public DiscoverInputSchemaRequest build() {
            return new DiscoverInputSchemaRequest(this);
        }
    }
}
