/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputSchemaUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes updates for the application's input schema.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InputSchemaUpdate implements StructuredPojo, ToCopyableBuilder<InputSchemaUpdate.Builder, InputSchemaUpdate> {
    private final RecordFormat recordFormatUpdate;

    private final String recordEncodingUpdate;

    private final List<RecordColumn> recordColumnUpdates;

    private InputSchemaUpdate(BuilderImpl builder) {
        this.recordFormatUpdate = builder.recordFormatUpdate;
        this.recordEncodingUpdate = builder.recordEncodingUpdate;
        this.recordColumnUpdates = builder.recordColumnUpdates;
    }

    /**
     * <p>
     * Specifies the format of the records on the streaming source.
     * </p>
     * 
     * @return Specifies the format of the records on the streaming source.
     */
    public RecordFormat recordFormatUpdate() {
        return recordFormatUpdate;
    }

    /**
     * <p>
     * Specifies the encoding of the records in the streaming source. For example, UTF-8.
     * </p>
     * 
     * @return Specifies the encoding of the records in the streaming source. For example, UTF-8.
     */
    public String recordEncodingUpdate() {
        return recordEncodingUpdate;
    }

    /**
     * <p>
     * A list of <code>RecordColumn</code> objects. Each object describes the mapping of the streaming source element to
     * the corresponding column in the in-application stream.
     * </p>
     * 
     * @return A list of <code>RecordColumn</code> objects. Each object describes the mapping of the streaming source
     *         element to the corresponding column in the in-application stream.
     */
    public List<RecordColumn> recordColumnUpdates() {
        return recordColumnUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((recordFormatUpdate() == null) ? 0 : recordFormatUpdate().hashCode());
        hashCode = 31 * hashCode + ((recordEncodingUpdate() == null) ? 0 : recordEncodingUpdate().hashCode());
        hashCode = 31 * hashCode + ((recordColumnUpdates() == null) ? 0 : recordColumnUpdates().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSchemaUpdate)) {
            return false;
        }
        InputSchemaUpdate other = (InputSchemaUpdate) obj;
        if (other.recordFormatUpdate() == null ^ this.recordFormatUpdate() == null) {
            return false;
        }
        if (other.recordFormatUpdate() != null && !other.recordFormatUpdate().equals(this.recordFormatUpdate())) {
            return false;
        }
        if (other.recordEncodingUpdate() == null ^ this.recordEncodingUpdate() == null) {
            return false;
        }
        if (other.recordEncodingUpdate() != null && !other.recordEncodingUpdate().equals(this.recordEncodingUpdate())) {
            return false;
        }
        if (other.recordColumnUpdates() == null ^ this.recordColumnUpdates() == null) {
            return false;
        }
        if (other.recordColumnUpdates() != null && !other.recordColumnUpdates().equals(this.recordColumnUpdates())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (recordFormatUpdate() != null) {
            sb.append("RecordFormatUpdate: ").append(recordFormatUpdate()).append(",");
        }
        if (recordEncodingUpdate() != null) {
            sb.append("RecordEncodingUpdate: ").append(recordEncodingUpdate()).append(",");
        }
        if (recordColumnUpdates() != null) {
            sb.append("RecordColumnUpdates: ").append(recordColumnUpdates()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputSchemaUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InputSchemaUpdate> {
        /**
         * <p>
         * Specifies the format of the records on the streaming source.
         * </p>
         * 
         * @param recordFormatUpdate
         *        Specifies the format of the records on the streaming source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordFormatUpdate(RecordFormat recordFormatUpdate);

        /**
         * <p>
         * Specifies the encoding of the records in the streaming source. For example, UTF-8.
         * </p>
         * 
         * @param recordEncodingUpdate
         *        Specifies the encoding of the records in the streaming source. For example, UTF-8.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordEncodingUpdate(String recordEncodingUpdate);

        /**
         * <p>
         * A list of <code>RecordColumn</code> objects. Each object describes the mapping of the streaming source
         * element to the corresponding column in the in-application stream.
         * </p>
         * 
         * @param recordColumnUpdates
         *        A list of <code>RecordColumn</code> objects. Each object describes the mapping of the streaming source
         *        element to the corresponding column in the in-application stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordColumnUpdates(Collection<RecordColumn> recordColumnUpdates);

        /**
         * <p>
         * A list of <code>RecordColumn</code> objects. Each object describes the mapping of the streaming source
         * element to the corresponding column in the in-application stream.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setRecordColumnUpdates(java.util.Collection)} or
         * {@link #withRecordColumnUpdates(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param recordColumnUpdates
         *        A list of <code>RecordColumn</code> objects. Each object describes the mapping of the streaming source
         *        element to the corresponding column in the in-application stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordColumnUpdates(RecordColumn... recordColumnUpdates);
    }

    private static final class BuilderImpl implements Builder {
        private RecordFormat recordFormatUpdate;

        private String recordEncodingUpdate;

        private List<RecordColumn> recordColumnUpdates;

        private BuilderImpl() {
        }

        private BuilderImpl(InputSchemaUpdate model) {
            setRecordFormatUpdate(model.recordFormatUpdate);
            setRecordEncodingUpdate(model.recordEncodingUpdate);
            setRecordColumnUpdates(model.recordColumnUpdates);
        }

        public final RecordFormat getRecordFormatUpdate() {
            return recordFormatUpdate;
        }

        @Override
        public final Builder recordFormatUpdate(RecordFormat recordFormatUpdate) {
            this.recordFormatUpdate = recordFormatUpdate;
            return this;
        }

        public final void setRecordFormatUpdate(RecordFormat recordFormatUpdate) {
            this.recordFormatUpdate = recordFormatUpdate;
        }

        public final String getRecordEncodingUpdate() {
            return recordEncodingUpdate;
        }

        @Override
        public final Builder recordEncodingUpdate(String recordEncodingUpdate) {
            this.recordEncodingUpdate = recordEncodingUpdate;
            return this;
        }

        public final void setRecordEncodingUpdate(String recordEncodingUpdate) {
            this.recordEncodingUpdate = recordEncodingUpdate;
        }

        public final Collection<RecordColumn> getRecordColumnUpdates() {
            return recordColumnUpdates;
        }

        @Override
        public final Builder recordColumnUpdates(Collection<RecordColumn> recordColumnUpdates) {
            this.recordColumnUpdates = RecordColumnsCopier.copy(recordColumnUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordColumnUpdates(RecordColumn... recordColumnUpdates) {
            if (this.recordColumnUpdates == null) {
                this.recordColumnUpdates = new ArrayList<>(recordColumnUpdates.length);
            }
            for (RecordColumn e : recordColumnUpdates) {
                this.recordColumnUpdates.add(e);
            }
            return this;
        }

        public final void setRecordColumnUpdates(Collection<RecordColumn> recordColumnUpdates) {
            this.recordColumnUpdates = RecordColumnsCopier.copy(recordColumnUpdates);
        }

        @SafeVarargs
        public final void setRecordColumnUpdates(RecordColumn... recordColumnUpdates) {
            if (this.recordColumnUpdates == null) {
                this.recordColumnUpdates = new ArrayList<>(recordColumnUpdates.length);
            }
            for (RecordColumn e : recordColumnUpdates) {
                this.recordColumnUpdates.add(e);
            }
        }

        @Override
        public InputSchemaUpdate build() {
            return new InputSchemaUpdate(this);
        }
    }
}
