/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.KinesisStreamsInputMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies an Amazon Kinesis stream as the streaming source. You provide the stream's ARN and an IAM role ARN that
 * enables Amazon Kinesis Analytics to access the stream on your behalf.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class KinesisStreamsInput implements StructuredPojo, ToCopyableBuilder<KinesisStreamsInput.Builder, KinesisStreamsInput> {
    private final String resourceARN;

    private final String roleARN;

    private KinesisStreamsInput(BuilderImpl builder) {
        this.resourceARN = builder.resourceARN;
        this.roleARN = builder.roleARN;
    }

    /**
     * <p>
     * ARN of the input Amazon Kinesis stream to read.
     * </p>
     * 
     * @return ARN of the input Amazon Kinesis stream to read.
     */
    public String resourceARN() {
        return resourceARN;
    }

    /**
     * <p>
     * ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to
     * grant the necessary permissions to this role.
     * </p>
     * 
     * @return ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You
     *         need to grant the necessary permissions to this role.
     */
    public String roleARN() {
        return roleARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((resourceARN() == null) ? 0 : resourceARN().hashCode());
        hashCode = 31 * hashCode + ((roleARN() == null) ? 0 : roleARN().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisStreamsInput)) {
            return false;
        }
        KinesisStreamsInput other = (KinesisStreamsInput) obj;
        if (other.resourceARN() == null ^ this.resourceARN() == null) {
            return false;
        }
        if (other.resourceARN() != null && !other.resourceARN().equals(this.resourceARN())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (resourceARN() != null) {
            sb.append("ResourceARN: ").append(resourceARN()).append(",");
        }
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KinesisStreamsInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, KinesisStreamsInput> {
        /**
         * <p>
         * ARN of the input Amazon Kinesis stream to read.
         * </p>
         * 
         * @param resourceARN
         *        ARN of the input Amazon Kinesis stream to read.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceARN(String resourceARN);

        /**
         * <p>
         * ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to
         * grant the necessary permissions to this role.
         * </p>
         * 
         * @param roleARN
         *        ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You
         *        need to grant the necessary permissions to this role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);
    }

    private static final class BuilderImpl implements Builder {
        private String resourceARN;

        private String roleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisStreamsInput model) {
            setResourceARN(model.resourceARN);
            setRoleARN(model.roleARN);
        }

        public final String getResourceARN() {
            return resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public KinesisStreamsInput build() {
            return new KinesisStreamsInput(this);
        }
    }
}
