/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.KinesisStreamsOutputUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When updating an output configuration using the <a>UpdateApplication</a> operation, provides information about an
 * Amazon Kinesis stream configured as the destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class KinesisStreamsOutputUpdate implements StructuredPojo,
        ToCopyableBuilder<KinesisStreamsOutputUpdate.Builder, KinesisStreamsOutputUpdate> {
    private final String resourceARNUpdate;

    private final String roleARNUpdate;

    private KinesisStreamsOutputUpdate(BuilderImpl builder) {
        this.resourceARNUpdate = builder.resourceARNUpdate;
        this.roleARNUpdate = builder.roleARNUpdate;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the Amazon Kinesis stream where you want to write the output.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the Amazon Kinesis stream where you want to write the output.
     */
    public String resourceARNUpdate() {
        return resourceARNUpdate;
    }

    /**
     * <p>
     * ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to
     * grant the necessary permissions to this role.
     * </p>
     * 
     * @return ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You
     *         need to grant the necessary permissions to this role.
     */
    public String roleARNUpdate() {
        return roleARNUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((resourceARNUpdate() == null) ? 0 : resourceARNUpdate().hashCode());
        hashCode = 31 * hashCode + ((roleARNUpdate() == null) ? 0 : roleARNUpdate().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisStreamsOutputUpdate)) {
            return false;
        }
        KinesisStreamsOutputUpdate other = (KinesisStreamsOutputUpdate) obj;
        if (other.resourceARNUpdate() == null ^ this.resourceARNUpdate() == null) {
            return false;
        }
        if (other.resourceARNUpdate() != null && !other.resourceARNUpdate().equals(this.resourceARNUpdate())) {
            return false;
        }
        if (other.roleARNUpdate() == null ^ this.roleARNUpdate() == null) {
            return false;
        }
        if (other.roleARNUpdate() != null && !other.roleARNUpdate().equals(this.roleARNUpdate())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (resourceARNUpdate() != null) {
            sb.append("ResourceARNUpdate: ").append(resourceARNUpdate()).append(",");
        }
        if (roleARNUpdate() != null) {
            sb.append("RoleARNUpdate: ").append(roleARNUpdate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KinesisStreamsOutputUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, KinesisStreamsOutputUpdate> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the Amazon Kinesis stream where you want to write the output.
         * </p>
         * 
         * @param resourceARNUpdate
         *        Amazon Resource Name (ARN) of the Amazon Kinesis stream where you want to write the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceARNUpdate(String resourceARNUpdate);

        /**
         * <p>
         * ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to
         * grant the necessary permissions to this role.
         * </p>
         * 
         * @param roleARNUpdate
         *        ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You
         *        need to grant the necessary permissions to this role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARNUpdate(String roleARNUpdate);
    }

    private static final class BuilderImpl implements Builder {
        private String resourceARNUpdate;

        private String roleARNUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisStreamsOutputUpdate model) {
            setResourceARNUpdate(model.resourceARNUpdate);
            setRoleARNUpdate(model.roleARNUpdate);
        }

        public final String getResourceARNUpdate() {
            return resourceARNUpdate;
        }

        @Override
        public final Builder resourceARNUpdate(String resourceARNUpdate) {
            this.resourceARNUpdate = resourceARNUpdate;
            return this;
        }

        public final void setResourceARNUpdate(String resourceARNUpdate) {
            this.resourceARNUpdate = resourceARNUpdate;
        }

        public final String getRoleARNUpdate() {
            return roleARNUpdate;
        }

        @Override
        public final Builder roleARNUpdate(String roleARNUpdate) {
            this.roleARNUpdate = roleARNUpdate;
            return this;
        }

        public final void setRoleARNUpdate(String roleARNUpdate) {
            this.roleARNUpdate = roleARNUpdate;
        }

        @Override
        public KinesisStreamsOutputUpdate build() {
            return new KinesisStreamsOutputUpdate(this);
        }
    }
}
