/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListApplicationsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListApplicationsRequest.Builder, ListApplicationsRequest> {
    private final Integer limit;

    private final String exclusiveStartApplicationName;

    private ListApplicationsRequest(BuilderImpl builder) {
        this.limit = builder.limit;
        this.exclusiveStartApplicationName = builder.exclusiveStartApplicationName;
    }

    /**
     * <p>
     * Maximum number of applications to list.
     * </p>
     * 
     * @return Maximum number of applications to list.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * Name of the application to start the list with. When using pagination to retrieve the list, you don't need to
     * specify this parameter in the first request. However, in subsequent requests, you add the last application name
     * from the previous response to get the next page of applications.
     * </p>
     * 
     * @return Name of the application to start the list with. When using pagination to retrieve the list, you don't
     *         need to specify this parameter in the first request. However, in subsequent requests, you add the last
     *         application name from the previous response to get the next page of applications.
     */
    public String exclusiveStartApplicationName() {
        return exclusiveStartApplicationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((limit() == null) ? 0 : limit().hashCode());
        hashCode = 31 * hashCode + ((exclusiveStartApplicationName() == null) ? 0 : exclusiveStartApplicationName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationsRequest)) {
            return false;
        }
        ListApplicationsRequest other = (ListApplicationsRequest) obj;
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.exclusiveStartApplicationName() == null ^ this.exclusiveStartApplicationName() == null) {
            return false;
        }
        if (other.exclusiveStartApplicationName() != null
                && !other.exclusiveStartApplicationName().equals(this.exclusiveStartApplicationName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        if (exclusiveStartApplicationName() != null) {
            sb.append("ExclusiveStartApplicationName: ").append(exclusiveStartApplicationName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListApplicationsRequest> {
        /**
         * <p>
         * Maximum number of applications to list.
         * </p>
         * 
         * @param limit
         *        Maximum number of applications to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * Name of the application to start the list with. When using pagination to retrieve the list, you don't need to
         * specify this parameter in the first request. However, in subsequent requests, you add the last application
         * name from the previous response to get the next page of applications.
         * </p>
         * 
         * @param exclusiveStartApplicationName
         *        Name of the application to start the list with. When using pagination to retrieve the list, you don't
         *        need to specify this parameter in the first request. However, in subsequent requests, you add the last
         *        application name from the previous response to get the next page of applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartApplicationName(String exclusiveStartApplicationName);
    }

    private static final class BuilderImpl implements Builder {
        private Integer limit;

        private String exclusiveStartApplicationName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationsRequest model) {
            setLimit(model.limit);
            setExclusiveStartApplicationName(model.exclusiveStartApplicationName);
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getExclusiveStartApplicationName() {
            return exclusiveStartApplicationName;
        }

        @Override
        public final Builder exclusiveStartApplicationName(String exclusiveStartApplicationName) {
            this.exclusiveStartApplicationName = exclusiveStartApplicationName;
            return this;
        }

        public final void setExclusiveStartApplicationName(String exclusiveStartApplicationName) {
            this.exclusiveStartApplicationName = exclusiveStartApplicationName;
        }

        @Override
        public ListApplicationsRequest build() {
            return new ListApplicationsRequest(this);
        }
    }
}
