/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.RecordFormatMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the record format and relevant mapping information that should be applied to schematize the records on the
 * stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RecordFormat implements StructuredPojo, ToCopyableBuilder<RecordFormat.Builder, RecordFormat> {
    private final String recordFormatType;

    private final MappingParameters mappingParameters;

    private RecordFormat(BuilderImpl builder) {
        this.recordFormatType = builder.recordFormatType;
        this.mappingParameters = builder.mappingParameters;
    }

    /**
     * <p>
     * The type of record format.
     * </p>
     * 
     * @return The type of record format.
     * @see RecordFormatType
     */
    public String recordFormatType() {
        return recordFormatType;
    }

    /**
     *
     * @return
     */
    public MappingParameters mappingParameters() {
        return mappingParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((recordFormatType() == null) ? 0 : recordFormatType().hashCode());
        hashCode = 31 * hashCode + ((mappingParameters() == null) ? 0 : mappingParameters().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordFormat)) {
            return false;
        }
        RecordFormat other = (RecordFormat) obj;
        if (other.recordFormatType() == null ^ this.recordFormatType() == null) {
            return false;
        }
        if (other.recordFormatType() != null && !other.recordFormatType().equals(this.recordFormatType())) {
            return false;
        }
        if (other.mappingParameters() == null ^ this.mappingParameters() == null) {
            return false;
        }
        if (other.mappingParameters() != null && !other.mappingParameters().equals(this.mappingParameters())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (recordFormatType() != null) {
            sb.append("RecordFormatType: ").append(recordFormatType()).append(",");
        }
        if (mappingParameters() != null) {
            sb.append("MappingParameters: ").append(mappingParameters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordFormatMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RecordFormat> {
        /**
         * <p>
         * The type of record format.
         * </p>
         * 
         * @param recordFormatType
         *        The type of record format.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordFormatType
         */
        Builder recordFormatType(String recordFormatType);

        /**
         * <p>
         * The type of record format.
         * </p>
         * 
         * @param recordFormatType
         *        The type of record format.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordFormatType
         */
        Builder recordFormatType(RecordFormatType recordFormatType);

        /**
         *
         * @param mappingParameters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappingParameters(MappingParameters mappingParameters);
    }

    private static final class BuilderImpl implements Builder {
        private String recordFormatType;

        private MappingParameters mappingParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordFormat model) {
            setRecordFormatType(model.recordFormatType);
            setMappingParameters(model.mappingParameters);
        }

        public final String getRecordFormatType() {
            return recordFormatType;
        }

        @Override
        public final Builder recordFormatType(String recordFormatType) {
            this.recordFormatType = recordFormatType;
            return this;
        }

        @Override
        public final Builder recordFormatType(RecordFormatType recordFormatType) {
            this.recordFormatType(recordFormatType.toString());
            return this;
        }

        public final void setRecordFormatType(String recordFormatType) {
            this.recordFormatType = recordFormatType;
        }

        public final void setRecordFormatType(RecordFormatType recordFormatType) {
            this.recordFormatType(recordFormatType.toString());
        }

        public final MappingParameters getMappingParameters() {
            return mappingParameters;
        }

        @Override
        public final Builder mappingParameters(MappingParameters mappingParameters) {
            this.mappingParameters = mappingParameters;
            return this;
        }

        public final void setMappingParameters(MappingParameters mappingParameters) {
            this.mappingParameters = mappingParameters;
        }

        @Override
        public RecordFormat build() {
            return new RecordFormat(this);
        }
    }
}
