/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.ReferenceDataSourceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the reference data source by providing the source information (S3 bucket name and object key name), the
 * resulting in-application table name that is created, and the necessary schema to map the data elements in the Amazon
 * S3 object to the in-application table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReferenceDataSource implements StructuredPojo, ToCopyableBuilder<ReferenceDataSource.Builder, ReferenceDataSource> {
    private final String tableName;

    private final S3ReferenceDataSource s3ReferenceDataSource;

    private final SourceSchema referenceSchema;

    private ReferenceDataSource(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.s3ReferenceDataSource = builder.s3ReferenceDataSource;
        this.referenceSchema = builder.referenceSchema;
    }

    /**
     * <p>
     * Name of the in-application table to create.
     * </p>
     * 
     * @return Name of the in-application table to create.
     */
    public String tableName() {
        return tableName;
    }

    /**
     *
     * @return
     */
    public S3ReferenceDataSource s3ReferenceDataSource() {
        return s3ReferenceDataSource;
    }

    /**
     *
     * @return
     */
    public SourceSchema referenceSchema() {
        return referenceSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((tableName() == null) ? 0 : tableName().hashCode());
        hashCode = 31 * hashCode + ((s3ReferenceDataSource() == null) ? 0 : s3ReferenceDataSource().hashCode());
        hashCode = 31 * hashCode + ((referenceSchema() == null) ? 0 : referenceSchema().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceDataSource)) {
            return false;
        }
        ReferenceDataSource other = (ReferenceDataSource) obj;
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        if (other.s3ReferenceDataSource() == null ^ this.s3ReferenceDataSource() == null) {
            return false;
        }
        if (other.s3ReferenceDataSource() != null && !other.s3ReferenceDataSource().equals(this.s3ReferenceDataSource())) {
            return false;
        }
        if (other.referenceSchema() == null ^ this.referenceSchema() == null) {
            return false;
        }
        if (other.referenceSchema() != null && !other.referenceSchema().equals(this.referenceSchema())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (tableName() != null) {
            sb.append("TableName: ").append(tableName()).append(",");
        }
        if (s3ReferenceDataSource() != null) {
            sb.append("S3ReferenceDataSource: ").append(s3ReferenceDataSource()).append(",");
        }
        if (referenceSchema() != null) {
            sb.append("ReferenceSchema: ").append(referenceSchema()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReferenceDataSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ReferenceDataSource> {
        /**
         * <p>
         * Name of the in-application table to create.
         * </p>
         * 
         * @param tableName
         *        Name of the in-application table to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         *
         * @param s3ReferenceDataSource
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ReferenceDataSource(S3ReferenceDataSource s3ReferenceDataSource);

        /**
         *
         * @param referenceSchema
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceSchema(SourceSchema referenceSchema);
    }

    private static final class BuilderImpl implements Builder {
        private String tableName;

        private S3ReferenceDataSource s3ReferenceDataSource;

        private SourceSchema referenceSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceDataSource model) {
            setTableName(model.tableName);
            setS3ReferenceDataSource(model.s3ReferenceDataSource);
            setReferenceSchema(model.referenceSchema);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final S3ReferenceDataSource getS3ReferenceDataSource() {
            return s3ReferenceDataSource;
        }

        @Override
        public final Builder s3ReferenceDataSource(S3ReferenceDataSource s3ReferenceDataSource) {
            this.s3ReferenceDataSource = s3ReferenceDataSource;
            return this;
        }

        public final void setS3ReferenceDataSource(S3ReferenceDataSource s3ReferenceDataSource) {
            this.s3ReferenceDataSource = s3ReferenceDataSource;
        }

        public final SourceSchema getReferenceSchema() {
            return referenceSchema;
        }

        @Override
        public final Builder referenceSchema(SourceSchema referenceSchema) {
            this.referenceSchema = referenceSchema;
            return this;
        }

        public final void setReferenceSchema(SourceSchema referenceSchema) {
            this.referenceSchema = referenceSchema;
        }

        @Override
        public ReferenceDataSource build() {
            return new ReferenceDataSource(this);
        }
    }
}
