/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.S3ReferenceDataSourceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies the S3 bucket and object that contains the reference data. Also identifies the IAM role Amazon Kinesis
 * Analytics can assume to read this object on your behalf.
 * </p>
 * <p>
 * An Amazon Kinesis Analytics application loads reference data only once. If the data changes, you call the
 * <a>UpdateApplication</a> operation to trigger reloading of data into your application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class S3ReferenceDataSource implements StructuredPojo,
        ToCopyableBuilder<S3ReferenceDataSource.Builder, S3ReferenceDataSource> {
    private final String bucketARN;

    private final String fileKey;

    private final String referenceRoleARN;

    private S3ReferenceDataSource(BuilderImpl builder) {
        this.bucketARN = builder.bucketARN;
        this.fileKey = builder.fileKey;
        this.referenceRoleARN = builder.referenceRoleARN;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the S3 bucket.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the S3 bucket.
     */
    public String bucketARN() {
        return bucketARN;
    }

    /**
     * <p>
     * Object key name containing reference data.
     * </p>
     * 
     * @return Object key name containing reference data.
     */
    public String fileKey() {
        return fileKey;
    }

    /**
     * <p>
     * ARN of the IAM role that the service can assume to read data on your behalf. This role must have permission for
     * the <code>s3:GetObject</code> action on the object and trust policy that allows Amazon Kinesis Analytics service
     * principal to assume this role.
     * </p>
     * 
     * @return ARN of the IAM role that the service can assume to read data on your behalf. This role must have
     *         permission for the <code>s3:GetObject</code> action on the object and trust policy that allows Amazon
     *         Kinesis Analytics service principal to assume this role.
     */
    public String referenceRoleARN() {
        return referenceRoleARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bucketARN() == null) ? 0 : bucketARN().hashCode());
        hashCode = 31 * hashCode + ((fileKey() == null) ? 0 : fileKey().hashCode());
        hashCode = 31 * hashCode + ((referenceRoleARN() == null) ? 0 : referenceRoleARN().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ReferenceDataSource)) {
            return false;
        }
        S3ReferenceDataSource other = (S3ReferenceDataSource) obj;
        if (other.bucketARN() == null ^ this.bucketARN() == null) {
            return false;
        }
        if (other.bucketARN() != null && !other.bucketARN().equals(this.bucketARN())) {
            return false;
        }
        if (other.fileKey() == null ^ this.fileKey() == null) {
            return false;
        }
        if (other.fileKey() != null && !other.fileKey().equals(this.fileKey())) {
            return false;
        }
        if (other.referenceRoleARN() == null ^ this.referenceRoleARN() == null) {
            return false;
        }
        if (other.referenceRoleARN() != null && !other.referenceRoleARN().equals(this.referenceRoleARN())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (bucketARN() != null) {
            sb.append("BucketARN: ").append(bucketARN()).append(",");
        }
        if (fileKey() != null) {
            sb.append("FileKey: ").append(fileKey()).append(",");
        }
        if (referenceRoleARN() != null) {
            sb.append("ReferenceRoleARN: ").append(referenceRoleARN()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ReferenceDataSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, S3ReferenceDataSource> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the S3 bucket.
         * </p>
         * 
         * @param bucketARN
         *        Amazon Resource Name (ARN) of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketARN(String bucketARN);

        /**
         * <p>
         * Object key name containing reference data.
         * </p>
         * 
         * @param fileKey
         *        Object key name containing reference data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileKey(String fileKey);

        /**
         * <p>
         * ARN of the IAM role that the service can assume to read data on your behalf. This role must have permission
         * for the <code>s3:GetObject</code> action on the object and trust policy that allows Amazon Kinesis Analytics
         * service principal to assume this role.
         * </p>
         * 
         * @param referenceRoleARN
         *        ARN of the IAM role that the service can assume to read data on your behalf. This role must have
         *        permission for the <code>s3:GetObject</code> action on the object and trust policy that allows Amazon
         *        Kinesis Analytics service principal to assume this role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceRoleARN(String referenceRoleARN);
    }

    private static final class BuilderImpl implements Builder {
        private String bucketARN;

        private String fileKey;

        private String referenceRoleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ReferenceDataSource model) {
            setBucketARN(model.bucketARN);
            setFileKey(model.fileKey);
            setReferenceRoleARN(model.referenceRoleARN);
        }

        public final String getBucketARN() {
            return bucketARN;
        }

        @Override
        public final Builder bucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
            return this;
        }

        public final void setBucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
        }

        public final String getFileKey() {
            return fileKey;
        }

        @Override
        public final Builder fileKey(String fileKey) {
            this.fileKey = fileKey;
            return this;
        }

        public final void setFileKey(String fileKey) {
            this.fileKey = fileKey;
        }

        public final String getReferenceRoleARN() {
            return referenceRoleARN;
        }

        @Override
        public final Builder referenceRoleARN(String referenceRoleARN) {
            this.referenceRoleARN = referenceRoleARN;
            return this;
        }

        public final void setReferenceRoleARN(String referenceRoleARN) {
            this.referenceRoleARN = referenceRoleARN;
        }

        @Override
        public S3ReferenceDataSource build() {
            return new S3ReferenceDataSource(this);
        }
    }
}
