/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class StartApplicationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<StartApplicationRequest.Builder, StartApplicationRequest> {
    private final String applicationName;

    private final List<InputConfiguration> inputConfigurations;

    private StartApplicationRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.inputConfigurations = builder.inputConfigurations;
    }

    /**
     * <p>
     * Name of the application.
     * </p>
     * 
     * @return Name of the application.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics starts
     * reading the streaming source associated with the input. You can also specify where in the streaming source you
     * want Amazon Kinesis Analytics to start reading.
     * </p>
     * 
     * @return Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics
     *         starts reading the streaming source associated with the input. You can also specify where in the
     *         streaming source you want Amazon Kinesis Analytics to start reading.
     */
    public List<InputConfiguration> inputConfigurations() {
        return inputConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationName() == null) ? 0 : applicationName().hashCode());
        hashCode = 31 * hashCode + ((inputConfigurations() == null) ? 0 : inputConfigurations().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartApplicationRequest)) {
            return false;
        }
        StartApplicationRequest other = (StartApplicationRequest) obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.inputConfigurations() == null ^ this.inputConfigurations() == null) {
            return false;
        }
        if (other.inputConfigurations() != null && !other.inputConfigurations().equals(this.inputConfigurations())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (inputConfigurations() != null) {
            sb.append("InputConfigurations: ").append(inputConfigurations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, StartApplicationRequest> {
        /**
         * <p>
         * Name of the application.
         * </p>
         * 
         * @param applicationName
         *        Name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics starts
         * reading the streaming source associated with the input. You can also specify where in the streaming source
         * you want Amazon Kinesis Analytics to start reading.
         * </p>
         * 
         * @param inputConfigurations
         *        Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics
         *        starts reading the streaming source associated with the input. You can also specify where in the
         *        streaming source you want Amazon Kinesis Analytics to start reading.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfigurations(Collection<InputConfiguration> inputConfigurations);

        /**
         * <p>
         * Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics starts
         * reading the streaming source associated with the input. You can also specify where in the streaming source
         * you want Amazon Kinesis Analytics to start reading.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setInputConfigurations(java.util.Collection)} or
         * {@link #withInputConfigurations(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param inputConfigurations
         *        Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics
         *        starts reading the streaming source associated with the input. You can also specify where in the
         *        streaming source you want Amazon Kinesis Analytics to start reading.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfigurations(InputConfiguration... inputConfigurations);
    }

    private static final class BuilderImpl implements Builder {
        private String applicationName;

        private List<InputConfiguration> inputConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(StartApplicationRequest model) {
            setApplicationName(model.applicationName);
            setInputConfigurations(model.inputConfigurations);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Collection<InputConfiguration> getInputConfigurations() {
            return inputConfigurations;
        }

        @Override
        public final Builder inputConfigurations(Collection<InputConfiguration> inputConfigurations) {
            this.inputConfigurations = InputConfigurationsCopier.copy(inputConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputConfigurations(InputConfiguration... inputConfigurations) {
            if (this.inputConfigurations == null) {
                this.inputConfigurations = new ArrayList<>(inputConfigurations.length);
            }
            for (InputConfiguration e : inputConfigurations) {
                this.inputConfigurations.add(e);
            }
            return this;
        }

        public final void setInputConfigurations(Collection<InputConfiguration> inputConfigurations) {
            this.inputConfigurations = InputConfigurationsCopier.copy(inputConfigurations);
        }

        @SafeVarargs
        public final void setInputConfigurations(InputConfiguration... inputConfigurations) {
            if (this.inputConfigurations == null) {
                this.inputConfigurations = new ArrayList<>(inputConfigurations.length);
            }
            for (InputConfiguration e : inputConfigurations) {
                this.inputConfigurations.add(e);
            }
        }

        @Override
        public StartApplicationRequest build() {
            return new StartApplicationRequest(this);
        }
    }
}
