/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data format is not valid, Amazon Kinesis Analytics is not able to detect schema for the given streaming source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UnableToDetectSchemaException extends KinesisAnalyticsException implements
        ToCopyableBuilder<UnableToDetectSchemaException.Builder, UnableToDetectSchemaException> {
    private final List<String> rawInputRecords;

    private UnableToDetectSchemaException(BuilderImpl builder) {
        super(builder.message);
        this.rawInputRecords = builder.rawInputRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     *
     * @return
     */
    public List<String> rawInputRecords() {
        return rawInputRecords;
    }

    public interface Builder extends CopyableBuilder<Builder, UnableToDetectSchemaException> {
        /**
         *
         * @param rawInputRecords
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawInputRecords(Collection<String> rawInputRecords);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setRawInputRecords(java.util.Collection)} or {@link #withRawInputRecords(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param rawInputRecords
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawInputRecords(String... rawInputRecords);

        Builder message(String message);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> rawInputRecords;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(UnableToDetectSchemaException model) {
            setRawInputRecords(model.rawInputRecords);
            this.message = model.getMessage();
        }

        public final Collection<String> getRawInputRecords() {
            return rawInputRecords;
        }

        @Override
        public final Builder rawInputRecords(Collection<String> rawInputRecords) {
            this.rawInputRecords = RawInputRecordsCopier.copy(rawInputRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rawInputRecords(String... rawInputRecords) {
            if (this.rawInputRecords == null) {
                this.rawInputRecords = new ArrayList<>(rawInputRecords.length);
            }
            for (String e : rawInputRecords) {
                this.rawInputRecords.add(e);
            }
            return this;
        }

        @JsonProperty("RawInputRecords")
        public final void setRawInputRecords(Collection<String> rawInputRecords) {
            this.rawInputRecords = RawInputRecordsCopier.copy(rawInputRecords);
        }

        @SafeVarargs
        public final void setRawInputRecords(String... rawInputRecords) {
            if (this.rawInputRecords == null) {
                this.rawInputRecords = new ArrayList<>(rawInputRecords.length);
            }
            for (String e : rawInputRecords) {
                this.rawInputRecords.add(e);
            }
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public UnableToDetectSchemaException build() {
            return new UnableToDetectSchemaException(this);
        }
    }
}
