/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateApplicationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateApplicationRequest.Builder, UpdateApplicationRequest> {
    private final String applicationName;

    private final Long currentApplicationVersionId;

    private final ApplicationUpdate applicationUpdate;

    private UpdateApplicationRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.applicationUpdate = builder.applicationUpdate;
    }

    /**
     * <p>
     * Name of the Amazon Kinesis Analytics application to update.
     * </p>
     * 
     * @return Name of the Amazon Kinesis Analytics application to update.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The current application version ID. You can use the <a>DescribeApplication</a> operation to get this value.
     * </p>
     * 
     * @return The current application version ID. You can use the <a>DescribeApplication</a> operation to get this
     *         value.
     */
    public Long currentApplicationVersionId() {
        return currentApplicationVersionId;
    }

    /**
     * <p>
     * Describes application updates.
     * </p>
     * 
     * @return Describes application updates.
     */
    public ApplicationUpdate applicationUpdate() {
        return applicationUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationName() == null) ? 0 : applicationName().hashCode());
        hashCode = 31 * hashCode + ((currentApplicationVersionId() == null) ? 0 : currentApplicationVersionId().hashCode());
        hashCode = 31 * hashCode + ((applicationUpdate() == null) ? 0 : applicationUpdate().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest) obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.currentApplicationVersionId() == null ^ this.currentApplicationVersionId() == null) {
            return false;
        }
        if (other.currentApplicationVersionId() != null
                && !other.currentApplicationVersionId().equals(this.currentApplicationVersionId())) {
            return false;
        }
        if (other.applicationUpdate() == null ^ this.applicationUpdate() == null) {
            return false;
        }
        if (other.applicationUpdate() != null && !other.applicationUpdate().equals(this.applicationUpdate())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (currentApplicationVersionId() != null) {
            sb.append("CurrentApplicationVersionId: ").append(currentApplicationVersionId()).append(",");
        }
        if (applicationUpdate() != null) {
            sb.append("ApplicationUpdate: ").append(applicationUpdate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateApplicationRequest> {
        /**
         * <p>
         * Name of the Amazon Kinesis Analytics application to update.
         * </p>
         * 
         * @param applicationName
         *        Name of the Amazon Kinesis Analytics application to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The current application version ID. You can use the <a>DescribeApplication</a> operation to get this value.
         * </p>
         * 
         * @param currentApplicationVersionId
         *        The current application version ID. You can use the <a>DescribeApplication</a> operation to get this
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplicationVersionId(Long currentApplicationVersionId);

        /**
         * <p>
         * Describes application updates.
         * </p>
         * 
         * @param applicationUpdate
         *        Describes application updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationUpdate(ApplicationUpdate applicationUpdate);
    }

    private static final class BuilderImpl implements Builder {
        private String applicationName;

        private Long currentApplicationVersionId;

        private ApplicationUpdate applicationUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            setApplicationName(model.applicationName);
            setCurrentApplicationVersionId(model.currentApplicationVersionId);
            setApplicationUpdate(model.applicationUpdate);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final ApplicationUpdate getApplicationUpdate() {
            return applicationUpdate;
        }

        @Override
        public final Builder applicationUpdate(ApplicationUpdate applicationUpdate) {
            this.applicationUpdate = applicationUpdate;
            return this;
        }

        public final void setApplicationUpdate(ApplicationUpdate applicationUpdate) {
            this.applicationUpdate = applicationUpdate;
        }

        @Override
        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }
    }
}
