/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.kinesisanalytics.model.*;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * CSVMappingParametersMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class CSVMappingParametersMarshaller {

    private static final MarshallingInfo<String> RECORDROWDELIMITER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordRowDelimiter").build();
    private static final MarshallingInfo<String> RECORDCOLUMNDELIMITER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordColumnDelimiter").build();

    private static final CSVMappingParametersMarshaller instance = new CSVMappingParametersMarshaller();

    public static CSVMappingParametersMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(CSVMappingParameters csvMappingParameters, ProtocolMarshaller protocolMarshaller) {

        if (csvMappingParameters == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(csvMappingParameters.recordRowDelimiter(), RECORDROWDELIMITER_BINDING);
            protocolMarshaller.marshall(csvMappingParameters.recordColumnDelimiter(), RECORDCOLUMNDELIMITER_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
