/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.kinesisanalytics.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Input JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class InputUnmarshaller implements Unmarshaller<Input, JsonUnmarshallerContext> {

    public Input unmarshall(JsonUnmarshallerContext context) throws Exception {
        Input.Builder inputBuilder = Input.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("NamePrefix", targetDepth)) {
                    context.nextToken();
                    inputBuilder.namePrefix(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("KinesisStreamsInput", targetDepth)) {
                    context.nextToken();
                    inputBuilder.kinesisStreamsInput(KinesisStreamsInputUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("KinesisFirehoseInput", targetDepth)) {
                    context.nextToken();
                    inputBuilder.kinesisFirehoseInput(KinesisFirehoseInputUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("InputParallelism", targetDepth)) {
                    context.nextToken();
                    inputBuilder.inputParallelism(InputParallelismUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("InputSchema", targetDepth)) {
                    context.nextToken();
                    inputBuilder.inputSchema(SourceSchemaUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return inputBuilder.build();
    }

    private static InputUnmarshaller INSTANCE;

    public static InputUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new InputUnmarshaller();
        return INSTANCE;
    }
}