/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.ElasticsearchBufferingHintsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ElasticsearchBufferingHints
implements StructuredPojo,
ToCopyableBuilder<Builder, ElasticsearchBufferingHints> {
    private final Integer intervalInSeconds;
    private final Integer sizeInMBs;

    private ElasticsearchBufferingHints(BuilderImpl builder) {
        this.intervalInSeconds = builder.intervalInSeconds;
        this.sizeInMBs = builder.sizeInMBs;
    }

    public Integer intervalInSeconds() {
        return this.intervalInSeconds;
    }

    public Integer sizeInMBs() {
        return this.sizeInMBs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.intervalInSeconds() == null ? 0 : this.intervalInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.sizeInMBs() == null ? 0 : this.sizeInMBs().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchBufferingHints)) {
            return false;
        }
        ElasticsearchBufferingHints other = (ElasticsearchBufferingHints)obj;
        if (other.intervalInSeconds() == null ^ this.intervalInSeconds() == null) {
            return false;
        }
        if (other.intervalInSeconds() != null && !other.intervalInSeconds().equals(this.intervalInSeconds())) {
            return false;
        }
        if (other.sizeInMBs() == null ^ this.sizeInMBs() == null) {
            return false;
        }
        return other.sizeInMBs() == null || other.sizeInMBs().equals(this.sizeInMBs());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.intervalInSeconds() != null) {
            sb.append("IntervalInSeconds: ").append(this.intervalInSeconds()).append(",");
        }
        if (this.sizeInMBs() != null) {
            sb.append("SizeInMBs: ").append(this.sizeInMBs()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ElasticsearchBufferingHintsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer intervalInSeconds;
        private Integer sizeInMBs;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchBufferingHints model) {
            this.setIntervalInSeconds(model.intervalInSeconds);
            this.setSizeInMBs(model.sizeInMBs);
        }

        public final Integer getIntervalInSeconds() {
            return this.intervalInSeconds;
        }

        @Override
        public final Builder intervalInSeconds(Integer intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
            return this;
        }

        public final void setIntervalInSeconds(Integer intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
        }

        public final Integer getSizeInMBs() {
            return this.sizeInMBs;
        }

        @Override
        public final Builder sizeInMBs(Integer sizeInMBs) {
            this.sizeInMBs = sizeInMBs;
            return this;
        }

        public final void setSizeInMBs(Integer sizeInMBs) {
            this.sizeInMBs = sizeInMBs;
        }

        public ElasticsearchBufferingHints build() {
            return new ElasticsearchBufferingHints(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ElasticsearchBufferingHints> {
        public Builder intervalInSeconds(Integer var1);

        public Builder sizeInMBs(Integer var1);
    }
}

