/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchRequestEntryListCopier;
import software.amazon.awssdk.services.firehose.model.Record;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutRecordBatchRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutRecordBatchRequest> {
    private final String deliveryStreamName;
    private final List<Record> records;

    private PutRecordBatchRequest(BuilderImpl builder) {
        this.deliveryStreamName = builder.deliveryStreamName;
        this.records = builder.records;
    }

    public String deliveryStreamName() {
        return this.deliveryStreamName;
    }

    public List<Record> records() {
        return this.records;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deliveryStreamName() == null ? 0 : this.deliveryStreamName().hashCode());
        hashCode = 31 * hashCode + (this.records() == null ? 0 : this.records().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordBatchRequest)) {
            return false;
        }
        PutRecordBatchRequest other = (PutRecordBatchRequest)((Object)obj);
        if (other.deliveryStreamName() == null ^ this.deliveryStreamName() == null) {
            return false;
        }
        if (other.deliveryStreamName() != null && !other.deliveryStreamName().equals(this.deliveryStreamName())) {
            return false;
        }
        if (other.records() == null ^ this.records() == null) {
            return false;
        }
        return other.records() == null || other.records().equals(this.records());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deliveryStreamName() != null) {
            sb.append("DeliveryStreamName: ").append(this.deliveryStreamName()).append(",");
        }
        if (this.records() != null) {
            sb.append("Records: ").append(this.records()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String deliveryStreamName;
        private List<Record> records;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordBatchRequest model) {
            this.setDeliveryStreamName(model.deliveryStreamName);
            this.setRecords(model.records);
        }

        public final String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final Collection<Record> getRecords() {
            return this.records;
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = PutRecordBatchRequestEntryListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record ... records) {
            if (this.records == null) {
                this.records = new ArrayList<Record>(records.length);
            }
            for (Record e : records) {
                this.records.add(e);
            }
            return this;
        }

        public final void setRecords(Collection<Record> records) {
            this.records = PutRecordBatchRequestEntryListCopier.copy(records);
        }

        @SafeVarargs
        public final void setRecords(Record ... records) {
            if (this.records == null) {
                this.records = new ArrayList<Record>(records.length);
            }
            for (Record e : records) {
                this.records.add(e);
            }
        }

        public PutRecordBatchRequest build() {
            return new PutRecordBatchRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutRecordBatchRequest> {
        public Builder deliveryStreamName(String var1);

        public Builder records(Collection<Record> var1);

        public Builder records(Record ... var1);
    }
}

