/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchResponseEntry;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchResponseEntryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutRecordBatchResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, PutRecordBatchResponse> {
    private final Integer failedPutCount;
    private final List<PutRecordBatchResponseEntry> requestResponses;

    private PutRecordBatchResponse(BuilderImpl builder) {
        this.failedPutCount = builder.failedPutCount;
        this.requestResponses = builder.requestResponses;
    }

    public Integer failedPutCount() {
        return this.failedPutCount;
    }

    public List<PutRecordBatchResponseEntry> requestResponses() {
        return this.requestResponses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.failedPutCount() == null ? 0 : this.failedPutCount().hashCode());
        hashCode = 31 * hashCode + (this.requestResponses() == null ? 0 : this.requestResponses().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordBatchResponse)) {
            return false;
        }
        PutRecordBatchResponse other = (PutRecordBatchResponse)((Object)obj);
        if (other.failedPutCount() == null ^ this.failedPutCount() == null) {
            return false;
        }
        if (other.failedPutCount() != null && !other.failedPutCount().equals(this.failedPutCount())) {
            return false;
        }
        if (other.requestResponses() == null ^ this.requestResponses() == null) {
            return false;
        }
        return other.requestResponses() == null || other.requestResponses().equals(this.requestResponses());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.failedPutCount() != null) {
            sb.append("FailedPutCount: ").append(this.failedPutCount()).append(",");
        }
        if (this.requestResponses() != null) {
            sb.append("RequestResponses: ").append(this.requestResponses()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer failedPutCount;
        private List<PutRecordBatchResponseEntry> requestResponses;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordBatchResponse model) {
            this.setFailedPutCount(model.failedPutCount);
            this.setRequestResponses(model.requestResponses);
        }

        public final Integer getFailedPutCount() {
            return this.failedPutCount;
        }

        @Override
        public final Builder failedPutCount(Integer failedPutCount) {
            this.failedPutCount = failedPutCount;
            return this;
        }

        public final void setFailedPutCount(Integer failedPutCount) {
            this.failedPutCount = failedPutCount;
        }

        public final Collection<PutRecordBatchResponseEntry> getRequestResponses() {
            return this.requestResponses;
        }

        @Override
        public final Builder requestResponses(Collection<PutRecordBatchResponseEntry> requestResponses) {
            this.requestResponses = PutRecordBatchResponseEntryListCopier.copy(requestResponses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestResponses(PutRecordBatchResponseEntry ... requestResponses) {
            if (this.requestResponses == null) {
                this.requestResponses = new ArrayList<PutRecordBatchResponseEntry>(requestResponses.length);
            }
            for (PutRecordBatchResponseEntry e : requestResponses) {
                this.requestResponses.add(e);
            }
            return this;
        }

        public final void setRequestResponses(Collection<PutRecordBatchResponseEntry> requestResponses) {
            this.requestResponses = PutRecordBatchResponseEntryListCopier.copy(requestResponses);
        }

        @SafeVarargs
        public final void setRequestResponses(PutRecordBatchResponseEntry ... requestResponses) {
            if (this.requestResponses == null) {
                this.requestResponses = new ArrayList<PutRecordBatchResponseEntry>(requestResponses.length);
            }
            for (PutRecordBatchResponseEntry e : requestResponses) {
                this.requestResponses.add(e);
            }
        }

        public PutRecordBatchResponse build() {
            return new PutRecordBatchResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutRecordBatchResponse> {
        public Builder failedPutCount(Integer var1);

        public Builder requestResponses(Collection<PutRecordBatchResponseEntry> var1);

        public Builder requestResponses(PutRecordBatchResponseEntry ... var1);
    }
}

