/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.PutRecordBatchResponseEntryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutRecordBatchResponseEntry
implements StructuredPojo,
ToCopyableBuilder<Builder, PutRecordBatchResponseEntry> {
    private final String recordId;
    private final String errorCode;
    private final String errorMessage;

    private PutRecordBatchResponseEntry(BuilderImpl builder) {
        this.recordId = builder.recordId;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    public String recordId() {
        return this.recordId;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.recordId() == null ? 0 : this.recordId().hashCode());
        hashCode = 31 * hashCode + (this.errorCode() == null ? 0 : this.errorCode().hashCode());
        hashCode = 31 * hashCode + (this.errorMessage() == null ? 0 : this.errorMessage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordBatchResponseEntry)) {
            return false;
        }
        PutRecordBatchResponseEntry other = (PutRecordBatchResponseEntry)obj;
        if (other.recordId() == null ^ this.recordId() == null) {
            return false;
        }
        if (other.recordId() != null && !other.recordId().equals(this.recordId())) {
            return false;
        }
        if (other.errorCode() == null ^ this.errorCode() == null) {
            return false;
        }
        if (other.errorCode() != null && !other.errorCode().equals(this.errorCode())) {
            return false;
        }
        if (other.errorMessage() == null ^ this.errorMessage() == null) {
            return false;
        }
        return other.errorMessage() == null || other.errorMessage().equals(this.errorMessage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.recordId() != null) {
            sb.append("RecordId: ").append(this.recordId()).append(",");
        }
        if (this.errorCode() != null) {
            sb.append("ErrorCode: ").append(this.errorCode()).append(",");
        }
        if (this.errorMessage() != null) {
            sb.append("ErrorMessage: ").append(this.errorMessage()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PutRecordBatchResponseEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String recordId;
        private String errorCode;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordBatchResponseEntry model) {
            this.setRecordId(model.recordId);
            this.setErrorCode(model.errorCode);
            this.setErrorMessage(model.errorMessage);
        }

        public final String getRecordId() {
            return this.recordId;
        }

        @Override
        public final Builder recordId(String recordId) {
            this.recordId = recordId;
            return this;
        }

        public final void setRecordId(String recordId) {
            this.recordId = recordId;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public PutRecordBatchResponseEntry build() {
            return new PutRecordBatchResponseEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutRecordBatchResponseEntry> {
        public Builder recordId(String var1);

        public Builder errorCode(String var1);

        public Builder errorMessage(String var1);
    }
}

