/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import java.util.Date;
import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.DeliveryStreamDescription;

@SdkInternalApi
public class DeliveryStreamDescriptionMarshaller {
    private static final MarshallingInfo<String> DELIVERYSTREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamName").build();
    private static final MarshallingInfo<String> DELIVERYSTREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamARN").build();
    private static final MarshallingInfo<String> DELIVERYSTREAMSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamStatus").build();
    private static final MarshallingInfo<String> VERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionId").build();
    private static final MarshallingInfo<Date> CREATETIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreateTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATETIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdateTimestamp").build();
    private static final MarshallingInfo<List> DESTINATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Destinations").build();
    private static final MarshallingInfo<Boolean> HASMOREDESTINATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HasMoreDestinations").build();
    private static final DeliveryStreamDescriptionMarshaller instance = new DeliveryStreamDescriptionMarshaller();

    public static DeliveryStreamDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(DeliveryStreamDescription deliveryStreamDescription, ProtocolMarshaller protocolMarshaller) {
        if (deliveryStreamDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)deliveryStreamDescription.deliveryStreamName(), DELIVERYSTREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)deliveryStreamDescription.deliveryStreamARN(), DELIVERYSTREAMARN_BINDING);
            protocolMarshaller.marshall((Object)deliveryStreamDescription.deliveryStreamStatus(), DELIVERYSTREAMSTATUS_BINDING);
            protocolMarshaller.marshall((Object)deliveryStreamDescription.versionId(), VERSIONID_BINDING);
            protocolMarshaller.marshall((Object)deliveryStreamDescription.createTimestamp(), CREATETIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)deliveryStreamDescription.lastUpdateTimestamp(), LASTUPDATETIMESTAMP_BINDING);
            protocolMarshaller.marshall(deliveryStreamDescription.destinations(), DESTINATIONS_BINDING);
            protocolMarshaller.marshall((Object)deliveryStreamDescription.hasMoreDestinations(), HASMOREDESTINATIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

