/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.transform.ProcessorUnmarshaller;

public class ProcessingConfigurationUnmarshaller
implements Unmarshaller<ProcessingConfiguration, JsonUnmarshallerContext> {
    private static ProcessingConfigurationUnmarshaller INSTANCE;

    public ProcessingConfiguration unmarshall(JsonUnmarshallerContext context) throws Exception {
        ProcessingConfiguration.Builder processingConfigurationBuilder = ProcessingConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Enabled", targetDepth)) {
                    context.nextToken();
                    processingConfigurationBuilder.enabled((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("Processors", targetDepth)) {
                    context.nextToken();
                    processingConfigurationBuilder.processors(new ListUnmarshaller((Unmarshaller)ProcessorUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ProcessingConfiguration)processingConfigurationBuilder.build();
    }

    public static ProcessingConfigurationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ProcessingConfigurationUnmarshaller();
        }
        return INSTANCE;
    }
}

