/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.kinesis.model.MetricsName;
import software.amazon.awssdk.services.kinesis.model.MetricsNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnableEnhancedMonitoringResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, EnableEnhancedMonitoringResponse> {
    private final String streamName;
    private final List<String> currentShardLevelMetrics;
    private final List<String> desiredShardLevelMetrics;

    private EnableEnhancedMonitoringResponse(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.currentShardLevelMetrics = builder.currentShardLevelMetrics;
        this.desiredShardLevelMetrics = builder.desiredShardLevelMetrics;
    }

    public String streamName() {
        return this.streamName;
    }

    public List<String> currentShardLevelMetrics() {
        return this.currentShardLevelMetrics;
    }

    public List<String> desiredShardLevelMetrics() {
        return this.desiredShardLevelMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.streamName() == null ? 0 : this.streamName().hashCode());
        hashCode = 31 * hashCode + (this.currentShardLevelMetrics() == null ? 0 : this.currentShardLevelMetrics().hashCode());
        hashCode = 31 * hashCode + (this.desiredShardLevelMetrics() == null ? 0 : this.desiredShardLevelMetrics().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableEnhancedMonitoringResponse)) {
            return false;
        }
        EnableEnhancedMonitoringResponse other = (EnableEnhancedMonitoringResponse)((Object)obj);
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        if (other.streamName() != null && !other.streamName().equals(this.streamName())) {
            return false;
        }
        if (other.currentShardLevelMetrics() == null ^ this.currentShardLevelMetrics() == null) {
            return false;
        }
        if (other.currentShardLevelMetrics() != null && !other.currentShardLevelMetrics().equals(this.currentShardLevelMetrics())) {
            return false;
        }
        if (other.desiredShardLevelMetrics() == null ^ this.desiredShardLevelMetrics() == null) {
            return false;
        }
        return other.desiredShardLevelMetrics() == null || other.desiredShardLevelMetrics().equals(this.desiredShardLevelMetrics());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.streamName() != null) {
            sb.append("StreamName: ").append(this.streamName()).append(",");
        }
        if (this.currentShardLevelMetrics() != null) {
            sb.append("CurrentShardLevelMetrics: ").append(this.currentShardLevelMetrics()).append(",");
        }
        if (this.desiredShardLevelMetrics() != null) {
            sb.append("DesiredShardLevelMetrics: ").append(this.desiredShardLevelMetrics()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String streamName;
        private List<String> currentShardLevelMetrics = new SdkInternalList();
        private List<String> desiredShardLevelMetrics = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(EnableEnhancedMonitoringResponse model) {
            this.setStreamName(model.streamName);
            this.setCurrentShardLevelMetrics(model.currentShardLevelMetrics);
            this.setDesiredShardLevelMetrics(model.desiredShardLevelMetrics);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Collection<String> getCurrentShardLevelMetrics() {
            return this.currentShardLevelMetrics;
        }

        @Override
        public final Builder currentShardLevelMetrics(Collection<String> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copy(currentShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentShardLevelMetrics(String ... currentShardLevelMetrics) {
            if (this.currentShardLevelMetrics == null) {
                this.currentShardLevelMetrics = new SdkInternalList(currentShardLevelMetrics.length);
            }
            for (String e : currentShardLevelMetrics) {
                this.currentShardLevelMetrics.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentShardLevelMetrics(MetricsName ... currentShardLevelMetrics) {
            if (this.currentShardLevelMetrics == null) {
                this.currentShardLevelMetrics = new SdkInternalList(currentShardLevelMetrics.length);
            }
            for (MetricsName ele : currentShardLevelMetrics) {
                this.currentShardLevelMetrics.add(ele.toString());
            }
            return this;
        }

        public final void setCurrentShardLevelMetrics(Collection<String> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copy(currentShardLevelMetrics);
        }

        @SafeVarargs
        public final void setCurrentShardLevelMetrics(String ... currentShardLevelMetrics) {
            if (this.currentShardLevelMetrics == null) {
                this.currentShardLevelMetrics = new SdkInternalList(currentShardLevelMetrics.length);
            }
            for (String e : currentShardLevelMetrics) {
                this.currentShardLevelMetrics.add(e);
            }
        }

        @SafeVarargs
        public final void setCurrentShardLevelMetrics(MetricsName ... currentShardLevelMetrics) {
            if (this.currentShardLevelMetrics == null) {
                this.currentShardLevelMetrics = new SdkInternalList(currentShardLevelMetrics.length);
            }
            for (MetricsName ele : currentShardLevelMetrics) {
                this.currentShardLevelMetrics.add(ele.toString());
            }
        }

        public final Collection<String> getDesiredShardLevelMetrics() {
            return this.desiredShardLevelMetrics;
        }

        @Override
        public final Builder desiredShardLevelMetrics(Collection<String> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copy(desiredShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredShardLevelMetrics(String ... desiredShardLevelMetrics) {
            if (this.desiredShardLevelMetrics == null) {
                this.desiredShardLevelMetrics = new SdkInternalList(desiredShardLevelMetrics.length);
            }
            for (String e : desiredShardLevelMetrics) {
                this.desiredShardLevelMetrics.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredShardLevelMetrics(MetricsName ... desiredShardLevelMetrics) {
            if (this.desiredShardLevelMetrics == null) {
                this.desiredShardLevelMetrics = new SdkInternalList(desiredShardLevelMetrics.length);
            }
            for (MetricsName ele : desiredShardLevelMetrics) {
                this.desiredShardLevelMetrics.add(ele.toString());
            }
            return this;
        }

        public final void setDesiredShardLevelMetrics(Collection<String> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copy(desiredShardLevelMetrics);
        }

        @SafeVarargs
        public final void setDesiredShardLevelMetrics(String ... desiredShardLevelMetrics) {
            if (this.desiredShardLevelMetrics == null) {
                this.desiredShardLevelMetrics = new SdkInternalList(desiredShardLevelMetrics.length);
            }
            for (String e : desiredShardLevelMetrics) {
                this.desiredShardLevelMetrics.add(e);
            }
        }

        @SafeVarargs
        public final void setDesiredShardLevelMetrics(MetricsName ... desiredShardLevelMetrics) {
            if (this.desiredShardLevelMetrics == null) {
                this.desiredShardLevelMetrics = new SdkInternalList(desiredShardLevelMetrics.length);
            }
            for (MetricsName ele : desiredShardLevelMetrics) {
                this.desiredShardLevelMetrics.add(ele.toString());
            }
        }

        public EnableEnhancedMonitoringResponse build() {
            return new EnableEnhancedMonitoringResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnableEnhancedMonitoringResponse> {
        public Builder streamName(String var1);

        public Builder currentShardLevelMetrics(Collection<String> var1);

        public Builder currentShardLevelMetrics(String ... var1);

        public Builder currentShardLevelMetrics(MetricsName ... var1);

        public Builder desiredShardLevelMetrics(Collection<String> var1);

        public Builder desiredShardLevelMetrics(String ... var1);

        public Builder desiredShardLevelMetrics(MetricsName ... var1);
    }
}

